/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.util;

import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1058;
import net.minecraft.class_11515;
import net.minecraft.class_2350;
import org.jetbrains.annotations.Nullable;

public final class QuadUtil {
    public static void interpolate(MutableQuadView quad, class_1058 oldSprite, class_1058 newSprite) {
        float oldMinU = oldSprite.method_4594();
        float oldMinV = oldSprite.method_4593();
        float newMinU = newSprite.method_4594();
        float newMinV = newSprite.method_4593();
        float uFactor = (newSprite.method_4577() - newMinU) / (oldSprite.method_4577() - oldMinU);
        float vFactor = (newSprite.method_4575() - newMinV) / (oldSprite.method_4575() - oldMinV);
        for (int i = 0; i < 4; ++i) {
            quad.uv(i, newMinU + (quad.u(i) - oldMinU) * uFactor, newMinV + (quad.v(i) - oldMinV) * vFactor);
        }
    }

    public static void emitOverlayQuad(QuadEmitter emitter, class_2350 face, class_1058 sprite, int color, @Nullable class_11515 renderLayer, TriState ao) {
        emitter.square(face, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f);
        emitter.color(color, color, color, color);
        emitter.spriteBake(sprite, 4);
        emitter.renderLayer(renderLayer);
        emitter.ambientOcclusion(ao);
        emitter.emit();
    }

    public static boolean isQuadUnitSquare(QuadView quad) {
        int indexB;
        int indexA;
        switch (quad.lightFace().method_10166()) {
            case field_11048: {
                indexA = 1;
                indexB = 2;
                break;
            }
            case field_11052: {
                indexA = 0;
                indexB = 2;
                break;
            }
            case field_11051: {
                indexA = 1;
                indexB = 0;
                break;
            }
            default: {
                return false;
            }
        }
        for (int i = 0; i < 4; ++i) {
            float a = quad.posByIndex(i, indexA);
            if ((a >= 1.0E-4f || a <= -1.0E-4f) && (a >= 1.0001f || a <= 0.9999f)) {
                return false;
            }
            float b = quad.posByIndex(i, indexB);
            if (!(b >= 1.0E-4f) && !(b <= -1.0E-4f) || !(b >= 1.0001f) && !(b <= 0.9999f)) continue;
            return false;
        }
        return true;
    }

    public static int getTextureOrientation(QuadView quad) {
        int yAxisSign;
        int yAxis;
        int xAxisSign;
        int xAxis;
        float tm00 = quad.u(3) - quad.u(1);
        float tm01 = quad.v(3) - quad.v(1);
        float tm10 = quad.u(2) - quad.u(0);
        float tm11 = quad.v(2) - quad.v(0);
        float determinant = tm00 * tm11 - tm10 * tm01;
        if (determinant == 0.0f) {
            return 0;
        }
        float s = 1.0f / determinant;
        float itm10 = -tm10 * s;
        float itm11 = tm00 * s;
        switch (quad.lightFace()) {
            case field_11033: {
                xAxis = 0;
                xAxisSign = 1;
                yAxis = 2;
                yAxisSign = 1;
                break;
            }
            case field_11036: {
                xAxis = 0;
                xAxisSign = 1;
                yAxis = 2;
                yAxisSign = -1;
                break;
            }
            case field_11043: {
                xAxis = 0;
                xAxisSign = -1;
                yAxis = 1;
                yAxisSign = 1;
                break;
            }
            case field_11035: {
                xAxis = 0;
                xAxisSign = 1;
                yAxis = 1;
                yAxisSign = 1;
                break;
            }
            case field_11039: {
                xAxis = 2;
                xAxisSign = 1;
                yAxis = 1;
                yAxisSign = 1;
                break;
            }
            case field_11034: {
                xAxis = 2;
                xAxisSign = -1;
                yAxis = 1;
                yAxisSign = 1;
                break;
            }
            default: {
                return 0;
            }
        }
        float pm00 = quad.posByIndex(3, xAxis) - quad.posByIndex(1, xAxis);
        float pm01 = quad.posByIndex(3, yAxis) - quad.posByIndex(1, yAxis);
        float pm10 = quad.posByIndex(2, xAxis) - quad.posByIndex(0, xAxis);
        float pm11 = quad.posByIndex(2, yAxis) - quad.posByIndex(0, yAxis);
        float x = -(pm00 * itm10 + pm10 * itm11) * (float)xAxisSign;
        float y = -(pm01 * itm10 + pm11 * itm11) * (float)yAxisSign;
        return (Math.abs(y) >= Math.abs(x) ? (y > 0.0f ? 0 : 2) : (x > 0.0f ? 3 : 1)) + (determinant < 0.0f ? 4 : 0);
    }
}

