/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.command.manager.Command;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class ClaimKillCommand
extends Command {
    @Override
    public boolean isAllowed() {
        return Main.currentSeason.getSeason() != Seasons.UNASSIGNED;
    }

    @Override
    public class_2561 getBannedText() {
        return class_2561.method_30163((String)"This command is only available when you have selected a Season.");
    }

    @Override
    public List<String> getAdminCommands() {
        return List.of("claimkill");
    }

    @Override
    public List<String> getNonAdminCommands() {
        return List.of("claimkill");
    }

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClaimKillCommand.literal("claimkill").then(ClaimKillCommand.argument("player", class_2186.method_9305()).suggests((context, builder) -> class_2172.method_9265(this.getSuggestions(), (SuggestionsBuilder)builder)).executes(context -> this.claimCredit((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"))))).then(((LiteralArgumentBuilder)ClaimKillCommand.literal("validate").requires(PermissionManager::isAdmin)).then(ClaimKillCommand.argument("killer", class_2186.method_9305()).then(ClaimKillCommand.argument("victim", class_2186.method_9305()).executes(context -> this.claimCreditAccept((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"killer"), class_2186.method_9315((CommandContext)context, (String)"victim")))))));
    }

    public List<String> getSuggestions() {
        if (Main.server == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> suggestions = new ArrayList<String>();
        Set<UUID> recentDeaths = Main.currentSession.playerNaturalDeathLog.keySet();
        for (UUID uuid : recentDeaths) {
            class_3222 player = PlayerUtils.getPlayer(uuid);
            if (player == null) continue;
            suggestions.add(player.method_5820());
        }
        return suggestions;
    }

    public int claimCredit(class_2168 source, class_3222 victim) {
        UUID victimUUID;
        if (this.checkBanned(source)) {
            return -1;
        }
        if (victim == null) {
            return -1;
        }
        class_3222 player = source.method_44023();
        if (player == null) {
            return -1;
        }
        Set<UUID> recentDeaths = Main.currentSession.playerNaturalDeathLog.keySet();
        if (!recentDeaths.contains(victimUUID = victim.method_5667())) {
            source.method_9213((class_2561)TextUtils.formatPlain("{} did not die in the last 2 minutes. Or they might have been killed by a player directly.", victim));
            return -1;
        }
        if (player == victim) {
            source.method_9213(class_2561.method_30163((String)"You cannot claim credit for your own death :P"));
            return -1;
        }
        class_5250 textAll = TextUtils.format("{}\u00a77 claims credit for {}\u00a77's death.", player, victim);
        PlayerUtils.broadcastMessageToAdmins((class_2561)textAll, 200);
        String validateCommand = TextUtils.formatString("/claimkill validate {} {}", player, victim);
        class_5250 adminText = TextUtils.format("\u00a77Click {}\u00a77 to accept the claim if you think it's valid.", TextUtils.runCommandText(validateCommand));
        PlayerUtils.broadcastMessageToAdmins((class_2561)adminText, 200);
        return 1;
    }

    public int claimCreditAccept(class_2168 source, class_3222 killer, class_3222 victim) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (killer == null) {
            return -1;
        }
        if (victim == null) {
            return -1;
        }
        class_5250 message = TextUtils.format("{}\u00a77's kill claim on {}\u00a77 was accepted.", killer, victim);
        PlayerUtils.broadcastMessage((class_2561)message);
        Main.currentSeason.onClaimKill(killer, victim);
        Main.currentSession.playerNaturalDeathLog.remove(victim.method_5667());
        return 1;
    }
}

