/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.command.manager.Command;
import net.mat0u5.lifeseries.seasons.season.Season;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.doublelife.DoubleLife;
import net.mat0u5.lifeseries.seasons.season.limitedlife.LimitedLife;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.other.Time;
import net.mat0u5.lifeseries.utils.world.AnimationUtils;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class GivelifeCommand
extends Command {
    private Map<UUID, Map<UUID, Long>> soulmateGivelifeRequests = new HashMap<UUID, Map<UUID, Long>>();

    @Override
    public boolean isAllowed() {
        return (Boolean)Main.seasonConfig.GIVELIFE_COMMAND_ENABLED.get(Main.seasonConfig);
    }

    @Override
    public class_2561 getBannedText() {
        return class_2561.method_30163((String)"This command is only available when the givelife command has been enabled in the Life Series config.");
    }

    @Override
    public List<String> getAdminCommands() {
        return List.of("givelife");
    }

    @Override
    public List<String> getNonAdminCommands() {
        return List.of("givelife");
    }

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)GivelifeCommand.literal("givelife").then(GivelifeCommand.argument("player", class_2186.method_9305()).executes(context -> this.giftLife((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player")))));
    }

    public int giftLife(class_2168 source, class_3222 target) {
        DoubleLife doubleLife;
        class_3222 soulmate;
        Integer currentLives;
        String livesOrTime;
        if (this.checkBanned(source)) {
            return -1;
        }
        class_3222 self = source.method_44023();
        if (self == null) {
            return -1;
        }
        if (target == null) {
            return -1;
        }
        String string = livesOrTime = Main.currentSeason.getSeason() != Seasons.LIMITED_LIFE ? "lives" : "time";
        if (self.ls$isDead()) {
            source.method_9213((class_2561)TextUtils.format("You do not have any {} to give", livesOrTime));
            return -1;
        }
        boolean isRevive = target.ls$isDead();
        if (!Season.GIVELIFE_CAN_REVIVE && isRevive) {
            source.method_9213(class_2561.method_30163((String)"That player is not alive"));
            return -1;
        }
        if (target == self) {
            source.method_9213((class_2561)TextUtils.format("You cannot give {} to yourself", livesOrTime));
            return -1;
        }
        int giveAmount = 1;
        if (Main.currentSeason.getSeason() == Seasons.LIMITED_LIFE) {
            giveAmount = -LimitedLife.NEW_DEATH_NORMAL.getSeconds();
        }
        if ((currentLives = self.ls$getLives()) == null || currentLives <= giveAmount) {
            source.method_9213((class_2561)TextUtils.format("You cannot give away any more {}", livesOrTime));
            return -1;
        }
        Integer targetLives = target.ls$getLives();
        if (targetLives == null || targetLives >= Main.currentSeason.GIVELIFE_MAX_LIVES) {
            source.method_9213((class_2561)TextUtils.format("That player cannot receive any more {}", livesOrTime));
            return -1;
        }
        Season season = Main.currentSeason;
        if (season instanceof DoubleLife && (soulmate = (doubleLife = (DoubleLife)season).getSoulmate(self)) != null) {
            if (soulmate.equals((Object)target)) {
                source.method_9213((class_2561)TextUtils.format("You cannot give {} to your soulmate", livesOrTime));
                return -1;
            }
            boolean success = this.doubleLifeGiveLife(source, self, soulmate, target);
            if (!success) {
                return -1;
            }
        }
        class_2561 currentPlayerName = self.method_5476();
        self.ls$addLives(-giveAmount);
        Main.livesManager.addToLivesNoUpdate(target, giveAmount);
        AnimationUtils.playTotemAnimation(self);
        TaskScheduler.scheduleTask(Time.seconds(2), () -> Main.livesManager.receiveLifeFromOtherPlayer(currentPlayerName, target, isRevive));
        Season season2 = Main.currentSeason;
        if (season2 instanceof DoubleLife) {
            DoubleLife doubleLife2 = (DoubleLife)season2;
            doubleLife2.syncSoulboundLives(self);
        }
        return 1;
    }

    public boolean doubleLifeGiveLife(class_2168 source, class_3222 self, class_3222 soulmate, class_3222 target) {
        Map<UUID, Long> soulmateRequest = this.soulmateGivelifeRequests.get(soulmate.method_5667());
        if (soulmateRequest != null) {
            for (Map.Entry<UUID, Long> entry : soulmateRequest.entrySet()) {
                UUID soulmateRequestTarget = entry.getKey();
                long requestTime = entry.getValue();
                if (!soulmateRequestTarget.equals(target.method_5667()) || System.currentTimeMillis() - requestTime > 60000L) continue;
                soulmateRequest.remove(soulmateRequestTarget);
                return true;
            }
        }
        if (this.soulmateGivelifeRequests.containsKey(self.method_5667())) {
            this.soulmateGivelifeRequests.get(self.method_5667()).put(target.method_5667(), System.currentTimeMillis());
        } else {
            HashMap<UUID, Long> request = new HashMap<UUID, Long>();
            request.put(target.method_5667(), System.currentTimeMillis());
            this.soulmateGivelifeRequests.put(self.method_5667(), request);
        }
        OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"\u00a77Your soulmate must accept your request to give a life to this player."));
        class_5250 message = TextUtils.format("Your soulmate wants to give a life to {}.\nClick {} to accept the request.", target, TextUtils.runCommandText(TextUtils.formatString("/givelife {}", target.method_5820())));
        soulmate.method_64398((class_2561)message);
        return false;
    }
}

