/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.List;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.command.manager.Command;
import net.mat0u5.lifeseries.seasons.other.WatcherManager;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class WatcherCommand
extends Command {
    @Override
    public boolean isAllowed() {
        return Main.currentSeason.getSeason() != Seasons.UNASSIGNED;
    }

    @Override
    public class_2561 getBannedText() {
        return class_2561.method_30163((String)"This command is only available when you have selected a series.");
    }

    @Override
    public List<String> getAdminCommands() {
        return List.of("watcher");
    }

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)WatcherCommand.literal("watcher").requires(PermissionManager::isAdmin)).executes(context -> this.info((class_2168)context.getSource()))).then(WatcherCommand.literal("info").executes(context -> this.info((class_2168)context.getSource())))).then(WatcherCommand.literal("list").executes(context -> this.listWatchers((class_2168)context.getSource())))).then(WatcherCommand.literal("add").then(WatcherCommand.argument("player", class_2186.method_9308()).executes(context -> this.addWatchers((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player")))))).then(WatcherCommand.literal("remove").then(WatcherCommand.argument("player", class_2186.method_9308()).executes(context -> this.removeWatchers((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"))))));
    }

    public int info(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"\u00a77Watchers are players that are online, but are not affected by most season mechanics. They can only observe."));
        OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"\u00a77This is very useful for spectators and for admins."));
        return 1;
    }

    public int listWatchers(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (WatcherManager.getWatchers().isEmpty()) {
            source.method_9213(class_2561.method_30163((String)"There are no Watchers right now"));
            return -1;
        }
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.formatLoosely("Current Watchers: \u00a77{}", WatcherManager.getWatchers()));
        return 1;
    }

    public int addWatchers(class_2168 source, Collection<class_3222> targets) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (targets == null || targets.isEmpty()) {
            return -1;
        }
        targets.forEach(WatcherManager::addWatcher);
        WatcherManager.reloadWatchers();
        if (targets.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("{} is now a Watcher", targets.iterator().next()));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("{} targets are now Watchers", targets.size()));
        }
        return 1;
    }

    public int removeWatchers(class_2168 source, Collection<class_3222> targets) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (targets == null || targets.isEmpty()) {
            return -1;
        }
        targets.forEach(WatcherManager::removeWatcher);
        WatcherManager.reloadWatchers();
        if (targets.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("{} is no longer a Watcher", targets.iterator().next()));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("{} targets are no longer Watchers", targets.size()));
        }
        return 1;
    }
}

