/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.config;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.MainClient;
import net.mat0u5.lifeseries.config.ClientConfig;
import net.mat0u5.lifeseries.config.ConfigFileEntry;
import net.mat0u5.lifeseries.config.entries.BooleanObject;
import net.mat0u5.lifeseries.config.entries.ConfigObject;
import net.mat0u5.lifeseries.config.entries.DoubleObject;
import net.mat0u5.lifeseries.config.entries.IntegerObject;
import net.mat0u5.lifeseries.config.entries.NullableIntegerObject;
import net.mat0u5.lifeseries.config.entries.StringObject;
import net.mat0u5.lifeseries.config.entries.TextObject;
import net.mat0u5.lifeseries.gui.config.entries.ConfigEntry;
import net.mat0u5.lifeseries.network.packets.ConfigPayload;
import net.mat0u5.lifeseries.utils.ClientResourcePacks;
import net.mat0u5.lifeseries.utils.enums.ConfigTypes;

@Environment(value=EnvType.CLIENT)
public class ClientConfigNetwork {
    public static Map<Integer, ConfigObject> configObjects = new TreeMap<Integer, ConfigObject>();
    public static Map<Integer, ConfigObject> clientConfigObjects = new TreeMap<Integer, ConfigObject>();

    public static void load() {
        configObjects.clear();
        clientConfigObjects.clear();
        int index = 0;
        for (ConfigFileEntry<?> entry : MainClient.clientConfig.getAllConfigEntries()) {
            ClientConfigNetwork.handleConfigPacket(MainClient.clientConfig.getConfigPayload(entry, index), true);
            ++index;
        }
    }

    public static void handleConfigPacket(ConfigPayload payload, boolean client) {
        int index = payload.index();
        ConfigObject configObject = ClientConfigNetwork.getConfigEntry(payload);
        if (configObject == null) {
            return;
        }
        if (!client) {
            configObjects.put(index, configObject);
        } else {
            clientConfigObjects.put(index, configObject);
        }
    }

    public static ConfigObject getConfigEntry(ConfigPayload payload) {
        ConfigTypes configType = ConfigTypes.getFromString(payload.configType());
        String id = payload.id();
        String name = payload.name();
        String description = payload.description();
        List<String> args = payload.args();
        if (args.size() < 3) {
            return null;
        }
        String argValue = args.get(0);
        String argDefaultValue = args.get(1);
        String argGroupInfo = args.get(2);
        if (configType.parentText()) {
            boolean clickable = !argDefaultValue.equalsIgnoreCase("false");
            return new TextObject(payload, name, clickable);
        }
        if (configType.parentString()) {
            return new StringObject(payload, argValue, argDefaultValue);
        }
        if (configType.parentBoolean()) {
            boolean value = argValue.equalsIgnoreCase("true");
            boolean defaultValue = argDefaultValue.equalsIgnoreCase("true");
            return new BooleanObject(payload, value, defaultValue);
        }
        if (configType.parentDouble()) {
            try {
                double value = Double.parseDouble(argValue);
                double defaultValue = Double.parseDouble(argDefaultValue);
                return new DoubleObject(payload, value, defaultValue);
            }
            catch (Exception value) {
                // empty catch block
            }
        }
        if (configType.parentInteger()) {
            try {
                int value = Integer.parseInt(argValue);
                int defaultValue = Integer.parseInt(argDefaultValue);
                return new IntegerObject(payload, value, defaultValue);
            }
            catch (Exception value) {
                // empty catch block
            }
        }
        if (configType.parentNullableInteger()) {
            Integer value = null;
            Integer defaultValue = null;
            try {
                value = Integer.parseInt(argValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                defaultValue = Integer.parseInt(argDefaultValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                return new NullableIntegerObject(payload, value, defaultValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static void onConfigSave(ConfigEntry entry) {
        String id = entry.getFieldName();
        String valueStr = entry.getValueAsString();
        MainClient.clientConfig.setProperty(id, valueStr);
        if (id.equals(ClientConfig.MINIMAL_ARMOR.key)) {
            ClientResourcePacks.checkClientPacks();
        }
    }
}

