/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.config.ConfigFileEntry;
import net.mat0u5.lifeseries.config.DefaultConfigValues;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.network.packets.ConfigPayload;
import net.mat0u5.lifeseries.utils.enums.ConfigTypes;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.player.ScoreboardUtils;
import net.mat0u5.lifeseries.utils.world.DatapackIntegration;
import net.minecraft.class_1937;
import net.minecraft.class_268;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_9011;

public abstract class ConfigManager
extends DefaultConfigValues {
    protected Properties properties = new Properties();
    protected String folderPath;
    protected String filePath;

    protected ConfigManager(String folderPath, String filePath) {
        this.folderPath = folderPath;
        this.filePath = folderPath + "/" + filePath;
        this.createFileIfNotExists();
        this.loadProperties();
        this.renamedProperties();
        this.instantiateProperties();
    }

    protected List<ConfigFileEntry<?>> getDefaultConfigEntries() {
        return new ArrayList(List.of(this.GROUP_GLOBAL, this.GROUP_SEASON, this.GROUP_LIVES, this.GROUP_TEAMS, this.GROUP_EVENTS, this.GROUP_GLOBAL_LIVES, this.DEFAULT_LIVES, this.ONLY_TAKE_LIVES_IN_SESSION, this.TAB_LIST_SHOW_LIVES, this.LIVES_SYSTEM_DISABLED, this.MAX_PLAYER_HEALTH, this.KEEP_INVENTORY, this.WORLDBORDER_GROUP, this.WORLDBORDER_SIZE, this.WORLDBORDER_NETHER_SIZE, this.WORLDBORDER_END_SIZE, this.LOCATOR_BAR, this.ALLOW_SELF_DEFENSE, this.SEE_FRIENDLY_INVISIBLE_PLAYERS, this.SHOW_LOGIN_COMMAND_INFO, this.HIDE_UNJUSTIFIED_KILL_MESSAGES, this.SHOW_ADVANCEMENTS, this.TICK_FREEZE_NOT_IN_SESSION, this.BROADCAST_LIFE_GAIN, this.ADDITIONAL_WITHER_SKULL_RATE, this.GROUP_BLACKLIST, this.BOOGEYMAN, this.SECRET_SOCIETY, this.GIVELIFE_COMMAND_ENABLED, this.GROUP_FINAL_DEATH, this.CUSTOM_ENCHANTER_ALGORITHM, this.MUTE_DEAD_PLAYERS, this.TAB_LIST_SHOW_DEAD_PLAYERS, this.GROUP_SPAWN_EGG, this.GROUP_WATCHERS, this.SHOW_HEALTH_BELOW_NAME, this.BLACKLIST_ITEMS, this.BLACKLIST_RECIPES, this.BLACKLIST_BLOCKS, this.BLACKLIST_CLAMPED_ENCHANTS, this.BLACKLIST_BANNED_ENCHANTS, this.BLACKLIST_BANNED_POTION_EFFECTS, this.BLACKLIST_CLAMPED_POTION_EFFECTS, this.CREATIVE_IGNORE_BLACKLIST, this.BOOGEYMAN_MIN_AMOUNT, this.BOOGEYMAN_MAX_AMOUNT, this.BOOGEYMAN_ADVANCED_DEATHS, this.BOOGEYMAN_CHANCE_MULTIPLIER, this.BOOGEYMAN_IGNORE, this.BOOGEYMAN_FORCE, this.BOOGEYMAN_MESSAGE, this.BOOGEYMAN_CHOOSE_MINUTE, this.BOOGEYMAN_ANNOUNCE_OUTCOME, this.BOOGEYMAN_INFINITE, this.BOOGEYMAN_INFINITE_LAST_PICK, this.BOOGEYMAN_INFINITE_AUTO_FAIL, this.BOOGEYMAN_TEAM_NOTICE, this.BOOGEYMAN_KILLS_NEEDED, this.BOOGEYMAN_STEAL_LIFE, this.SECRET_SOCIETY_MEMBER_AMOUNT, this.SECRET_SOCIETY_START_TIME, this.SECRET_SOCIETY_WORDS, this.SECRET_SOCIETY_FORCE, this.SECRET_SOCIETY_IGNORE, this.SECRET_SOCIETY_PUNISHMENT_LIVES, this.SECRET_SOCIETY_KILLS_REQUIRED, this.SECRET_SOCIETY_SOUND_ONLY_MEMBERS, this.PLAYERS_DROP_ITEMS_ON_FINAL_DEATH, this.FINAL_DEATH_TITLE_SHOW, this.FINAL_DEATH_TITLE_SUBTITLE, this.FINAL_DEATH_MESSAGE, this.FINAL_DEATH_LIGHTNING, this.FINAL_DEATH_SOUND, this.GIVELIFE_LIVES_MAX, this.GIVELIFE_BROADCAST, this.GIVELIFE_CAN_REVIVE, this.TAB_LIST_SHOW_EXACT_LIVES, this.SPAWN_EGG_DROP_CHANCE, this.SPAWN_EGG_DROP_ONLY_NATURAL, this.SPAWN_EGG_ALLOW_ON_SPAWNER, this.SPAWNER_RECIPE, this.WATCHERS_IN_TAB, this.WATCHERS_MUTED));
    }

    protected List<ConfigFileEntry<?>> getSeasonSpecificConfigEntries() {
        return new ArrayList(List.of(this.NO_SEASON_SPECIFIC));
    }

    protected List<ConfigFileEntry<?>> getAllConfigEntries() {
        ArrayList allEntries = new ArrayList();
        allEntries.addAll(this.getDefaultConfigEntries());
        allEntries.addAll(this.getSeasonSpecificConfigEntries());
        return allEntries;
    }

    protected void instantiateProperties() {
        for (ConfigFileEntry<?> entry : this.getAllConfigEntries()) {
            Object t = entry.defaultValue;
            if (t instanceof Integer) {
                Integer integerValue = (Integer)t;
                this.getOrCreateInt(entry.key, integerValue);
                continue;
            }
            t = entry.defaultValue;
            if (t instanceof Boolean) {
                Boolean booleanValue = (Boolean)t;
                this.getOrCreateBoolean(entry.key, booleanValue);
                continue;
            }
            t = entry.defaultValue;
            if (t instanceof Double) {
                Double doubleValue = (Double)t;
                this.getOrCreateDouble(entry.key, doubleValue);
                continue;
            }
            t = entry.defaultValue;
            if (!(t instanceof String)) continue;
            String stringValue = (String)t;
            this.getOrCreateProperty(entry.key, stringValue);
        }
    }

    public void sendConfigTo(class_3222 player) {
        ConfigFileEntry<Integer> lifeEntry;
        int index = 0;
        for (ConfigFileEntry<?> configFileEntry : this.getAllConfigEntries()) {
            this.sendConfigEntry(player, configFileEntry, index);
            ++index;
        }
        for (class_9011 class_90112 : ScoreboardUtils.getScores("Lives")) {
            lifeEntry = new ConfigFileEntry<Integer>("dynamic_lives_" + class_90112.comp_2127(), Integer.valueOf(class_90112.comp_2128()), ConfigTypes.LIVES_ENTRY, "lives", class_90112.comp_2127(), "", true);
            this.sendConfigEntry(player, lifeEntry, index);
            ++index;
        }
        for (class_3222 class_32222 : Main.livesManager.getNonAssignedPlayers()) {
            lifeEntry = new ConfigFileEntry<Object>("dynamic_lives_" + class_32222.method_5820(), null, ConfigTypes.LIVES_ENTRY, "lives", class_32222.method_5820(), "", true);
            this.sendConfigEntry(player, lifeEntry, index);
            ++index;
        }
        for (Map.Entry entry : Main.livesManager.getLivesTeams().entrySet()) {
            class_268 team = (class_268)entry.getValue();
            String teamName = team.method_1197();
            int teamNum = (Integer)entry.getKey();
            Integer validKill = Main.livesManager.getTeamCanKill(teamName);
            Integer gainLife = Main.livesManager.getTeamGainLives(teamName);
            String validKillStr = validKill != null ? String.valueOf(validKill) : "";
            String gainLifeStr = gainLife != null ? String.valueOf(gainLife) : "";
            ConfigFileEntry<Object> teamEntry = new ConfigFileEntry<Object>("dynamic_teams_" + String.valueOf(UUID.randomUUID()), null, ConfigTypes.TEAM_ENTRY, "teams", "", "", List.of(String.valueOf(teamNum), team.method_1140().getString(), team.method_1202().method_537(), validKillStr, gainLifeStr), true);
            this.sendConfigEntry(player, teamEntry, index);
            ++index;
        }
        for (DatapackIntegration.Events events : DatapackIntegration.getAllEvents()) {
            ConfigFileEntry<String> teamEntry = new ConfigFileEntry<String>(events.getEventName(), events.getCommand(), ConfigTypes.EVENT_ENTRY, "events", events.getDisplayName(), events.getDescription(), List.of(events.getCanceled()), true);
            this.sendConfigEntry(player, teamEntry, index);
            ++index;
        }
    }

    public void sendConfigEntry(class_3222 player, ConfigFileEntry<?> entry, int index) {
        NetworkHandlerServer.sendConfig(player, this.getConfigPayload(entry, index));
    }

    public ConfigPayload getConfigPayload(ConfigFileEntry<?> entry, int index) {
        String value = "";
        if (!entry.type.parentText() && !entry.dynamic) {
            value = this.getPropertyAsString(entry.key, entry.defaultValue);
        }
        String defaultValue = "";
        if (entry.defaultValue != null) {
            defaultValue = entry.defaultValue.toString();
            if (entry.dynamic) {
                value = entry.defaultValue.toString();
            }
        }
        ArrayList<String> args = new ArrayList<String>(List.of(value, defaultValue, entry.groupInfo));
        if (entry.args != null) {
            args.addAll(entry.args);
        }
        return new ConfigPayload(entry.type.toString(), entry.key, index, entry.displayName, entry.description, args);
    }

    private String getPropertyAsString(String key, Object defaultValue) {
        if (defaultValue instanceof Integer) {
            Integer intValue = (Integer)defaultValue;
            return String.valueOf(this.getOrCreateInt(key, intValue));
        }
        if (defaultValue instanceof Boolean) {
            Boolean booleanValue = (Boolean)defaultValue;
            return String.valueOf(this.getOrCreateBoolean(key, booleanValue));
        }
        if (defaultValue instanceof Double) {
            Double doubleValue = (Double)defaultValue;
            return String.valueOf(this.getOrCreateDouble(key, doubleValue));
        }
        if (defaultValue instanceof String) {
            String stringValue = (String)defaultValue;
            return this.getOrCreateProperty(key, stringValue);
        }
        if (defaultValue == null) {
            return "";
        }
        return defaultValue.toString();
    }

    protected void renamedProperties() {
        this.renamedProperty("show_death_title_on_last_death", "final_death_title_show");
        this.renamedProperty("players_drop_items_on_last_death", "players_drop_items_on_final_death");
        this.renamedProperty("blacklist_banned_potions", "blacklist_banned_potion_effects");
        this.renamedProperty("auto_keep_inventory", "keep_inventory");
        this.renamedProperty("beoadcast_secret_keeper", "broadcast_secret_keeper");
    }

    private void renamedProperty(String from, String to) {
        if (this.properties.containsKey(from)) {
            String value;
            if (!this.properties.containsKey(to) && (value = this.getProperty(from)) != null) {
                this.setProperty(to, value);
            }
            this.removeProperty(from);
        }
    }

    public static void onUpdatedBoolean(String id, boolean value) {
        if (id.equals(Main.seasonConfig.TICK_FREEZE_NOT_IN_SESSION.key)) {
            Main.currentSession.freezeIfNecessary();
            if (!value) {
                OtherUtils.setFreezeGame(false);
            }
        }
    }

    public static void onUpdatedInteger(String id, int value) {
        class_3218 end;
        class_3218 nether;
        class_3218 overworld;
        if (Main.server == null) {
            return;
        }
        if (id.equals(Main.seasonConfig.WORLDBORDER_SIZE.key) && (overworld = Main.server.method_3847(class_1937.field_25179)) != null) {
            overworld.method_8621().method_11969((double)value);
        }
        if (id.equals(Main.seasonConfig.WORLDBORDER_NETHER_SIZE.key) && (nether = Main.server.method_3847(class_1937.field_25180)) != null) {
            nether.method_8621().method_11969((double)value);
        }
        if (id.equals(Main.seasonConfig.WORLDBORDER_END_SIZE.key) && (end = Main.server.method_3847(class_1937.field_25181)) != null) {
            end.method_8621().method_11969((double)value);
        }
    }

    public static void moveOldMainFileIfExists() {
        File newFolder = new File("./config/lifeseries/main/");
        if (!newFolder.exists() && !newFolder.mkdirs()) {
            Main.LOGGER.error("Failed to create folder {}", (Object)newFolder);
            return;
        }
        File oldFile = new File("./config/lifeseries.properties");
        if (!oldFile.exists()) {
            return;
        }
        File newFile = new File("./config/lifeseries/main/lifeseries.properties");
        if (newFile.exists()) {
            if (oldFile.delete()) {
                Main.LOGGER.info("Deleted old config file.");
            }
        } else {
            try {
                Files.move(oldFile.toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                Main.LOGGER.info("Moved old config file.");
            }
            catch (IOException e) {
                Main.LOGGER.info("Failed to move old config file.");
            }
        }
    }

    private void createFileIfNotExists() {
        if (this.folderPath == null || this.filePath == null) {
            return;
        }
        File configDir = new File(this.folderPath);
        if (!configDir.exists() && !configDir.mkdirs()) {
            Main.LOGGER.error("Failed to create folder {}", (Object)configDir);
            return;
        }
        File configFile = new File(this.filePath);
        if (!configFile.exists()) {
            try {
                if (!configFile.createNewFile()) {
                    Main.LOGGER.error("Failed to create file {}", (Object)configFile);
                    return;
                }
                try (FileOutputStream output = new FileOutputStream(configFile);){
                    this.instantiateProperties();
                    this.properties.store(output, null);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void loadProperties() {
        if (this.folderPath == null || this.filePath == null) {
            return;
        }
        this.properties = new Properties();
        try (FileInputStream input = new FileInputStream(this.filePath);){
            this.properties.load(input);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void setOrRemoveProperty(String key, String value) {
        if (value == null || value.isEmpty()) {
            this.removeProperty(key);
        } else {
            this.setProperty(key, value);
        }
    }

    public void setProperty(String key, String value) {
        if (this.folderPath == null || this.filePath == null) {
            return;
        }
        this.properties.setProperty(key, value);
        try (FileOutputStream output = new FileOutputStream(this.filePath);){
            this.properties.store(output, null);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void removeProperty(String key) {
        if (this.folderPath == null || this.filePath == null) {
            return;
        }
        if (!this.properties.containsKey(key)) {
            return;
        }
        this.properties.remove(key);
        try (FileOutputStream output = new FileOutputStream(this.filePath);){
            this.properties.store(output, null);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void setPropertyCommented(String key, String value, String comment) {
        if (this.folderPath == null || this.filePath == null) {
            return;
        }
        this.properties.setProperty(key, value);
        try (FileOutputStream output = new FileOutputStream(this.filePath);){
            this.properties.store(output, comment);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void resetProperties(String comment) {
        this.properties.clear();
        try (FileOutputStream output = new FileOutputStream(this.filePath);){
            this.properties.store(output, comment);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public String getProperty(String key) {
        if (this.folderPath == null || this.filePath == null) {
            return null;
        }
        if (this.properties == null) {
            return null;
        }
        if (this.properties.containsKey(key)) {
            return this.properties.getProperty(key);
        }
        return null;
    }

    public String getOrCreateProperty(String key, String defaultValue) {
        if (this.folderPath == null || this.filePath == null) {
            return "";
        }
        if (this.properties == null) {
            return "";
        }
        if (this.properties.containsKey(key)) {
            return this.properties.getProperty(key);
        }
        this.setProperty(key, defaultValue);
        return defaultValue;
    }

    public boolean getOrCreateBoolean(String key, boolean defaultValue) {
        String value = this.getOrCreateProperty(key, String.valueOf(defaultValue));
        if (value == null) {
            return defaultValue;
        }
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        return defaultValue;
    }

    public double getOrCreateDouble(String key, double defaultValue) {
        String value = this.getOrCreateProperty(key, String.valueOf(defaultValue));
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public int getOrCreateInt(String key, int defaultValue) {
        String value = this.getOrCreateProperty(key, String.valueOf(defaultValue));
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }
}

