/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.entity.triviabot.server.trivia;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.entity.triviabot.TriviaBot;
import net.mat0u5.lifeseries.entity.triviabot.server.trivia.TriviaHandler;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.seasons.season.nicelife.NiceLifeTriviaManager;
import net.mat0u5.lifeseries.seasons.season.nicelife.NiceLifeVotingManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.trivia.TriviaQuestion;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.mat0u5.lifeseries.utils.other.IdentifierHelper;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.other.Time;
import net.mat0u5.lifeseries.utils.other.Tuple;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.world.ItemSpawner;
import net.mat0u5.lifeseries.utils.world.ItemStackUtils;
import net.mat0u5.lifeseries.utils.world.LevelUtils;
import net.minecraft.class_11580;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_2244;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_5321;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class NiceLifeTriviaHandler
extends TriviaHandler {
    public static ItemSpawner itemSpawner;
    public NiceLifeTriviaManager.TriviaSpawn spawnInfo;
    public BotState currentState = BotState.LANDING;
    private Time sameStateTime = Time.zero();
    private static class_243 botPosOffset;
    public List<class_1542> droppedItems = new ArrayList<class_1542>();

    public NiceLifeTriviaHandler(TriviaBot bot) {
        super(bot);
    }

    @Override
    public Tuple<Integer, TriviaQuestion> generateTrivia(class_3222 boundPlayer) {
        return NiceLifeTriviaManager.getTriviaQuestion(boundPlayer);
    }

    @Override
    public void setTimeBasedOnDifficulty(int difficulty) {
        this.timeToComplete = NiceLifeTriviaManager.QUESTION_TIME;
    }

    @Override
    public void tick() {
        super.tick();
        this.bot.pathfinding.noPathfinding = true;
        this.bot.field_5960 = true;
        this.bot.method_5875(true);
        class_3222 boundPlayer = this.bot.serverData.getBoundPlayer();
        class_3218 level = (class_3218)this.bot.method_73183();
        if (this.bot.waving() > 0) {
            this.bot.setWaving(this.bot.waving() - 1);
        }
        if (this.spawnInfo == null || boundPlayer == null) {
            this.bot.serverData.despawn();
            return;
        }
        if (boundPlayer != null && !boundPlayer.method_6113() && this.currentState != BotState.LEAVING && this.currentState != BotState.FLYING_UP && this.currentState != BotState.FINISHED) {
            NiceLifeTriviaManager.incorrectAnswers.add(this.bot.serverData.getBoundPlayerUUID());
            this.changeStateTo(BotState.LEAVING);
        }
        if (this.currentState == BotState.LANDING) {
            this.landingTick(level);
            this.bot.setGliding(true);
        } else {
            this.bot.setGliding(false);
        }
        if (this.currentState == BotState.LANDED) {
            this.landedTick(level, boundPlayer);
        }
        if (this.currentState == BotState.APPROACHING) {
            this.approachingTick(level, boundPlayer);
        }
        if (this.currentState == BotState.APPROACHED) {
            this.approachedTick(level, boundPlayer);
        }
        if (this.currentState == BotState.QUESTION) {
            this.questionTick(level, boundPlayer);
        }
        if (this.currentState == BotState.VOTING) {
            this.votingTick(level);
        }
        if (this.currentState == BotState.LEAVING) {
            this.leavingTick(level, boundPlayer);
        }
        if (this.currentState == BotState.FLYING_UP) {
            this.flyingUpTick(level);
        }
        if (this.bot.field_6012 % 2 == 0 && this.bot.submittedAnswer()) {
            this.bot.setAnalyzingTime(this.bot.getAnalyzingTime() - 1);
        }
        if (!this.bot.submittedAnswer()) {
            this.bot.serverData.handleHighVelocity();
            if (this.bot.interactedWith() && this.getRemainingTicks() <= 0) {
                if (!this.bot.ranOutOfTime()) {
                    if (boundPlayer != null) {
                        NetworkHandlerServer.sendStringPacket(boundPlayer, PacketNames.RESET_TRIVIA, "true");
                    }
                    TaskScheduler.scheduleTask(40, () -> {
                        this.bot.setSubmittedAnswer(true);
                        this.bot.setAnalyzingTime(0);
                        this.answeredIncorrect();
                    });
                }
                this.bot.setRanOutOfTime(true);
            }
        }
        NiceLifeTriviaManager.preparingForSpawn = false;
    }

    public void turnToBed(float turnSpeed) {
        this.turn(this.spawnInfo.bedDirection().method_10153().method_10144(), turnSpeed);
    }

    public void turnFromBed(float turnSpeed) {
        this.turn(this.spawnInfo.bedDirection().method_10144(), turnSpeed);
    }

    public void turn(float targetYaw, float turnSpeed) {
        float newYaw;
        float delta;
        float currentYaw = this.bot.method_36454();
        for (delta = targetYaw - currentYaw; delta > 180.0f; delta -= 360.0f) {
        }
        while (delta < -180.0f) {
            delta += 360.0f;
        }
        float turnAmount = Math.max(-turnSpeed, Math.min(turnSpeed, delta));
        for (newYaw = currentYaw + turnAmount; newYaw > 180.0f; newYaw -= 360.0f) {
        }
        while (newYaw < -180.0f) {
            newYaw += 360.0f;
        }
        if (turnSpeed >= 180.0f) {
            newYaw = targetYaw;
        }
        this.bot.method_36456(newYaw);
        this.bot.method_5636(newYaw);
        this.bot.method_5847(newYaw);
    }

    public void landingTick(class_3218 level) {
        this.sameStateTime.tick();
        this.turnToBed(1000.0f);
        if (this.bot.method_73189().method_10214() < (double)this.spawnInfo.spawnPos().method_10264() + NiceLifeTriviaHandler.botPosOffset.field_1351 || this.sameStateTime.isLarger(Time.seconds(30))) {
            this.bot.method_18800(0.0, 0.0, 0.0);
            this.bot.method_5814(this.bot.method_73189().field_1352, (double)this.spawnInfo.spawnPos().method_10264() + NiceLifeTriviaHandler.botPosOffset.field_1351, this.bot.method_73189().field_1350);
            this.changeStateTo(BotState.LANDED);
            for (class_2338 pos : class_2338.method_10097((class_2338)this.spawnInfo.spawnPos().method_10084(), (class_2338)this.spawnInfo.bedPos())) {
                class_2680 state = level.method_8320(pos);
                if (state.method_26204() instanceof class_2244 || state.method_26204().method_36555() == -1.0f || state.method_26220((class_1922)level, pos).method_1110()) continue;
                level.method_22352(pos, NiceLifeTriviaManager.BREAKING_DROPS_RESOURCES);
            }
        } else {
            this.bot.method_18800(0.0, -0.25, 0.0);
            NiceLifeTriviaManager.breakBlocksAround(level, this.bot.method_24515(), this.spawnInfo.bedPos().method_10264());
        }
    }

    public void landedTick(class_3218 level, class_3222 boundPlayer) {
        this.sameStateTime.tick();
        this.turnToBed(1000.0f);
        this.bot.method_18800(0.0, 0.0, 0.0);
        if (this.sameStateTime.getTicks() >= 55) {
            this.changeStateTo(BotState.APPROACHING);
        }
    }

    public void approachingTick(class_3218 level, class_3222 boundPlayer) {
        boolean atPos;
        this.sameStateTime.tick();
        this.turnToBed(20.0f);
        class_243 botPos = this.bot.method_73189();
        if (this.bot.waving() == -1) {
            class_243 bedVector = class_243.method_24955((class_2382)this.spawnInfo.bedPos()).method_1020(class_243.method_24955((class_2382)this.spawnInfo.spawnPos()));
            if (bedVector.method_1033() > 4.0) {
                boolean atMiddlePos;
                class_243 middlePos = class_243.method_24955((class_2382)this.spawnInfo.spawnPos()).method_1019(botPosOffset).method_1019(bedVector.method_1021(0.4));
                boolean bl = atMiddlePos = botPos.method_1022(middlePos) <= 0.2;
                if (atMiddlePos) {
                    this.bot.method_18800(0.0, 0.0, 0.0);
                    this.bot.setWaving(78);
                    return;
                }
            }
        } else if (this.bot.waving() > 4) {
            this.bot.method_18800(0.0, 0.0, 0.0);
            return;
        }
        class_243 bedPos = class_243.method_24955((class_2382)this.spawnInfo.bedPos()).method_1019(botPosOffset);
        double speedX = bedPos.method_10216() - botPos.method_10216();
        double speedZ = bedPos.method_10215() - botPos.method_10215();
        double maxSpeed = 0.08;
        if (speedX > maxSpeed) {
            speedX = maxSpeed;
        }
        if (speedX < -maxSpeed) {
            speedX = -maxSpeed;
        }
        if (speedZ > maxSpeed) {
            speedZ = maxSpeed;
        }
        if (speedZ < -maxSpeed) {
            speedZ = -maxSpeed;
        }
        class_243 speed = new class_243(speedX, 0.0, speedZ);
        this.bot.method_18799(speed);
        boolean bl = atPos = botPos.method_1022(bedPos) <= 0.2;
        if (atPos || this.sameStateTime.isLarger(Time.seconds(10))) {
            if (!atPos) {
                LevelUtils.teleport((class_1297)this.bot, level, class_243.method_24955((class_2382)this.spawnInfo.bedPos()).method_1019(botPosOffset));
            }
            this.changeStateTo(BotState.APPROACHED);
        }
    }

    public void approachedTick(class_3218 level, class_3222 boundPlayer) {
        this.sameStateTime.tick();
        this.bot.method_18800(0.0, 0.0, 0.0);
        this.turnToBed(20.0f);
        if (this.sameStateTime.getTicks() > 78) {
            this.changeStateTo(BotState.QUESTION);
            this.startTrivia(boundPlayer);
        }
    }

    public void questionTick(class_3218 level, class_3222 boundPlayer) {
        this.sameStateTime.tick();
        this.bot.method_18800(0.0, 0.0, 0.0);
        this.turnToBed(20.0f);
        if (this.sameStateTime.isLarger(NiceLifeVotingManager.VOTING_TIME.copy().add(Time.seconds(35)))) {
            this.changeStateTo(BotState.LEAVING);
        }
    }

    public void flyingUpTick(class_3218 level) {
        this.bot.setLeaving(true);
        this.turnToBed(40.0f);
        this.sameStateTime.tick();
        if (this.bot.method_5765()) {
            this.bot.method_29239();
        }
        this.bot.field_5960 = true;
        if (this.sameStateTime.getTicks() < 12) {
            this.bot.method_18800(0.0, 0.0, 0.0);
            return;
        }
        float velocity = 0.12f * Math.abs((float)(this.sameStateTime.getTicks() - 12) / 20.0f);
        if (this.sameStateTime.getTicks() >= 42) {
            velocity *= 2.0f;
        }
        this.bot.method_18800(0.0, velocity, 0.0);
        if (this.sameStateTime.isLarger(Time.seconds(10))) {
            this.changeStateTo(BotState.FINISHED);
            this.bot.serverData.despawn();
        }
    }

    public void leavingTick(class_3218 level, class_3222 boundPlayer) {
        boolean atPos;
        this.sameStateTime.tick();
        this.turnFromBed(20.0f);
        class_243 botPos = this.bot.method_73189();
        class_243 leavePos = class_243.method_24955((class_2382)this.spawnInfo.spawnPos()).method_1019(botPosOffset);
        class_243 bedPos = class_243.method_24955((class_2382)this.spawnInfo.bedPos()).method_1019(botPosOffset);
        double speedX = leavePos.method_10216() - botPos.method_10216();
        double speedZ = leavePos.method_10215() - botPos.method_10215();
        double maxSpeed = 0.08;
        if (speedX > maxSpeed) {
            speedX = maxSpeed;
        }
        if (speedX < -maxSpeed) {
            speedX = -maxSpeed;
        }
        if (speedZ > maxSpeed) {
            speedZ = maxSpeed;
        }
        if (speedZ < -maxSpeed) {
            speedZ = -maxSpeed;
        }
        class_243 speed = new class_243(speedX, 0.0, speedZ);
        this.bot.method_18799(speed);
        boolean bl = atPos = botPos.method_1022(leavePos) <= 0.2;
        if (atPos || this.sameStateTime.isLarger(Time.seconds(10))) {
            if (!atPos) {
                LevelUtils.teleport((class_1297)this.bot, level, class_243.method_24955((class_2382)this.spawnInfo.spawnPos()).method_1019(botPosOffset));
            }
            this.changeStateTo(BotState.FLYING_UP);
        }
    }

    public void votingTick(class_3218 level) {
        this.sameStateTime.tick();
        this.turnToBed(20.0f);
        this.bot.method_18800(0.0, 0.0, 0.0);
        Time remainingVotingTime = NiceLifeVotingManager.VOTING_TIME.diff(this.sameStateTime);
        NetworkHandlerServer.sendNumberPacket(this.bot.serverData.getBoundPlayer(), PacketNames.VOTING_TIME, remainingVotingTime.getSeconds());
        if (this.sameStateTime.isLarger(NiceLifeVotingManager.VOTING_TIME)) {
            NetworkHandlerServer.sendNumberPacket(this.bot.serverData.getBoundPlayer(), PacketNames.VOTING_TIME, 0.0);
            this.changeStateTo(BotState.LEAVING);
        }
    }

    public void changeStateTo(BotState newState) {
        class_3414 sound;
        this.currentState = newState;
        this.sameStateTime = Time.zero();
        if (newState == BotState.APPROACHING || newState == BotState.LANDED) {
            this.turnToBed(1000.0f);
        }
        if (newState == BotState.APPROACHED) {
            this.bot.setWaving(78);
        }
        if (newState == BotState.LEAVING) {
            sound = class_3414.method_47908((class_2960)IdentifierHelper.vanilla("nicelife_santabot_turn"));
            PlayerUtils.playSoundToPlayer(this.bot.serverData.getBoundPlayer(), sound, 0.65f, 1.0f);
            TaskScheduler.scheduleTask(40, () -> {
                for (class_1542 item : this.droppedItems) {
                    if (item == null) continue;
                    item.method_6982(0);
                }
            });
        }
        if (newState == BotState.FLYING_UP) {
            NetworkHandlerServer.sendStringPacket(this.bot.serverData.getBoundPlayer(), PacketNames.HIDE_SLEEP_DARKNESS, "false");
            sound = class_3414.method_47908((class_2960)IdentifierHelper.vanilla("nicelife_santabot_away"));
            PlayerUtils.playSoundToPlayer(this.bot.serverData.getBoundPlayer(), sound, 0.65f, 1.0f);
        }
    }

    @Override
    public boolean handleAnswer(int answer) {
        if (super.handleAnswer(answer)) {
            this.bot.setAnalyzingTime(87);
            PlayerUtils.playSoundToPlayer(this.bot.serverData.getBoundPlayer(), class_3414.method_47908((class_2960)IdentifierHelper.vanilla("nicelife_santabot_analyzing")), 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public void answeredCorrect() {
        super.answeredCorrect();
        NiceLifeTriviaManager.correctAnswers.add(this.bot.serverData.getBoundPlayerUUID());
        TaskScheduler.scheduleTask(261, () -> this.spawnItemForPlayer(true));
        TaskScheduler.scheduleTask(281, () -> this.spawnItemForPlayer(true));
        TaskScheduler.scheduleTask(300, () -> this.spawnItemForPlayer(true));
        class_3414 sound = OtherUtils.getRandomSound("nicelife_santabot_correct", 1, 6);
        TaskScheduler.scheduleTask(174, () -> PlayerUtils.playSoundToPlayer(this.bot.serverData.getBoundPlayer(), sound, 0.65f, 1.0f));
        TaskScheduler.scheduleTask(314, () -> {
            if (this.startVoting()) {
                this.changeStateTo(BotState.VOTING);
            } else {
                this.changeStateTo(BotState.LEAVING);
            }
        });
    }

    public boolean startVoting() {
        class_3222 boundPlayer = this.bot.serverData.getBoundPlayer();
        if (boundPlayer == null) {
            return false;
        }
        NiceLifeVotingManager.VoteType voteType = NiceLifeVotingManager.voteType;
        if (voteType != NiceLifeVotingManager.VoteType.NICE_LIST && voteType != NiceLifeVotingManager.VoteType.NAUGHTY_LIST) {
            return false;
        }
        ArrayList<String> availableForVoting = new ArrayList<String>();
        if (voteType == NiceLifeVotingManager.VoteType.NICE_LIST) {
            availableForVoting.add("Vote for who's been nice");
        } else {
            availableForVoting.add("Vote for who's been naughty");
        }
        for (class_3222 player : Main.livesManager.getAlivePlayers()) {
            if (voteType == NiceLifeVotingManager.VoteType.NICE_LIST) {
                if (player == boundPlayer) continue;
                availableForVoting.add(player.method_5820());
                continue;
            }
            if (!player.ls$isOnAtLeastLives(2, false) && !NiceLifeVotingManager.REDS_ON_NAUGHTY_LIST) continue;
            availableForVoting.add(player.method_5820());
        }
        if (availableForVoting.size() <= 1) {
            return false;
        }
        NetworkHandlerServer.sendStringListPacket(boundPlayer, PacketNames.VOTING_SCREEN, availableForVoting);
        NiceLifeVotingManager.allowedToVote.add(boundPlayer.method_5667());
        class_3414 sound = class_3414.method_47908((class_2960)IdentifierHelper.vanilla("nicelife_santabot_suspense"));
        PlayerUtils.playSoundToPlayer(this.bot.serverData.getBoundPlayer(), sound, 0.65f, 1.0f);
        return true;
    }

    @Override
    public void answeredIncorrect() {
        super.answeredIncorrect();
        NiceLifeTriviaManager.incorrectAnswers.add(this.bot.serverData.getBoundPlayerUUID());
        int delay = this.bot.ranOutOfTime() ? 0 : 174;
        TaskScheduler.scheduleTask(delay + 115, () -> this.spawnItemForPlayer(false));
        TaskScheduler.scheduleTask(delay + 135, () -> this.spawnItemForPlayer(false));
        class_3414 sound = OtherUtils.getRandomSound("nicelife_santabot_incorrect", 1, 6);
        TaskScheduler.scheduleTask(delay, () -> PlayerUtils.playSoundToPlayer(this.bot.serverData.getBoundPlayer(), sound, 0.65f, 1.0f));
        TaskScheduler.scheduleTask(delay + 160, () -> this.changeStateTo(BotState.LEAVING));
    }

    public void spawnItemForPlayer(boolean success) {
        if (this.bot.method_73183().method_8608()) {
            return;
        }
        if (itemSpawner == null) {
            return;
        }
        if (this.bot.serverData.getBoundPlayer() == null) {
            return;
        }
        class_243 pos = this.bot.method_73189().method_1031(0.0, 1.0, 0.0);
        class_243 towardsArm = this.spawnInfo.bedDirection().method_10160().method_62676();
        pos = pos.method_1019(towardsArm.method_1021(0.6));
        class_243 playerPos = this.bot.serverData.getBoundPlayer().method_73189().method_1019(towardsArm.method_1021(0.3));
        class_243 relativeTargetPos = new class_243(playerPos.method_10216() - pos.method_10216(), 0.0, playerPos.method_10215() - pos.method_10215());
        class_243 vector = class_243.field_1353;
        if (relativeTargetPos.method_1027() > 1.0E-4) {
            vector = success ? relativeTargetPos.method_1029().method_1021(0.05).method_1031(0.0, 0.43, 0.0) : relativeTargetPos.method_1029().method_1021(0.25).method_1031(0.0, 0.1, 0.0);
        }
        if (success) {
            List<class_1799> lootTableItems = ItemSpawner.getRandomItemsFromLootTable(Main.server, (class_3218)this.bot.method_73183(), this.bot.serverData.getBoundPlayer(), IdentifierHelper.of("lifeseriesdynamic", "nicelife_trivia_reward_loottable"), false);
            if (!lootTableItems.isEmpty()) {
                for (class_1799 item : lootTableItems) {
                    class_1542 itemEntity = ItemStackUtils.spawnItemForPlayerWithVelocity((class_3218)this.bot.method_73183(), pos, item, (class_1657)this.bot.serverData.getBoundPlayer(), vector);
                    itemEntity.method_6989();
                    this.droppedItems.add(itemEntity);
                }
            } else {
                class_1799 randomItem = itemSpawner.getRandomItem();
                class_1542 itemEntity = ItemStackUtils.spawnItemForPlayerWithVelocity((class_3218)this.bot.method_73183(), pos, randomItem, (class_1657)this.bot.serverData.getBoundPlayer(), vector);
                itemEntity.method_6989();
                this.droppedItems.add(itemEntity);
            }
        } else {
            class_1799 coal = class_1802.field_8713.method_7854();
            class_1542 itemEntity = ItemStackUtils.spawnItemForPlayerWithVelocity((class_3218)this.bot.method_73183(), pos, coal, (class_1657)this.bot.serverData.getBoundPlayer(), vector);
            itemEntity.method_6989();
            this.droppedItems.add(itemEntity);
        }
    }

    public static void initializeItemSpawner() {
        itemSpawner = new ItemSpawner();
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8603, 1), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8071, 32), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8503, 1), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8108, 1), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8477, 3), 20);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8773, 2), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8463, 1), 20);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_28101, 1), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_37538, 1), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8626, 2), 20);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8281, 20), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8107, 32), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8634, 2), 20);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8545, 1), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8170, 64), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8583, 64), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_37512, 64), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8176, 16), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8894, 8), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8725, 32), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8149, 1), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8795, 1), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8740, 1), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8657, 1), 10);
        itemSpawner.addItem(Objects.requireNonNull(ItemStackUtils.createEnchantedBook((class_5321<class_1887>)class_1893.field_9129, 3)), 10);
        class_1799 pot = new class_1799((class_1935)class_1802.field_8574);
        class_1799 pot2 = new class_1799((class_1935)class_1802.field_8574);
        pot.method_57379(class_9334.field_49651, (Object)new class_1844(class_1847.field_8997));
        pot2.method_57379(class_9334.field_49651, (Object)new class_1844(class_1847.field_8974));
        itemSpawner.addItem(pot, 10);
        itemSpawner.addItem(pot2, 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_49098, 6), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_49821, 1), 10);
        class_1799 mace = new class_1799((class_1935)class_1802.field_49814);
        ItemStackUtils.setCustomComponentBoolean(mace, "IgnoreBlacklist", true);
        ItemStackUtils.setCustomComponentBoolean(mace, "NoModifications", true);
        mace.method_7974(mace.method_7936() - 1);
        itemSpawner.addItem(mace, 5);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_59711, 1), 10);
        class_1799 endCrystal = new class_1799((class_1935)class_1802.field_8301);
        ItemStackUtils.setCustomComponentBoolean(endCrystal, "IgnoreBlacklist", true);
        itemSpawner.addItem(endCrystal, 10);
        class_1799 patat = new class_1799((class_1935)class_1802.field_8635);
        patat.method_57379(class_9334.field_49631, (Object)class_2561.method_30163((String)"\u00a76\u00a7l\u00a7nThe Sacred Patat"));
        ItemStackUtils.addLoreToItemStack(patat, List.of(class_2561.method_30163((String)"\u00a75\u00a7oEating bot might help you. Or maybe not...")));
        itemSpawner.addItem(patat, 1);
        class_1799 camel = new class_1799((class_1935)class_1802.field_40239);
        class_2487 nbtCompCamel = new class_2487();
        nbtCompCamel.method_10569("Tame", 1);
        nbtCompCamel.method_10582("id", "camel");
        class_2487 equipmentItemComp = new class_2487();
        class_2487 saddleItemComp = new class_2487();
        saddleItemComp.method_10582("id", "saddle");
        equipmentItemComp.method_10566("saddle", (class_2520)saddleItemComp);
        nbtCompCamel.method_10566("equipment", (class_2520)equipmentItemComp);
        class_9279 nbtCamel = class_9279.method_57456((class_2487)nbtCompCamel);
        camel.method_57379(class_9334.field_49609, (Object)class_11580.method_72535((Object)class_1299.field_40116, (class_2487)nbtCamel.method_57461()));
        itemSpawner.addItem(camel, 10);
    }

    static {
        botPosOffset = new class_243(0.0, 0.0, 0.0);
    }

    public static enum BotState {
        LANDING,
        LANDED,
        APPROACHING,
        APPROACHED,
        QUESTION,
        VOTING,
        LEAVING,
        FLYING_UP,
        FINISHED;

    }
}

