/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.entity.triviabot.server.trivia;

import java.util.List;
import net.mat0u5.lifeseries.entity.triviabot.TriviaBot;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.trivia.TriviaQuestion;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.mat0u5.lifeseries.utils.other.Tuple;
import net.mat0u5.lifeseries.utils.world.DatapackIntegration;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_3222;

public abstract class TriviaHandler {
    protected TriviaBot bot;
    public int difficulty = 0;
    public int interactedAtAge = 0;
    public int timeToComplete = 0;
    public TriviaQuestion question;

    public TriviaHandler(TriviaBot bot) {
        this.bot = bot;
    }

    public void tick() {
        if (this.bot.interactedWith()) {
            this.bot.triviaHandler.sendTimeUpdatePacket();
        }
    }

    public void startTrivia(class_3222 boundPlayer) {
        DatapackIntegration.EVENT_TRIVIA_BOT_OPEN.trigger(List.of(new DatapackIntegration.Events.MacroEntry("Player", boundPlayer.method_5820()), new DatapackIntegration.Events.MacroEntry("TriviaBot", this.bot.method_5845())));
        if (!this.bot.interactedWith() || this.question == null) {
            this.interactedAtAge = this.bot.field_6012;
            Tuple<Integer, TriviaQuestion> triviaQuestion = this.generateTrivia(boundPlayer);
            this.difficulty = (Integer)triviaQuestion.x;
            this.question = (TriviaQuestion)triviaQuestion.y;
            this.setTimeBasedOnDifficulty(this.difficulty);
        }
        this.sendTimeUpdatePacket();
        NetworkHandlerServer.sendTriviaPacket(boundPlayer, this.question.getQuestion(), this.difficulty, System.currentTimeMillis(), this.timeToComplete, this.question.getAnswers());
        this.bot.setInteractedWith(true);
    }

    abstract Tuple<Integer, TriviaQuestion> generateTrivia(class_3222 var1);

    abstract void setTimeBasedOnDifficulty(int var1);

    public class_1269 interactMob(class_1657 player, class_1268 hand) {
        return class_1269.field_5812;
    }

    public void sendTimeUpdatePacket() {
        class_3222 player = this.bot.serverData.getBoundPlayer();
        if (player != null) {
            int ticksSinceStart = this.bot.field_6012 - this.interactedAtAge;
            NetworkHandlerServer.sendNumberPacket(player, PacketNames.TRIVIA_TIMER, ticksSinceStart);
        }
    }

    public int getRemainingTicks() {
        int ticksSinceStart = this.bot.field_6012 - this.interactedAtAge;
        return this.timeToComplete * 20 - ticksSinceStart;
    }

    public boolean handleAnswer(int answer) {
        if (this.bot.method_73183().method_8608()) {
            return false;
        }
        if (this.bot.submittedAnswer()) {
            return false;
        }
        this.bot.setSubmittedAnswer(true);
        if (answer == this.question.getCorrectAnswerIndex()) {
            this.answeredCorrect();
        } else {
            this.answeredIncorrect();
        }
        return true;
    }

    public void answeredCorrect() {
        class_3222 player = this.bot.serverData.getBoundPlayer();
        if (player != null) {
            DatapackIntegration.EVENT_TRIVIA_SUCCEED.trigger(List.of(new DatapackIntegration.Events.MacroEntry("Player", player.method_5820()), new DatapackIntegration.Events.MacroEntry("TriviaBot", this.bot.method_5845())));
        }
        this.bot.setAnsweredRight(true);
    }

    public void answeredIncorrect() {
        class_3222 player = this.bot.serverData.getBoundPlayer();
        if (player != null) {
            DatapackIntegration.EVENT_TRIVIA_FAIL.trigger(List.of(new DatapackIntegration.Events.MacroEntry("Player", player.method_5820()), new DatapackIntegration.Events.MacroEntry("TriviaBot", this.bot.method_5845())));
        }
        this.bot.setAnsweredRight(false);
    }
}

