/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.entity.triviabot.server.trivia;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.compatibilities.CompatibilityManager;
import net.mat0u5.lifeseries.compatibilities.voicechat.VoicechatMain;
import net.mat0u5.lifeseries.entity.snail.Snail;
import net.mat0u5.lifeseries.entity.triviabot.TriviaBot;
import net.mat0u5.lifeseries.entity.triviabot.server.TriviaBotPathfinding;
import net.mat0u5.lifeseries.entity.triviabot.server.trivia.TriviaHandler;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.registries.MobRegistry;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcard;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.SizeShifting;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.trivia.TriviaQuestion;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.trivia.TriviaWildcard;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.mat0u5.lifeseries.utils.other.IdentifierHelper;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.other.Tuple;
import net.mat0u5.lifeseries.utils.other.WeightedRandomizer;
import net.mat0u5.lifeseries.utils.player.AttributeUtils;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.world.ItemSpawner;
import net.mat0u5.lifeseries.utils.world.ItemStackUtils;
import net.mat0u5.lifeseries.utils.world.LevelUtils;
import net.minecraft.class_10583;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4466;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9334;
import net.minecraft.class_9381;

public class WildLifeTriviaHandler
extends TriviaHandler {
    public static ItemSpawner itemSpawner;
    public int snailTransformation = 0;
    public static int EASY_TIME;
    public static int NORMAL_TIME;
    public static int HARD_TIME;
    private static final List<class_6880<class_1291>> blessEffects;
    public static final List<UUID> cursedGigantificationPlayers;
    public static final List<UUID> cursedSliding;
    public static final List<UUID> cursedHeartPlayers;
    public static final List<UUID> cursedMoonJumpPlayers;
    public static final List<UUID> cursedRoboticVoicePlayers;

    public WildLifeTriviaHandler(TriviaBot bot) {
        super(bot);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.bot.ranOutOfTime()) {
            ++this.snailTransformation;
        }
        if (this.bot.field_6012 % 2 == 0 && this.bot.submittedAnswer()) {
            this.bot.setAnalyzingTime(this.bot.getAnalyzingTime() - 1);
        }
        if (this.bot.submittedAnswer()) {
            if (this.bot.answeredRight()) {
                if (this.bot.getAnalyzingTime() < -80) {
                    this.bot.setLeaving(true);
                    if (this.bot.method_5765()) {
                        this.bot.method_29239();
                    }
                    this.bot.field_5960 = true;
                    float velocity = Math.min(0.5f, 0.25f * Math.abs((float)(this.bot.getAnalyzingTime() + 80) / 20.0f));
                    this.bot.method_18800(0.0, velocity, 0.0);
                    if (this.bot.getAnalyzingTime() < -200) {
                        this.bot.serverData.despawn();
                    }
                }
            } else if (this.bot.getAnalyzingTime() < -100) {
                if (this.bot.method_5765()) {
                    this.bot.method_29239();
                }
                this.bot.field_5960 = true;
                float velocity = Math.min(0.5f, 0.25f * Math.abs((float)(this.bot.getAnalyzingTime() + 100) / 20.0f));
                this.bot.method_18800(0.0, velocity, 0.0);
                if (this.bot.getAnalyzingTime() < -200) {
                    this.bot.serverData.despawn();
                }
            }
        } else {
            this.bot.serverData.handleHighVelocity();
            if (this.bot.interactedWith() && this.getRemainingTicks() <= 0) {
                class_3222 boundPlayer;
                if (!this.bot.ranOutOfTime() && (boundPlayer = this.bot.serverData.getBoundPlayer()) != null) {
                    NetworkHandlerServer.sendStringPacket(boundPlayer, PacketNames.RESET_TRIVIA, "true");
                }
                this.bot.setRanOutOfTime(true);
            }
            if (this.snailTransformation > 66) {
                this.transformIntoSnail();
            }
        }
    }

    @Override
    public class_1269 interactMob(class_1657 player, class_1268 hand) {
        if (this.bot.method_73183().method_8608()) {
            return class_1269.field_5812;
        }
        class_3222 boundPlayer = this.bot.serverData.getBoundPlayer();
        if (boundPlayer == null) {
            return class_1269.field_5811;
        }
        if (boundPlayer.method_5667() != player.method_5667()) {
            return class_1269.field_5811;
        }
        if (this.bot.submittedAnswer()) {
            return class_1269.field_5811;
        }
        if (this.bot.interactedWith() && this.getRemainingTicks() <= 0) {
            return class_1269.field_5811;
        }
        this.startTrivia(boundPlayer);
        return class_1269.field_5812;
    }

    @Override
    public Tuple<Integer, TriviaQuestion> generateTrivia(class_3222 boundPlayer) {
        return TriviaWildcard.getTriviaQuestion(boundPlayer);
    }

    @Override
    public void setTimeBasedOnDifficulty(int difficulty) {
        this.timeToComplete = difficulty * 60 + 120;
        if (difficulty == 1) {
            this.timeToComplete = EASY_TIME;
        }
        if (difficulty == 2) {
            this.timeToComplete = NORMAL_TIME;
        }
        if (difficulty == 3) {
            this.timeToComplete = HARD_TIME;
        }
    }

    public void transformIntoSnail() {
        Snail triviaSnail;
        if (this.bot.serverData.getBoundPlayer() != null && (triviaSnail = LevelUtils.spawnEntity(MobRegistry.SNAIL, (class_3218)this.bot.method_73183(), this.bot.method_24515())) != null) {
            triviaSnail.serverData.setBoundPlayer(this.bot.serverData.getBoundPlayer());
            triviaSnail.serverData.setFromTrivia();
            triviaSnail.method_5783((class_3414)class_3417.field_15152.comp_349(), 0.5f, 2.0f);
            class_3218 level = (class_3218)triviaSnail.method_73183();
            class_243 pos = this.bot.method_73189();
            level.method_65096((class_2394)class_2398.field_11236, pos.method_10216(), pos.method_10214(), pos.method_10215(), 10, 0.5, 0.5, 0.5, 0.5);
            TriviaWildcard.snails.put(this.bot.serverData.getBoundPlayer().method_5667(), triviaSnail);
        }
        this.bot.serverData.despawn();
    }

    @Override
    public boolean handleAnswer(int answer) {
        if (super.handleAnswer(answer)) {
            this.bot.setAnalyzingTime(42);
            PlayerUtils.playSoundWithSourceToPlayers(PlayerUtils.getAllPlayers(), (class_1297)this.bot, class_3414.method_47908((class_2960)IdentifierHelper.vanilla("wildlife_trivia_analyzing")), class_3419.field_15254, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public void answeredCorrect() {
        super.answeredCorrect();
        TaskScheduler.scheduleTask(145, this::spawnItemForPlayer);
        TaskScheduler.scheduleTask(170, this::spawnItemForPlayer);
        TaskScheduler.scheduleTask(198, this::spawnItemForPlayer);
        TaskScheduler.scheduleTask(213, this::blessPlayer);
        TaskScheduler.scheduleTask(72, () -> PlayerUtils.playSoundWithSourceToPlayers(PlayerUtils.getAllPlayers(), (class_1297)this.bot, class_3414.method_47908((class_2960)IdentifierHelper.vanilla("wildlife_trivia_correct")), class_3419.field_15254, 1.0f, 1.0f));
    }

    @Override
    public void answeredIncorrect() {
        super.answeredIncorrect();
        TaskScheduler.scheduleTask(210, this::cursePlayer);
        TaskScheduler.scheduleTask(72, () -> PlayerUtils.playSoundWithSourceToPlayers(PlayerUtils.getAllPlayers(), (class_1297)this.bot, class_3414.method_47908((class_2960)IdentifierHelper.vanilla("wildlife_trivia_incorrect")), class_3419.field_15254, 1.0f, 1.0f));
    }

    public void cursePlayer() {
        Integer n;
        Integer punishmentWeight;
        class_3222 player = this.bot.serverData.getBoundPlayer();
        if (player == null) {
            return;
        }
        player.ls$playNotifySound(class_3417.field_15203, class_3419.field_15250, 0.2f, 1.0f);
        class_3218 level = (class_3218)this.bot.method_73183();
        class_243 pos = this.bot.method_73189();
        level.method_65096((class_2394)class_9381.method_58256((class_2396)class_2398.field_11226, (int)-5893871), pos.method_10216(), pos.method_10214() + 1.0, pos.method_10215(), 40, 0.1, 0.25, 0.1, 0.035);
        int minCurseNum = 0;
        int numOfCurses = 9;
        if (CompatibilityManager.voicechatLoaded() && VoicechatMain.isConnectedToSVC(player.method_5667())) {
            numOfCurses = 10;
        }
        if ((punishmentWeight = player.ls$getLives()) == null) {
            punishmentWeight = 1;
        }
        if (this.difficulty == 1) {
            n = punishmentWeight;
            punishmentWeight = punishmentWeight + 1;
        }
        if (this.difficulty == 3) {
            n = punishmentWeight;
            punishmentWeight = punishmentWeight - 1;
        }
        punishmentWeight = OtherUtils.clamp(punishmentWeight, 1, 4);
        WeightedRandomizer randomizer = new WeightedRandomizer();
        int curse = randomizer.getWeightedRandom(minCurseNum, numOfCurses, punishmentWeight, 4, 1.5);
        if (numOfCurses == 9 && curse >= 6) {
            ++curse;
        }
        switch (curse) {
            default: {
                WildLifeTriviaHandler.curseInfestation(player);
                break;
            }
            case 1: {
                WildLifeTriviaHandler.curseSlipperyGround(player);
                break;
            }
            case 2: {
                WildLifeTriviaHandler.curseHunger(player);
                break;
            }
            case 3: {
                WildLifeTriviaHandler.curseBeeswarm(player, this.bot.method_24515());
                break;
            }
            case 4: {
                WildLifeTriviaHandler.curseGigantification(player);
                break;
            }
            case 5: {
                WildLifeTriviaHandler.curseMoonjump(player);
                break;
            }
            case 6: {
                WildLifeTriviaHandler.curseRoboticVoice(player);
                break;
            }
            case 7: {
                WildLifeTriviaHandler.curseBindingArmor(player);
                break;
            }
            case 8: {
                WildLifeTriviaHandler.curseRavager(player, this.bot.method_24515());
                break;
            }
            case 9: {
                WildLifeTriviaHandler.curseHearts(player);
            }
        }
    }

    public void blessPlayer() {
        class_3222 player = this.bot.serverData.getBoundPlayer();
        if (player == null) {
            return;
        }
        player.method_64398((class_2561)class_2561.method_43473());
        for (int i = 0; i < 3; ++i) {
            class_6880<class_1291> effect = null;
            for (int attempts = 0; effect == null && attempts < 50; ++attempts) {
                class_6880<class_1291> pickedEffect = blessEffects.get(player.method_59922().method_43048(blessEffects.size()));
                if (Main.blacklist != null && Main.blacklist.getBannedEffects().contains(pickedEffect)) continue;
                effect = pickedEffect;
            }
            if (effect == null) continue;
            int amplifier = effect == class_1294.field_5918 || effect == class_1294.field_5923 || effect == class_1294.field_5925 || effect == class_1294.field_5924 || effect == class_1294.field_5910 || effect == class_1294.field_5914 || effect == class_1294.field_5907 ? 0 : player.method_59922().method_43048(4);
            if (Wildcard.isFinale()) {
                player.method_6092(new class_1293(effect, 12000, amplifier));
            } else {
                player.method_6092(new class_1293(effect, 24000, amplifier));
            }
            String romanNumeral = TextUtils.toRomanNumeral(amplifier + 1);
            class_5250 effectName = class_2561.method_43471((String)((class_1291)effect.comp_349()).method_5567());
            player.method_64398((class_2561)TextUtils.formatLoosely(" \u00a7a\u00a7l+ \u00a77{}\u00a76 {}", effectName, romanNumeral));
        }
        player.method_64398((class_2561)class_2561.method_43473());
    }

    public void spawnItemForPlayer() {
        List<class_1799> lootTableItems;
        if (this.bot.method_73183().method_8608()) {
            return;
        }
        if (itemSpawner == null) {
            return;
        }
        if (this.bot.serverData.getBoundPlayer() == null) {
            return;
        }
        class_243 playerPos = this.bot.serverData.getBoundPlayer().method_73189();
        class_243 pos = this.bot.method_73189().method_1031(0.0, 1.0, 0.0);
        class_243 relativeTargetPos = new class_243(playerPos.method_10216() - pos.method_10216(), 0.0, playerPos.method_10215() - pos.method_10215());
        class_243 vector = class_243.field_1353;
        if (relativeTargetPos.method_1027() > 1.0E-4) {
            vector = relativeTargetPos.method_1029().method_1021(0.3).method_1031(0.0, 0.1, 0.0);
        }
        if (!(lootTableItems = ItemSpawner.getRandomItemsFromLootTable(Main.server, (class_3218)this.bot.method_73183(), this.bot.serverData.getBoundPlayer(), IdentifierHelper.of("lifeseriesdynamic", "trivia_reward_loottable"), false)).isEmpty()) {
            for (class_1799 item : lootTableItems) {
                ItemStackUtils.spawnItemForPlayerWithVelocity((class_3218)this.bot.method_73183(), pos, item, (class_1657)this.bot.serverData.getBoundPlayer(), vector);
            }
        } else {
            class_1799 randomItem = itemSpawner.getRandomItem();
            ItemStackUtils.spawnItemForPlayerWithVelocity((class_3218)this.bot.method_73183(), pos, randomItem, (class_1657)this.bot.serverData.getBoundPlayer(), vector);
        }
    }

    public static void initializeItemSpawner() {
        itemSpawner = new ItemSpawner();
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8463, 2), 20);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8634, 2), 20);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8547), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8848, 16), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8477, 4), 20);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8503), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8071, 8), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_49098, 16), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_37538, 2), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_28101, 8), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8626, 8), 20);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8786, 8), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8281, 8), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8108), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_22028), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_22029), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_22030), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8107, 64), 10);
        itemSpawner.addItem(new class_1799((class_1935)class_1802.field_8773, 2), 10);
        class_1799 mace = new class_1799((class_1935)class_1802.field_49814);
        ItemStackUtils.setCustomComponentBoolean(mace, "IgnoreBlacklist", true);
        ItemStackUtils.setCustomComponentBoolean(mace, "NoModifications", true);
        mace.method_7974(mace.method_7936() - 1);
        itemSpawner.addItem(mace, 5);
        class_1799 endCrystal = new class_1799((class_1935)class_1802.field_8301);
        ItemStackUtils.setCustomComponentBoolean(endCrystal, "IgnoreBlacklist", true);
        itemSpawner.addItem(endCrystal, 10);
        class_1799 patat = new class_1799((class_1935)class_1802.field_8635);
        patat.method_57379(class_9334.field_49631, (Object)class_2561.method_30163((String)"\u00a76\u00a7l\u00a7nThe Sacred Patat"));
        ItemStackUtils.addLoreToItemStack(patat, List.of(class_2561.method_30163((String)"\u00a75\u00a7oEating bot might help you. Or maybe not...")));
        itemSpawner.addItem(patat, 1);
    }

    public static void curseHunger(class_3222 player) {
        class_1293 statusEffectInstance = new class_1293(class_1294.field_5903, 18000, 2);
        player.method_6092(statusEffectInstance);
    }

    public static void curseRavager(class_3222 player, class_2338 pos) {
        class_2338 spawnPos = TriviaBotPathfinding.getBlockPosNearPlayer((class_1297)player, pos, 5.0);
        LevelUtils.spawnEntity(class_1299.field_6134, player.ls$getServerLevel(), spawnPos);
    }

    public static void curseInfestation(class_3222 player) {
        class_1293 statusEffectInstance = new class_1293(class_1294.field_50121, 18000, 0);
        player.method_6092(statusEffectInstance);
    }

    public static void curseGigantification(class_3222 player) {
        cursedGigantificationPlayers.add(player.method_5667());
        SizeShifting.setPlayerSizeUnchecked(player, 4.0);
    }

    public static void curseSlipperyGround(class_3222 player) {
        cursedSliding.add(player.method_5667());
    }

    public static void curseBindingArmor(class_3222 player) {
        for (class_1799 item : PlayerUtils.getArmorItems(player)) {
            ItemStackUtils.spawnItemForPlayer(player.ls$getServerLevel(), player.method_73189(), item.method_7972(), (class_1657)player);
        }
        class_1799 head = class_1802.field_8267.method_7854();
        class_1799 chest = class_1802.field_8577.method_7854();
        class_1799 legs = class_1802.field_8570.method_7854();
        class_1799 boots = class_1802.field_8370.method_7854();
        head.method_7978(ItemStackUtils.getEnchantmentEntry((class_5321<class_1887>)class_1893.field_9113), 1);
        chest.method_7978(ItemStackUtils.getEnchantmentEntry((class_5321<class_1887>)class_1893.field_9113), 1);
        legs.method_7978(ItemStackUtils.getEnchantmentEntry((class_5321<class_1887>)class_1893.field_9113), 1);
        boots.method_7978(ItemStackUtils.getEnchantmentEntry((class_5321<class_1887>)class_1893.field_9113), 1);
        ItemStackUtils.setCustomComponentBoolean(head, "IgnoreBlacklist", true);
        ItemStackUtils.setCustomComponentBoolean(chest, "IgnoreBlacklist", true);
        ItemStackUtils.setCustomComponentBoolean(legs, "IgnoreBlacklist", true);
        ItemStackUtils.setCustomComponentBoolean(boots, "IgnoreBlacklist", true);
        player.method_5673(class_1304.field_6169, head);
        player.method_5673(class_1304.field_6174, chest);
        player.method_5673(class_1304.field_6172, legs);
        player.method_5673(class_1304.field_6166, boots);
        player.method_31548().method_5431();
    }

    public static void curseHearts(class_3222 player) {
        cursedHeartPlayers.add(player.method_5667());
        double newHealth = Math.max(player.method_6063() - 7.0f, 1.0f);
        AttributeUtils.setMaxPlayerHealth(player, newHealth);
    }

    public static void curseMoonjump(class_3222 player) {
        cursedMoonJumpPlayers.add(player.method_5667());
        AttributeUtils.setJumpStrength(player, 0.85);
    }

    public static void curseBeeswarm(class_3222 player, class_2338 pos) {
        class_2338 spawnPos = TriviaBotPathfinding.getBlockPosNearPlayer((class_1297)player, pos, 1.0);
        class_4466 bee1 = (class_4466)LevelUtils.spawnEntity(class_1299.field_20346, player.ls$getServerLevel(), spawnPos);
        class_4466 bee2 = (class_4466)LevelUtils.spawnEntity(class_1299.field_20346, player.ls$getServerLevel(), spawnPos);
        class_4466 bee3 = (class_4466)LevelUtils.spawnEntity(class_1299.field_20346, player.ls$getServerLevel(), spawnPos);
        class_4466 bee4 = (class_4466)LevelUtils.spawnEntity(class_1299.field_20346, player.ls$getServerLevel(), spawnPos);
        class_4466 bee5 = (class_4466)LevelUtils.spawnEntity(class_1299.field_20346, player.ls$getServerLevel(), spawnPos);
        if (bee1 != null) {
            bee1.method_29513(class_10583.method_73300((UUID)player.method_5667()));
        }
        if (bee2 != null) {
            bee2.method_29513(class_10583.method_73300((UUID)player.method_5667()));
        }
        if (bee3 != null) {
            bee3.method_29513(class_10583.method_73300((UUID)player.method_5667()));
        }
        if (bee4 != null) {
            bee4.method_29513(class_10583.method_73300((UUID)player.method_5667()));
        }
        if (bee5 != null) {
            bee5.method_29513(class_10583.method_73300((UUID)player.method_5667()));
        }
        if (bee1 != null) {
            bee1.method_75132((long)(bee1.method_5618() + 1000000));
        }
        if (bee2 != null) {
            bee2.method_75132((long)(bee2.method_5618() + 1000000));
        }
        if (bee3 != null) {
            bee3.method_75132((long)(bee3.method_5618() + 1000000));
        }
        if (bee4 != null) {
            bee4.method_75132((long)(bee4.method_5618() + 1000000));
        }
        if (bee5 != null) {
            bee5.method_75132((long)(bee5.method_5618() + 1000000));
        }
    }

    public static void curseRoboticVoice(class_3222 player) {
        cursedRoboticVoicePlayers.add(player.method_5667());
    }

    static {
        EASY_TIME = 180;
        NORMAL_TIME = 240;
        HARD_TIME = 300;
        blessEffects = List.of(class_1294.field_5904, class_1294.field_5917, class_1294.field_5910, class_1294.field_5913, class_1294.field_5907, class_1294.field_5924, class_1294.field_5918, class_1294.field_5923, class_1294.field_5925, class_1294.field_5914, class_1294.field_5898);
        cursedGigantificationPlayers = new ArrayList<UUID>();
        cursedSliding = new ArrayList<UUID>();
        cursedHeartPlayers = new ArrayList<UUID>();
        cursedMoonJumpPlayers = new ArrayList<UUID>();
        cursedRoboticVoicePlayers = new ArrayList<UUID>();
    }
}

