/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.events;

import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.MainClient;
import net.mat0u5.lifeseries.compatibilities.CompatibilityManager;
import net.mat0u5.lifeseries.compatibilities.FlashbackCompatibility;
import net.mat0u5.lifeseries.compatibilities.VoicechatClient;
import net.mat0u5.lifeseries.events.ClientKeybinds;
import net.mat0u5.lifeseries.gui.EmptySleepScreen;
import net.mat0u5.lifeseries.gui.other.UpdateInfoScreen;
import net.mat0u5.lifeseries.gui.trivia.NewQuizScreen;
import net.mat0u5.lifeseries.gui.trivia.VotingScreen;
import net.mat0u5.lifeseries.network.NetworkHandlerClient;
import net.mat0u5.lifeseries.render.TextHud;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcards;
import net.mat0u5.lifeseries.utils.ClientSounds;
import net.mat0u5.lifeseries.utils.ClientTaskScheduler;
import net.mat0u5.lifeseries.utils.ClientUtils;
import net.mat0u5.lifeseries.utils.enums.HandshakeStatus;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.mat0u5.lifeseries.utils.versions.UpdateChecker;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4048;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_634;
import net.minecraft.class_702;
import net.minecraft.class_746;
import net.minecraft.class_9381;
import net.minecraft.server.MinecraftServer;

@Environment(value=EnvType.CLIENT)
public class ClientEvents {
    public static long onGroundFor = 0L;
    private static boolean hasShownUpdateScreen = false;
    private static int jumpedInAir = 0;
    private static int jumpCooldown = 0;
    private static boolean lastJumping = false;

    public static void registerClientEvents() {
        ClientPlayConnectionEvents.JOIN.register(ClientEvents::onClientJoin);
        ClientPlayConnectionEvents.DISCONNECT.register(ClientEvents::onClientDisconnect);
        ClientLifecycleEvents.CLIENT_STARTED.register(ClientEvents::onClientStart);
        ScreenEvents.AFTER_INIT.register(ClientEvents::onScreenOpen);
        ServerLifecycleEvents.SERVER_STARTING.register(ClientEvents::onServerStart);
        ServerLifecycleEvents.SERVER_STARTED.register(ClientEvents::onServerStart);
    }

    private static void onServerStart(MinecraftServer server) {
        boolean isReplay = false;
        if (CompatibilityManager.flashbackLoaded() && FlashbackCompatibility.isReplayServer(server)) {
            Main.LOGGER.info("Detected Flashback Replay");
            isReplay = true;
        }
        MainClient.isReplay = isReplay;
        if (Main.modDisabled()) {
            return;
        }
    }

    public static void onClientJoin(class_634 handler, PacketSender sender, class_310 client) {
        ClientTaskScheduler.schedulePriorityTask(20, () -> {
            if (MainClient.serverHandshake == HandshakeStatus.WAITING) {
                Main.LOGGER.info("Disabling the Life Series on the client.");
                MainClient.serverHandshake = HandshakeStatus.NOT_RECEIVED;
            }
        });
        if (Main.modDisabled()) {
            return;
        }
    }

    public static void onClientDisconnect(class_634 handler, class_310 client) {
        Main.LOGGER.info("Client disconnected from server, clearing some client data.");
        MainClient.resetClientData();
        if (Main.modDisabled()) {
            return;
        }
    }

    public static void onScreenOpen(class_310 client, class_437 screen, int scaledWidth, int scaledHeight) {
        if (Main.modDisabled()) {
            return;
        }
        if (UpdateChecker.updateAvailable) {
            int disableVersion = MainClient.clientConfig.getOrCreateInt("ignore_update", 0);
            if (UpdateChecker.version == disableVersion) {
                return;
            }
            if (screen instanceof class_442 && !hasShownUpdateScreen) {
                client.execute(() -> {
                    client.method_1507((class_437)new UpdateInfoScreen(UpdateChecker.versionName, UpdateChecker.versionDescription));
                    hasShownUpdateScreen = true;
                });
            }
        }
    }

    public static void onClientStart(class_310 client) {
        if (Main.modDisabled()) {
            return;
        }
    }

    public static void onClientTickStart() {
        if (Main.modDisabled()) {
            return;
        }
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player != null) {
            ClientEvents.sendPackets(player);
        }
    }

    public static void onClientTickEnd() {
        try {
            block9: {
                class_310 client;
                block10: {
                    ClientTaskScheduler.onClientTick();
                    if (Main.modFullyDisabled()) {
                        return;
                    }
                    client = class_310.method_1551();
                    class_746 player = client.field_1724;
                    ClientEvents.spawnInvisibilityParticles(client);
                    if (Main.modDisabled()) {
                        return;
                    }
                    if (player == null) break block9;
                    ClientEvents.tryTripleJump(player);
                    ClientEvents.checkOnGroundFor(player);
                    if (player.method_6113()) break block9;
                    if (client.field_1755 instanceof EmptySleepScreen || client.field_1755 instanceof NewQuizScreen) break block10;
                    class_437 class_4372 = client.field_1755;
                    if (!(class_4372 instanceof VotingScreen)) break block9;
                    VotingScreen votingScreen = (VotingScreen)class_4372;
                    if (!votingScreen.requiresSleep) break block9;
                }
                client.method_1507(null);
            }
            ClientKeybinds.tick();
            ClientSounds.updateSingleSoundVolumes();
            TextHud.tick();
            if (CompatibilityManager.voicechatLoaded()) {
                VoicechatClient.checkMute();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void checkOnGroundFor(class_746 player) {
        onGroundFor = !player.method_24828() ? 0L : ++onGroundFor;
    }

    public static void spawnInvisibilityParticles(class_310 client) {
        if (client.field_1687 == null) {
            return;
        }
        if (client.field_1687.field_9229.method_43048(15) != 0) {
            return;
        }
        for (class_1657 player : client.field_1687.method_18456()) {
            long time;
            if (!MainClient.invisiblePlayers.containsKey(player.method_5667()) || (time = MainClient.invisiblePlayers.get(player.method_5667()).longValue()) <= System.currentTimeMillis() && time != -1L) continue;
            class_702 particleManager = client.field_1713;
            double x = player.method_23317() + (Math.random() - 0.5) * 0.6;
            double y = player.method_23318() + Math.random() * 1.8;
            double z = player.method_23321() + (Math.random() - 0.5) * 0.6;
            class_9381 invisibilityParticle = class_9381.method_58256((class_2396)class_2398.field_11226, (int)545821109);
            particleManager.method_3056((class_2394)invisibilityParticle, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public static void sendPackets(class_746 player) {
        boolean jumping;
        if (MainClient.clientCurrentSeason == Seasons.WILD_LIFE && MainClient.clientActiveWildcards.contains((Object)Wildcards.SIZE_SHIFTING) && (jumping = player.field_3913.field_54155.comp_3163())) {
            if (MainClient.FIX_SIZECHANGING_BUGS) {
                class_4048 oldEntityDimensions = player.method_55694(player.method_18376()).method_18383(player.method_55693());
                class_238 oldBoundingBox = oldEntityDimensions.method_30757(player.method_73189());
                class_243 velocity = player.method_18798();
                float newScale = player.method_55693() + MainClient.SIZESHIFTING_CHANGE * 10.0f;
                class_4048 newEntityDimensions = player.method_55694(player.method_18376()).method_18383(newScale);
                class_238 newBoundingBox = newEntityDimensions.method_30757(player.method_73189());
                boolean oldSpaceEmpty = ClientUtils.isSpaceEmpty(player, oldBoundingBox, 0.0, 1.0E-5, 0.0);
                boolean newSpaceEmpty = ClientUtils.isSpaceEmpty(player, newBoundingBox, 0.0, 1.0E-5, 0.0);
                boolean predictedSpaceEmpty = ClientUtils.isSpaceEmpty(player, newBoundingBox, velocity.field_1352, velocity.field_1351 + 1.0E-5, velocity.field_1350);
                if (player.field_3913.method_3128().method_35584() != 0.0f) {
                    if (player.method_5757()) {
                        return;
                    }
                    if (!oldSpaceEmpty) {
                        return;
                    }
                    if (!newSpaceEmpty) {
                        return;
                    }
                    if (!predictedSpaceEmpty) {
                        return;
                    }
                }
            }
            NetworkHandlerClient.sendHoldingJumpPacket();
        }
    }

    public static void onClientJump(class_1297 entity) {
        if (entity instanceof class_746) {
            class_310 client = class_310.method_1551();
            class_746 player = client.field_1724;
            if (player == null) {
                return;
            }
            jumpCooldown = 3;
        }
    }

    private static void tryTripleJump(class_746 player) {
        if (jumpCooldown > 0) {
            --jumpCooldown;
        }
        if (player.method_24828()) {
            jumpedInAir = 0;
            return;
        }
        if (jumpedInAir >= 2) {
            return;
        }
        boolean shouldJump = false;
        boolean holdingJump = player.field_3913.field_54155.comp_3163();
        if (!lastJumping && holdingJump) {
            shouldJump = true;
        }
        lastJumping = holdingJump;
        if (!shouldJump) {
            return;
        }
        if (jumpCooldown > 0) {
            return;
        }
        if (!ClientEvents.hasTripleJumpEffect(player)) {
            return;
        }
        ++jumpedInAir;
        player.method_6043();
        player.method_73183().method_8486(player.method_23317(), player.method_23318(), player.method_23321(), (class_3414)class_3417.field_49044.comp_349(), class_3419.field_15250, 0.25f, 1.0f, false);
        NetworkHandlerClient.sendStringPacket(PacketNames.TRIPLE_JUMP, "");
    }

    private static boolean hasTripleJumpEffect(class_746 player) {
        for (Map.Entry entry : player.method_6088().entrySet()) {
            class_1293 jumpBoost;
            if (entry.getKey() != class_1294.field_5913 || (jumpBoost = (class_1293)entry.getValue()).method_5578() != 2 || jumpBoost.method_5584() > 220 || jumpBoost.method_5584() < 200) continue;
            return true;
        }
        return false;
    }
}

