/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.features;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.MainClient;
import net.mat0u5.lifeseries.gui.trivia.ConfirmQuizAnswerScreen;
import net.mat0u5.lifeseries.gui.trivia.NewQuizScreen;
import net.mat0u5.lifeseries.gui.trivia.QuizScreen;
import net.mat0u5.lifeseries.network.NetworkHandlerClient;
import net.mat0u5.lifeseries.network.packets.TriviaQuestionPayload;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.versions.VersionControl;
import net.minecraft.class_310;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class Trivia {
    public static String question = "";
    public static List<String> answers = new ArrayList<String>();
    public static int difficulty = 0;
    public static int secondsToComplete = 0;
    public static long timestamp = 0L;
    public static int ticksPassed = 0;

    public static void receiveTrivia(TriviaQuestionPayload payload) {
        question = payload.question();
        answers = payload.answers();
        difficulty = payload.difficulty();
        timestamp = payload.timestamp();
        secondsToComplete = payload.timeToComplete();
        if (VersionControl.isDevVersion()) {
            Main.LOGGER.info(TextUtils.formatString("[PACKET_CLIENT] Received trivia question: {{}, {}, {}}", question, difficulty, answers));
        }
        Trivia.openGui();
    }

    public static void updateTicksPassed(int ticksPassed) {
        Trivia.ticksPassed = ticksPassed;
    }

    public static int getRemainingTicks() {
        return secondsToComplete * 20 - ticksPassed;
    }

    public static int getRemainingSeconds() {
        return Trivia.getRemainingTicks() / 20;
    }

    public static boolean isDoingTrivia() {
        if (secondsToComplete == 0) {
            return false;
        }
        int remaining = Trivia.getRemainingSeconds();
        if (remaining <= 0) {
            return false;
        }
        return remaining <= 1000000;
    }

    public static void openGui() {
        if (question.isEmpty() || answers.isEmpty()) {
            return;
        }
        if (MainClient.clientCurrentSeason == Seasons.NICE_LIFE) {
            class_310.method_1551().method_1507((class_437)new NewQuizScreen());
        } else {
            class_310.method_1551().method_1507((class_437)new QuizScreen());
        }
    }

    public static void closeGui() {
        if (class_310.method_1551().field_1755 == null) {
            return;
        }
        if (class_310.method_1551().field_1755 instanceof QuizScreen || class_310.method_1551().field_1755 instanceof ConfirmQuizAnswerScreen) {
            class_310.method_1551().field_1755.method_25419();
        }
    }

    public static void resetTrivia() {
        question = "";
        answers = new ArrayList<String>();
        difficulty = 0;
        secondsToComplete = 0;
        timestamp = 0L;
        ticksPassed = 0;
        Trivia.closeGui();
    }

    public static void sendAnswer(int answer) {
        Trivia.resetTrivia();
        NetworkHandlerClient.sendTriviaAnswer(answer);
    }
}

