/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.gui.config.entries.extra;

import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.gui.config.entries.main.StringConfigEntry;
import net.mat0u5.lifeseries.network.NetworkHandlerClient;
import net.mat0u5.lifeseries.render.RenderUtils;
import net.mat0u5.lifeseries.utils.enums.ConfigTypes;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public class EventConfigEntry
extends StringConfigEntry {
    Boolean canceled;
    Boolean defaultCanceled;
    class_4185 canceledButton;
    public static final String tutorialLink = "https://mat0u5.github.io/LifeSeries-docs/integration/datapacks.html#events";
    final class_4185 openTutorialButton;

    public EventConfigEntry(String fieldName, String displayName, String description, String value, String defaultValue, String canceledStr) {
        super(fieldName, displayName, description, value, defaultValue);
        Boolean canceledBool = null;
        if (canceledStr.equalsIgnoreCase("true")) {
            canceledBool = true;
        }
        if (canceledStr.equalsIgnoreCase("false")) {
            canceledBool = false;
        }
        this.defaultCanceled = canceledBool;
        this.canceled = canceledBool;
        this.canceledButton = class_4185.method_46430((class_2561)class_2561.method_43473(), this::buttonClick).method_46434(0, 0, 60, 18).method_46431();
        this.openTutorialButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)"HERE"), this::openTutorial).method_46434(0, 0, 35, 18).method_46431();
        this.updateButton();
    }

    @Override
    protected void renderEntry(class_332 context, int x, int y, int width, int height, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        boolean isFirst;
        this.updateButton();
        this.canceledButton.method_25394(context, mouseX, mouseY, tickDelta);
        this.openTutorialButton.field_22764 = isFirst = this.isFirst();
        if (isFirst) {
            this.openTutorialButton.method_25394(context, mouseX, mouseY, tickDelta);
            this.openTutorialButton.method_46419(y + 1);
            class_2561 part1 = class_2561.method_30163((String)"\u00a7cLearn how to use Events");
            class_2561 part2 = class_2561.method_30163((String)"\u00a7cin the Life Series Wiki.");
            RenderUtils.text(part1, x + 10, y + 6).render(context, this.textRenderer);
            int widthText = this.textRenderer.method_27525((class_5348)part1);
            this.openTutorialButton.method_46421(x + widthText + 15);
            RenderUtils.text(part2, x + widthText + this.openTutorialButton.method_25368() + 20, y + 6).render(context, this.textRenderer);
        }
        super.renderEntry(context, x, y + (isFirst ? 20 : 0), width, height, mouseX, mouseY, hovered, tickDelta);
    }

    @Override
    public int additionalLabelOffsetY() {
        return this.isFirst() ? 20 : 0;
    }

    @Override
    public int additionalResetButtonOffsetY() {
        return this.isFirst() ? 20 : 0;
    }

    public boolean isFirst() {
        if (this.parentGroup == null) {
            return false;
        }
        return this.parentGroup.getChildEntries().indexOf(this) == 0;
    }

    @Override
    public int getPreferredHeight() {
        int heightMultiplier = 1;
        if (this.isFirst()) {
            ++heightMultiplier;
        }
        return 20 * heightMultiplier;
    }

    public void openTutorial(class_4185 button) {
        class_156.method_668().method_670(tutorialLink);
    }

    public void buttonClick(class_4185 button) {
        if (this.canceled == null) {
            return;
        }
        this.canceled = this.canceled == false;
        this.updateButton();
    }

    public void updateButton() {
        this.canceledButton.field_22763 = this.canceled != null;
        String text = "OVERRIDE";
        if (this.canceled == null || !this.canceled.booleanValue()) {
            text = "ALLOW";
        }
        this.canceledButton.method_25355(class_2561.method_30163((String)text));
        this.canceledButton.method_46421(this.textField.method_46426() - 10 - this.canceledButton.method_25368());
        this.canceledButton.method_46419(this.textField.method_46427());
    }

    @Override
    public void resetToDefault() {
        super.resetToDefault();
        this.canceled = this.defaultCanceled;
        this.updateButton();
    }

    @Override
    public int labelEndX() {
        return super.labelEndX() + this.canceledButton.method_25368() + 10;
    }

    @Override
    public boolean isModified() {
        return !Objects.equals(this.canceled, this.defaultCanceled) || super.isModified();
    }

    @Override
    public boolean canReset() {
        return this.isModified();
    }

    @Override
    public ConfigTypes getValueType() {
        return ConfigTypes.EVENT_ENTRY;
    }

    @Override
    public void onSave() {
        String canceledStr = this.canceled == null ? "" : String.valueOf(this.canceled);
        NetworkHandlerClient.sendConfigUpdate(this.getValueType().toString(), this.getFieldName(), List.of(this.getValueAsString(), canceledStr));
    }

    @Override
    protected boolean mouseClickedEntry(class_11909 click, boolean doubled) {
        if (this.canceledButton.method_25402(click, doubled) || this.openTutorialButton.method_25402(click, doubled)) {
            return true;
        }
        return super.mouseClickedEntry(click, doubled);
    }
}

