/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.gui.config.entries.extra;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.gui.config.entries.ConfigEntry;
import net.mat0u5.lifeseries.gui.config.entries.interfaces.IPopup;
import net.mat0u5.lifeseries.gui.config.entries.interfaces.ITextFieldAddonPopup;
import net.mat0u5.lifeseries.gui.config.entries.main.IntegerConfigEntry;
import net.mat0u5.lifeseries.utils.TextColors;
import net.mat0u5.lifeseries.utils.enums.ConfigTypes;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public class HeartsConfigEntry
extends IntegerConfigEntry
implements ITextFieldAddonPopup {
    private static final String HEART_SYMBOL = "\u2665";
    private static final String HEART_ROW = "\u2665\u2665\u2665\u2665\u2665\u2665\u2665\u2665\u2665\u2665";
    private static final String HALF_HEART_SYMBOL = "\u2661";

    public HeartsConfigEntry(String fieldName, String displayName, String description, int value, int defaultValue) {
        super(fieldName, displayName, description, value, defaultValue);
    }

    public HeartsConfigEntry(String fieldName, String displayName, String description, int value, int defaultValue, Integer minValue, Integer maxValue) {
        super(fieldName, displayName, description, value, defaultValue, minValue, maxValue);
    }

    @Override
    protected void renderEntry(class_332 context, int x, int y, int width, int height, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        super.renderEntry(context, x, y, width, height, mouseX, mouseY, hovered, tickDelta);
        this.renderPopup(context, mouseX, mouseY, tickDelta);
    }

    @Override
    public class_2561 getPopupText() {
        return class_2561.method_43473();
    }

    public List<class_5250> getHeartPopupText() {
        boolean hasHalfHeart;
        if (this.value == null) {
            return List.of();
        }
        int absValue = Math.abs((Integer)this.value);
        int hearts = absValue / 2;
        boolean bl = hasHalfHeart = absValue % 2 == 1;
        if (hearts == 0 && !hasHalfHeart) {
            return List.of(class_2561.method_43470((String)"\u00a77No hearts"));
        }
        if (absValue > 100) {
            return List.of(TextUtils.formatLoosely("\u00a77{} HP", this.value));
        }
        ArrayList<class_5250> heartsList = new ArrayList<class_5250>();
        StringBuilder topRow = new StringBuilder();
        for (int i = 0; i < hearts % 10; ++i) {
            topRow.append(HEART_SYMBOL);
        }
        if (hasHalfHeart) {
            topRow.append(HALF_HEART_SYMBOL);
        }
        if (!topRow.isEmpty()) {
            heartsList.add(class_2561.method_43470((String)topRow.toString()).method_27692(class_124.field_1061));
        }
        if (hearts >= 500) {
            hearts = 500;
        }
        while (hearts >= 10) {
            hearts -= 10;
            heartsList.add(class_2561.method_43470((String)HEART_ROW).method_27692(class_124.field_1061));
        }
        heartsList.set(heartsList.size() - 1, ((class_5250)heartsList.get(heartsList.size() - 1)).method_10852((class_2561)TextUtils.formatLoosely("\u00a77 ({} HP)", this.value)));
        return heartsList;
    }

    @Override
    public boolean shouldShowPopup() {
        if (this.textField == null) {
            return false;
        }
        if (this.hasError()) {
            return false;
        }
        if (this.isFocused()) {
            return true;
        }
        if (this.isHovered) {
            ConfigEntry entry = this.screen.getFocusedEntry();
            if (!(entry instanceof IPopup)) {
                return true;
            }
            IPopup popup = (IPopup)((Object)entry);
            if (popup == this) {
                return true;
            }
            return !popup.shouldShowPopup();
        }
        return false;
    }

    @Override
    public class_327 getTextRenderer() {
        return this.textRenderer;
    }

    @Override
    public class_342 getTextField() {
        return this.textField;
    }

    @Override
    public int getPopupWidth() {
        int maxWidth = 0;
        for (class_5250 text : this.getHeartPopupText()) {
            int width = this.getTextRenderer().method_27525((class_5348)text);
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        return maxWidth + 2;
    }

    @Override
    public int getPopupHeight() {
        Objects.requireNonNull(this.getTextRenderer());
        return (9 - 1) * this.getHeartPopupText().size() + 2;
    }

    @Override
    public void renderContent(class_332 context, int x, int y, int width, int height, int mouseX, int mouseY, float tickDelta) {
        class_327 textRenderer = this.getTextRenderer();
        int currentX = x + 1;
        int currentY = y + 1;
        for (class_5250 text : this.getHeartPopupText()) {
            context.method_51439(textRenderer, (class_2561)text, currentX, currentY, TextColors.WHITE, false);
            Objects.requireNonNull(this.getTextRenderer());
            currentY += 9 - 1;
        }
    }

    @Override
    public ConfigTypes getValueType() {
        return ConfigTypes.HEARTS;
    }
}

