/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.gui.config.entries.extra;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.MainClient;
import net.mat0u5.lifeseries.gui.config.entries.ConfigEntry;
import net.mat0u5.lifeseries.gui.config.entries.EmptyConfigEntry;
import net.mat0u5.lifeseries.network.NetworkHandlerClient;
import net.mat0u5.lifeseries.render.RenderUtils;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.utils.TextColors;
import net.mat0u5.lifeseries.utils.enums.ConfigTypes;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_5348;
import net.minecraft.class_8001;

@Environment(value=EnvType.CLIENT)
public class TeamConfigEntry
extends EmptyConfigEntry {
    public String teamNum;
    public String teamName;
    public String teamColor;
    public String allowedKill;
    public String gainLifeKill;
    public String defaultTeamNum;
    public String defaultTeamName;
    public String defaultTeamColor;
    public String defaultAllowedKill;
    public String defaultGainLifeKill;
    private int maxTextFieldLength = 8192;
    protected final class_342 textFieldLives;
    protected final class_342 textFieldName;
    protected final class_342 textFieldColor;
    protected final class_342 textFieldAllowedKill;
    protected final class_342 textFieldGainLife;
    protected final class_4185 deleteEntryButton;
    protected final class_4185 addEntryButton;

    public TeamConfigEntry(String fieldName, List<String> args) {
        super(fieldName, "", "");
        this.defaultTeamNum = args.get(3);
        this.defaultTeamName = args.get(4);
        this.defaultTeamColor = args.get(5);
        this.defaultAllowedKill = args.get(6);
        this.defaultGainLifeKill = args.get(7);
        this.teamNum = this.defaultTeamNum;
        this.teamName = this.defaultTeamName;
        this.teamColor = this.defaultTeamColor;
        this.allowedKill = this.defaultAllowedKill;
        this.gainLifeKill = this.defaultGainLifeKill;
        this.textFieldLives = new class_342(this.textRenderer, 0, 0, 30, 18, (class_2561)class_2561.method_43473());
        this.textFieldName = new class_342(this.textRenderer, 0, 0, 80, 18, (class_2561)class_2561.method_43473());
        this.textFieldColor = new class_342(this.textRenderer, 0, 0, 80, 18, (class_2561)class_2561.method_43473());
        this.textFieldAllowedKill = new class_342(this.textRenderer, 0, 0, 45, 18, (class_2561)class_2561.method_43473());
        this.textFieldGainLife = new class_342(this.textRenderer, 0, 0, 45, 18, (class_2561)class_2561.method_43473());
        this.textFieldLives.method_1852(this.teamNum);
        this.textFieldName.method_1852(this.teamName);
        this.textFieldColor.method_1852(this.teamColor);
        this.textFieldAllowedKill.method_1852(this.allowedKill);
        this.textFieldGainLife.method_1852(this.gainLifeKill);
        this.textFieldLives.method_1863(this::onChanged);
        this.textFieldName.method_1863(this::onChanged);
        this.textFieldColor.method_1863(this::onChanged);
        this.textFieldAllowedKill.method_1863(this::onChanged);
        this.textFieldGainLife.method_1863(this::onChanged);
        this.textFieldLives.method_1880(this.maxTextFieldLength);
        this.textFieldName.method_1880(this.maxTextFieldLength);
        this.textFieldColor.method_1880(this.maxTextFieldLength);
        this.textFieldAllowedKill.method_1880(this.maxTextFieldLength);
        this.textFieldGainLife.method_1880(this.maxTextFieldLength);
        this.deleteEntryButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)"\ud83d\uddd1"), this::deleteEntry).method_46434(0, 0, 16, 16).method_46431();
        this.addEntryButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)"+"), this::addEntry).method_46434(0, 0, 16, 16).method_46431();
    }

    @Override
    protected void renderEntry(class_332 context, int x, int y, int width, int height, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        boolean shouldShow;
        int field1X = x + 40;
        int field2X = x + 80;
        int field3X = x + 170;
        int field4X = x + 260;
        int field5X = x + 320;
        int field1CenterX = field1X + 15;
        int field2CenterX = field2X + 30;
        int field3CenterX = field3X + 30;
        int field4CenterX = field4X + 15;
        int field5CenterX = field5X + 15;
        if (this.isFirst()) {
            class_2561 header1Text = class_2561.method_30163((String)"\u00a7f\ud83d\udec8 Lives");
            class_2561 header2Text = class_2561.method_30163((String)"\u00a7fName");
            class_2561 header3Text = class_2561.method_30163((String)"\u00a7fColor");
            class_2561 header4Text = class_2561.method_30163((String)"\u00a7f\ud83d\udec8 Can Kill");
            class_2561 header5Text = class_2561.method_30163((String)"\u00a7f\ud83d\udec8 Gain Life");
            RenderUtils.text(header1Text, field1CenterX, y + 5).anchorCenter().render(context, this.textRenderer);
            RenderUtils.text(header2Text, field2CenterX, y + 5).anchorCenter().render(context, this.textRenderer);
            RenderUtils.text(header3Text, field3CenterX, y + 5).anchorCenter().render(context, this.textRenderer);
            RenderUtils.text(header4Text, field4CenterX, y + 5).anchorCenter().render(context, this.textRenderer);
            RenderUtils.text(header5Text, field5CenterX, y + 5).anchorCenter().render(context, this.textRenderer);
            if (hovered && mouseY >= y + 5) {
                Objects.requireNonNull(this.textRenderer);
                if (mouseY <= y + 5 + 9) {
                    class_2561 hoverText = null;
                    if (mouseX >= field1X && mouseX <= field1X + this.textRenderer.method_27525((class_5348)header1Text)) {
                        hoverText = class_2561.method_30163((String)"Lives boundary where players are put into this team (Rounded to nearest team with boundary <= lives).");
                    }
                    if (mouseX >= field4X && mouseX <= field4X + this.textRenderer.method_27525((class_5348)header4Text)) {
                        hoverText = class_2561.method_30163((String)"Lives boundary where this team can kill.\nFor example if set to 2, this team can kill any players with at least 2 lives.");
                    }
                    if (mouseX >= field5X && mouseX <= field5X + this.textRenderer.method_27525((class_5348)header5Text)) {
                        hoverText = class_2561.method_30163((String)"Lives boundary where this team can gain lives for killing.\nFor example if set to 4, this team will gain a life for killing players with at least 4 lives.");
                    }
                    if (hoverText != null) {
                        context.method_51436(this.textRenderer, this.textRenderer.method_1728((class_5348)hoverText, 210), class_8001.field_41687, mouseX, mouseY, false);
                    }
                }
            }
            y += 20;
        }
        this.textFieldLives.method_46419(y + 1);
        this.textFieldName.method_46419(y + 1);
        this.textFieldColor.method_46419(y + 1);
        this.textFieldAllowedKill.method_46419(y + 1);
        this.textFieldGainLife.method_46419(y + 1);
        this.textFieldLives.method_46421(field1X);
        this.textFieldName.method_46421(field2X);
        this.textFieldColor.method_46421(field3X);
        this.textFieldAllowedKill.method_46421(field4X);
        this.textFieldGainLife.method_46421(field5X);
        this.textFieldLives.method_25394(context, mouseX, mouseY, tickDelta);
        this.textFieldName.method_25394(context, mouseX, mouseY, tickDelta);
        this.textFieldColor.method_25394(context, mouseX, mouseY, tickDelta);
        this.textFieldAllowedKill.method_25394(context, mouseX, mouseY, tickDelta);
        this.textFieldGainLife.method_25394(context, mouseX, mouseY, tickDelta);
        this.deleteEntryButton.method_46421(x + 5);
        this.deleteEntryButton.method_46419(y + 2);
        this.deleteEntryButton.method_25394(context, mouseX, mouseY, tickDelta);
        this.addEntryButton.method_46421(x + 10);
        this.addEntryButton.method_46419(y + 20 + 2);
        if (this.isLast()) {
            this.addEntryButton.method_25394(context, mouseX, mouseY, tickDelta);
        }
        this.addEntryButton.field_22763 = shouldShow = MainClient.clientCurrentSeason != Seasons.LIMITED_LIFE;
        this.addEntryButton.field_22764 = shouldShow;
        this.deleteEntryButton.field_22763 = !this.isDefaultTeam();
        this.textFieldLives.method_1888(!this.isDefaultTeam());
        if (this.getTeamNum() == null) {
            this.textFieldLives.method_1868(TextColors.PASTEL_RED);
        } else {
            this.textFieldLives.method_1868(TextColors.WHITE);
        }
        class_124 teamColor = this.getTeamColor();
        if (teamColor == null || teamColor.method_532() == null) {
            this.textFieldColor.method_1868(TextColors.PASTEL_RED);
            this.textFieldName.method_1868(TextColors.WHITE);
        } else {
            this.textFieldColor.method_1868(TextColors.WHITE);
            this.textFieldName.method_1868(TextColors.toArgb(255, teamColor.method_532()));
        }
        Integer currentTeamAllowed = this.getTeamAllowedKill();
        Integer currentTeamGain = this.getTeamGainLifeKill();
        if (currentTeamAllowed == null && !this.allowedKill.isEmpty() || currentTeamAllowed != null && currentTeamAllowed < 0) {
            this.textFieldAllowedKill.method_1868(TextColors.PASTEL_RED);
        } else {
            this.textFieldAllowedKill.method_1868(TextColors.WHITE);
        }
        if (currentTeamGain == null && !this.gainLifeKill.isEmpty() || currentTeamGain != null && currentTeamGain < 0) {
            this.textFieldGainLife.method_1868(TextColors.PASTEL_RED);
        } else {
            this.textFieldGainLife.method_1868(TextColors.WHITE);
        }
    }

    public boolean isDefaultTeam() {
        return Objects.equals(this.defaultTeamNum, "0") || Objects.equals(this.defaultTeamNum, "1") || Objects.equals(this.defaultTeamNum, "2") || Objects.equals(this.defaultTeamNum, "3") || Objects.equals(this.defaultTeamNum, "4");
    }

    public void deleteEntry(class_4185 button) {
        if (this.isDefaultTeam()) {
            return;
        }
        if (this.parentGroup == null) {
            return;
        }
        try {
            this.parentGroup.getMainEntry().markChangedForever();
            this.parentGroup.getChildEntries().get(0).markChangedForever();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.parentGroup.removeChildEntry(this);
    }

    public void addEntry(class_4185 button) {
        if (this.parentGroup == null) {
            return;
        }
        int max = this.getTeamNum() != null ? this.getTeamNum() : 0;
        for (int i : this.getSisterTeamNums()) {
            if (i <= max) continue;
            max = i;
        }
        TeamConfigEntry newEntry = new TeamConfigEntry("dynamic_teams_" + String.valueOf(UUID.randomUUID()), List.of("", "", "", String.valueOf(max + 1), "New Team", "white", "", ""));
        this.parentGroup.addChildEntry(newEntry);
        newEntry.defaultTeamNum = "";
    }

    public boolean isFirst() {
        if (this.parentGroup == null) {
            return false;
        }
        return this.parentGroup.getChildEntries().indexOf(this) == 0;
    }

    public boolean isLast() {
        if (this.parentGroup == null) {
            return false;
        }
        if (MainClient.clientCurrentSeason == Seasons.LIMITED_LIFE) {
            return false;
        }
        return this.parentGroup.getChildEntries().indexOf(this) == this.parentGroup.getChildEntries().size() - 1;
    }

    @Override
    public int getPreferredHeight() {
        int heightMultiplier = 1;
        if (this.isFirst()) {
            ++heightMultiplier;
        }
        if (this.isLast()) {
            ++heightMultiplier;
        }
        return 20 * heightMultiplier;
    }

    @Override
    public int additionalResetButtonOffsetY() {
        return this.isFirst() ? 20 : 0;
    }

    public void onChanged(String text) {
        this.teamNum = this.textFieldLives.method_1882();
        this.teamName = this.textFieldName.method_1882();
        this.teamColor = this.textFieldColor.method_1882();
        this.allowedKill = this.textFieldAllowedKill.method_1882();
        this.gainLifeKill = this.textFieldGainLife.method_1882();
        this.markChanged();
        this.checkErrors();
    }

    public Integer getTeamNum() {
        try {
            return Integer.parseInt(this.teamNum);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getTeamName() {
        return this.teamName;
    }

    public class_124 getTeamColor() {
        try {
            return class_124.method_533((String)this.textFieldColor.method_1882());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Integer getTeamAllowedKill() {
        try {
            return Integer.parseInt(this.allowedKill);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Integer getTeamGainLifeKill() {
        try {
            return Integer.parseInt(this.gainLifeKill);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public List<TeamConfigEntry> sisterEntries() {
        ArrayList<TeamConfigEntry> result = new ArrayList<TeamConfigEntry>();
        if (this.parentGroup != null) {
            for (ConfigEntry entry : this.parentGroup.getChildEntries()) {
                TeamConfigEntry teamConfigEntry;
                if (!(entry instanceof TeamConfigEntry) || (teamConfigEntry = (TeamConfigEntry)entry) == this) continue;
                result.add(teamConfigEntry);
            }
        }
        return result;
    }

    public List<Integer> getSisterTeamNums() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (TeamConfigEntry entry : this.sisterEntries()) {
            Integer num = entry.getTeamNum();
            if (num == null) continue;
            result.add(num);
        }
        return result;
    }

    public void checkErrors() {
        if (this.getTeamColor() == null) {
            this.setError("Invalid color");
            return;
        }
        Integer currentTeamNum = this.getTeamNum();
        Integer currentAllowedKill = this.getTeamAllowedKill();
        Integer currentGainLife = this.getTeamGainLifeKill();
        if (currentTeamNum == null || currentAllowedKill == null && !this.allowedKill.isEmpty() || currentGainLife == null && !this.gainLifeKill.isEmpty()) {
            this.setError("Invalid number format");
            return;
        }
        if (currentTeamNum < 0 || currentAllowedKill != null && currentAllowedKill < 0 || currentGainLife != null && currentGainLife < 0) {
            this.setError("Boundaries cannot be less than 0");
            return;
        }
        if (this.getSisterTeamNums().contains(currentTeamNum)) {
            this.setError("Team boundary cannot be the same as another team.");
            return;
        }
        this.clearError();
        this.markChanged();
    }

    @Override
    public void resetToDefault() {
        this.textFieldLives.method_1852(this.defaultTeamNum);
        this.textFieldName.method_1852(this.defaultTeamName);
        this.textFieldColor.method_1852(this.defaultTeamColor);
        this.textFieldAllowedKill.method_1852(this.defaultAllowedKill);
        this.textFieldGainLife.method_1852(this.defaultGainLifeKill);
    }

    @Override
    public boolean isModified() {
        if (!Objects.equals(this.textFieldLives.method_1882(), this.defaultTeamNum)) {
            return true;
        }
        if (!Objects.equals(this.textFieldName.method_1882(), this.defaultTeamName)) {
            return true;
        }
        if (!Objects.equals(this.textFieldColor.method_1882(), this.defaultTeamColor)) {
            return true;
        }
        if (!Objects.equals(this.textFieldAllowedKill.method_1882(), this.defaultAllowedKill)) {
            return true;
        }
        return !Objects.equals(this.textFieldGainLife.method_1882(), this.defaultGainLifeKill);
    }

    @Override
    public boolean canReset() {
        return this.isModified();
    }

    @Override
    public void setFocused(boolean focused) {
        super.setFocused(focused);
        if (!focused) {
            this.textFieldLives.method_25365(false);
            this.textFieldName.method_25365(false);
            this.textFieldColor.method_25365(false);
            this.textFieldAllowedKill.method_25365(false);
            this.textFieldGainLife.method_25365(false);
        }
    }

    @Override
    protected boolean mouseClickedEntry(class_11909 click, boolean doubled) {
        boolean textFieldLivesClick = this.textFieldLives.method_25402(click, doubled);
        boolean textFieldNameClick = this.textFieldName.method_25402(click, doubled);
        boolean textFieldColorClick = this.textFieldColor.method_25402(click, doubled);
        boolean textFieldAllowedKillClick = this.textFieldAllowedKill.method_25402(click, doubled);
        boolean textFieldGainLifeClick = this.textFieldGainLife.method_25402(click, doubled);
        this.textFieldLives.method_25365(textFieldLivesClick);
        this.textFieldName.method_25365(textFieldNameClick);
        this.textFieldColor.method_25365(textFieldColorClick);
        this.textFieldAllowedKill.method_25365(textFieldAllowedKillClick);
        this.textFieldGainLife.method_25365(textFieldGainLifeClick);
        if (textFieldLivesClick || textFieldNameClick || textFieldColorClick || textFieldAllowedKillClick || textFieldGainLifeClick || this.deleteEntryButton.method_25402(click, doubled) || this.addEntryButton.method_25402(click, doubled)) {
            return true;
        }
        return super.mouseClickedEntry(click, doubled);
    }

    @Override
    protected boolean keyPressedEntry(class_11908 input) {
        if (this.textFieldLives.method_25404(input) || this.textFieldName.method_25404(input) || this.textFieldColor.method_25404(input) || this.textFieldAllowedKill.method_25404(input) || this.textFieldGainLife.method_25404(input)) {
            return true;
        }
        return super.keyPressedEntry(input);
    }

    @Override
    protected boolean charTypedEntry(class_11905 input) {
        if (this.textFieldLives.method_25400(input) || this.textFieldName.method_25400(input) || this.textFieldColor.method_25400(input) || this.textFieldAllowedKill.method_25400(input) || this.textFieldGainLife.method_25400(input)) {
            return true;
        }
        return super.charTypedEntry(input);
    }

    @Override
    public void onSave() {
        ArrayList<CallSite> allTeams = new ArrayList<CallSite>();
        allTeams.add((CallSite)((Object)("lives_" + this.teamNum)));
        for (TeamConfigEntry entry : this.sisterEntries()) {
            allTeams.add((CallSite)((Object)("lives_" + entry.teamNum)));
        }
        NetworkHandlerClient.sendStringListPacket(PacketNames.SET_TEAM, List.of(String.join((CharSequence)";", allTeams), this.teamNum, this.teamName, this.teamColor, this.allowedKill, this.gainLifeKill));
    }

    @Override
    public boolean isSearchable() {
        return false;
    }

    @Override
    public ConfigTypes getValueType() {
        return ConfigTypes.TEAM_ENTRY;
    }

    @Override
    public boolean hasResetButton() {
        return true;
    }
}

