/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.gui.config.entries.interfaces;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.render.RenderUtils;
import net.mat0u5.lifeseries.utils.TextColors;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public interface IPopup {
    public boolean shouldShowPopup();

    public int getPopupWidth();

    public int getPopupHeight();

    public void renderContent(class_332 var1, int var2, int var3, int var4, int var5, int var6, int var7, float var8);

    default public int getActualPopupWidth() {
        int width = this.getPopupWidth() + this.getPadding();
        if (width % 2 != 0) {
            ++width;
        }
        return width;
    }

    default public int getActualPopupHeight() {
        return this.getPopupHeight() + this.getPadding();
    }

    default public int getPadding() {
        return 4;
    }

    default public void renderPopup(class_332 context, int x, int y, int mouseX, int mouseY, float tickDelta) {
        if (!this.shouldShowPopup()) {
            return;
        }
        boolean offsetX = false;
        int offsetY = 0;
        context.method_51448().pushMatrix();
        int width = this.getActualPopupWidth();
        int height = this.getActualPopupHeight();
        this.renderBackground(context, x, y + offsetY, width, height, mouseX, mouseY, tickDelta);
        this.renderContent(context, x + this.getPadding() / 2, y + this.getPadding() / 2 + offsetY, width, height, mouseX, mouseY, tickDelta);
        context.method_51448().popMatrix();
    }

    default public void renderBackground(class_332 context, int x, int y, int width, int height, int mouseX, int mouseY, float tickDelta) {
        context.method_25294(x, y, x + width, y + height, TextColors.LIGHT_BLACK);
        RenderUtils.drawBorder(context, x, y, width, height, TextColors.LIGHT_GRAY);
    }
}

