/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.gui.seasons;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.gui.DefaultScreen;
import net.mat0u5.lifeseries.gui.seasons.ChooseSeasonScreen;
import net.mat0u5.lifeseries.gui.seasons.ConfirmSeasonAnswerScreen;
import net.mat0u5.lifeseries.network.NetworkHandlerClient;
import net.mat0u5.lifeseries.render.RenderUtils;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.utils.TextColors;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public class ChooseExtraSeasonScreen
extends DefaultScreen {
    public static boolean hasSelectedBefore = false;
    private List<ChooseSeasonScreen.SeasonRegion> seasonRegions = new ArrayList<ChooseSeasonScreen.SeasonRegion>();
    private static final int ROWS = 1;
    private static final int LOGO_TEXTURE_SIZE = 256;
    private static final float LOGO_SCALE = 0.2f;
    private static final int LOGO_SIZE = 51;

    public ChooseExtraSeasonScreen(boolean hasSelectedBefore) {
        super((class_2561)class_2561.method_43470((String)"Choose April Season Screen"), 190, 100);
        ChooseExtraSeasonScreen.hasSelectedBefore = hasSelectedBefore;
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.addSeasonRegions();
    }

    public void addSeasonRegions() {
        this.seasonRegions.clear();
        List<Seasons> seasons = Seasons.getAprilFoolsSeasons();
        int PADDING = 8;
        List<List<Seasons>> rows = ChooseSeasonScreen.splitIntoRows(seasons, 1);
        int currentRegionIndex = 1;
        int currentY = this.startY + 30;
        for (List<Seasons> row : rows) {
            int columns = row.size();
            int currentX = this.startX + (this.BG_WIDTH - (51 * columns + PADDING * (columns - 1))) / 2;
            for (Seasons season : row) {
                this.seasonRegions.add(ChooseSeasonScreen.getSeasonRegion(currentRegionIndex, season, currentX, currentY, 51, 51));
                ++currentRegionIndex;
                currentX += 51 + PADDING;
            }
            currentY += 51;
        }
    }

    public int getRegion(int x, int y) {
        for (ChooseSeasonScreen.SeasonRegion region : this.seasonRegions) {
            if (x < region.bounds().x || x > region.bounds().x + region.bounds().width || y < region.bounds().y || y > region.bounds().y + region.bounds().height) continue;
            return region.id();
        }
        class_2561 goBack = class_2561.method_30163((String)"Go Back");
        int textWidth = this.field_22793.method_27525((class_5348)goBack);
        Objects.requireNonNull(this.field_22793);
        int textHeight = 9;
        Rectangle rect = new Rectangle(this.startX + 6, this.endY - 8 - textHeight, textWidth + 1, textHeight + 1);
        if (x >= rect.x && x <= rect.x + rect.width && y >= rect.y && y <= rect.y + rect.height) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean method_25402(class_11909 click, boolean doubled) {
        double mouseX = click.comp_4798();
        double mouseY = click.comp_4799();
        if (click.method_74245() == 0) {
            int region = this.getRegion((int)mouseX, (int)mouseY);
            if (region == -1 && this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new ChooseSeasonScreen(hasSelectedBefore));
                return true;
            }
            if (region != 0) {
                this.handleSeasonRegionClick(region);
                return true;
            }
        }
        return super.method_25402(click, doubled);
    }

    public void handleSeasonRegionClick(int region) {
        for (ChooseSeasonScreen.SeasonRegion seasonRegion : this.seasonRegions) {
            if (seasonRegion.id() != region) continue;
            if (hasSelectedBefore && this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new ConfirmSeasonAnswerScreen(this, seasonRegion.season()));
                continue;
            }
            NetworkHandlerClient.sendStringPacket(PacketNames.SET_SEASON, seasonRegion.season().getName());
            this.method_25419();
        }
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY) {
        int currentRegion = this.getRegion(mouseX, mouseY);
        for (ChooseSeasonScreen.SeasonRegion seasonRegion : this.seasonRegions) {
            ChooseSeasonScreen.renderSeasonRegion(context, seasonRegion, currentRegion, 256, 0.2f);
        }
        String prompt = "Select the season you want to play.";
        RenderUtils.text(prompt, this.centerX, this.startY + 15).anchorCenter().render(context, this.field_22793);
        class_2561 goBack = class_2561.method_30163((String)"Go Back");
        int textWidth = this.field_22793.method_27525((class_5348)goBack);
        Objects.requireNonNull(this.field_22793);
        int textHeight = 9;
        Rectangle rect = new Rectangle(this.startX + 6, this.endY - 8 - textHeight, textWidth + 1, textHeight + 1);
        context.method_25294(rect.x - 1, rect.y - 1, rect.x + rect.width + 1, rect.y, DEFAULT_TEXT_COLOR);
        context.method_25294(rect.x - 1, rect.y + rect.height, rect.x + rect.width + 2, rect.y + rect.height + 2, DEFAULT_TEXT_COLOR);
        context.method_25294(rect.x - 1, rect.y, rect.x, rect.y + rect.height, DEFAULT_TEXT_COLOR);
        context.method_25294(rect.x + rect.width, rect.y - 1, rect.x + rect.width + 2, rect.y + rect.height, DEFAULT_TEXT_COLOR);
        int color = DEFAULT_TEXT_COLOR;
        if (currentRegion == -1) {
            color = TextColors.PURE_WHITE;
        }
        RenderUtils.text(goBack, rect.x + 1, rect.y + 1).colored(color).render(context, this.field_22793);
    }
}

