/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.gui.trivia;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.gui.EmptySleepScreen;
import net.mat0u5.lifeseries.network.NetworkHandlerClient;
import net.mat0u5.lifeseries.render.RenderUtils;
import net.mat0u5.lifeseries.utils.TextColors;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_634;
import net.minecraft.class_640;

@Environment(value=EnvType.CLIENT)
public class VotingScreen
extends class_437 {
    private static final int PLAYER_ENTRY_HEIGHT = 32;
    private static final int LIST_TOP = 40;
    private static final int LIST_BOTTOM_OFFSET = 35;
    private static final float LIST_WIDTH_PERCENT = 0.33f;
    private class_342 searchBox;
    private class_4185 submitButton;
    private List<PlayerEntry> players;
    private List<PlayerEntry> filteredPlayers;
    private int scrollOffset = 0;
    private int maxScroll = 0;
    private String selectedPlayer = null;
    private final List<String> availablePlayers;
    public int timerSeconds = 60;
    public boolean requiresSleep = false;
    private int listLeft;
    private int listRight;
    private int listWidth;

    public VotingScreen(String name, List<String> availablePlayers) {
        super((class_2561)class_2561.method_43470((String)name));
        if (name.endsWith("nice") || name.endsWith("naughty")) {
            this.requiresSleep = true;
        }
        this.availablePlayers = availablePlayers;
    }

    public void method_25393() {
        super.method_25393();
        if (this.timerSeconds <= 0) {
            this.method_25419();
        }
    }

    protected void method_25426() {
        this.listWidth = (int)((float)this.field_22789 * 0.33f);
        this.listLeft = (this.field_22789 - this.listWidth) / 2;
        this.listRight = this.listLeft + this.listWidth;
        this.players = new ArrayList<PlayerEntry>();
        this.filteredPlayers = new ArrayList<PlayerEntry>();
        class_634 connection = this.field_22787.method_1562();
        if (connection != null) {
            for (class_640 playerInfo : connection.method_2880()) {
                String name = OtherUtils.profileName(playerInfo.method_2966());
                class_2960 skin = playerInfo.method_52810().comp_1626().comp_3627();
                if (!this.availablePlayers.contains(name)) continue;
                this.players.add(new PlayerEntry(name, skin));
                this.filteredPlayers.add(new PlayerEntry(name, skin));
            }
        }
        this.filteredPlayers.sort((entry1, entry2) -> entry1.name.toLowerCase().compareTo(entry2.name.toLowerCase()));
        this.searchBox = new class_342(this.field_22793, this.listLeft, 25, this.listWidth - 100, 20, (class_2561)class_2561.method_43470((String)""));
        this.searchBox.method_47404((class_2561)class_2561.method_43470((String)"\u00a77\u00a7oSearch..."));
        this.searchBox.method_1858(false);
        this.searchBox.method_1863(this::onSearchChanged);
        this.method_25429((class_364)this.searchBox);
        this.submitButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Submit Vote"), button -> this.onSubmitVote()).method_46434(this.field_22789 / 2 - 100, this.field_22790 - 23, 200, 20).method_46431();
        this.method_37063((class_364)this.submitButton);
        this.updateMaxScroll();
    }

    private void onSearchChanged(String search) {
        this.filteredPlayers.clear();
        String lowerSearch = search.toLowerCase();
        for (PlayerEntry player : this.players) {
            if (!player.name.toLowerCase().contains(lowerSearch)) continue;
            this.filteredPlayers.add(player);
        }
        this.filteredPlayers.sort((entry1, entry2) -> entry1.name.toLowerCase().compareTo(entry2.name.toLowerCase()));
        this.scrollOffset = 0;
        this.updateMaxScroll();
    }

    private void updateMaxScroll() {
        int listHeight = this.field_22790 - 40 - 35;
        int totalHeight = this.filteredPlayers.size() * 36;
        this.maxScroll = Math.max(0, totalHeight - listHeight);
    }

    public boolean method_25422() {
        return !this.requiresSleep;
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        RenderUtils.text(this.field_22785, this.field_22789 / 2, 10).anchorCenter().colored(TextColors.WHITE).withShadow().render(graphics, this.field_22793);
        this.searchBox.method_25394(graphics, mouseX, mouseY, partialTick);
        boolean bl = this.submitButton.field_22763 = this.selectedPlayer != null && !this.selectedPlayer.isEmpty();
        if (this.requiresSleep) {
            long minutes = this.timerSeconds / 60;
            long seconds = (long)this.timerSeconds - minutes * 60L;
            Object secondsStr = String.valueOf(seconds);
            Object minutesStr = String.valueOf(minutes);
            while (((String)secondsStr).length() < 2) {
                secondsStr = "0" + (String)secondsStr;
            }
            while (((String)minutesStr).length() < 2) {
                minutesStr = "0" + (String)minutesStr;
            }
            class_5250 timerText = TextUtils.format("{}:{}", minutesStr, secondsStr);
            RenderUtils.text((class_2561)timerText, this.listRight, 25).anchorCenter().colored(TextColors.WHITE).withShadow().render(graphics, this.field_22793);
        }
        int listTop = 40;
        int listBottom = this.field_22790 - 35;
        int listHeight = listBottom - listTop;
        graphics.method_44379(this.listLeft, listTop, this.listRight, listBottom);
        int posY = listTop - this.scrollOffset;
        for (int i = 0; i < this.filteredPlayers.size(); ++i) {
            PlayerEntry player = this.filteredPlayers.get(i);
            if (posY + 32 > listTop && posY < listBottom) {
                boolean hovered = mouseX >= this.listLeft && mouseX <= this.listRight && mouseY >= posY && mouseY <= posY + 32;
                boolean selected = player.name.equals(this.selectedPlayer);
                this.drawPlayerEntry(graphics, player, this.listLeft, posY, this.listWidth, hovered, selected);
            }
            posY += 36;
        }
        graphics.method_44380();
        if (this.maxScroll > 0) {
            this.drawScrollbar(graphics, listTop, listBottom);
        }
        super.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    private void drawPlayerEntry(class_332 graphics, PlayerEntry player, int x, int y, int width, boolean hovered, boolean selected) {
        int bgColor = selected ? TextColors.BLACK_A192 : (hovered ? TextColors.BLACK_A128 : TextColors.BLACK_A96);
        graphics.method_25294(x, y, x + width, y + 32, bgColor);
        RenderUtils.texture(player.skin, x + 4, y + 4, 8, 8).outSize(24, 24).uv(8, 8).textureSize(64, 64).render(graphics);
        RenderUtils.texture(player.skin, x + 4, y + 4, 8, 8).outSize(24, 24).uv(40, 8).textureSize(64, 64).render(graphics);
        RenderUtils.text(player.name, x + 32, y + 12).colored(TextColors.WHITE).withShadow().render(graphics, this.field_22793);
    }

    private void drawScrollbar(class_332 graphics, int listTop, int listBottom) {
        int scrollbarX = this.listRight + 9;
        int scrollbarHeight = listBottom - listTop;
        int thumbHeight = Math.max(20, scrollbarHeight * scrollbarHeight / (this.filteredPlayers.size() * 32));
        int thumbY = listTop + (int)((float)(scrollbarHeight - thumbHeight) * ((float)this.scrollOffset / (float)this.maxScroll));
        graphics.method_25294(scrollbarX, listTop, scrollbarX + 6, listBottom, TextColors.BLACK);
        graphics.method_25294(scrollbarX, thumbY, scrollbarX + 6, thumbY + thumbHeight, TextColors.LIGHT_GRAY);
        graphics.method_25294(scrollbarX, thumbY, scrollbarX + 5, thumbY + thumbHeight - 1, TextColors.GUI_BACKGROUND);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.maxScroll > 0) {
            this.scrollOffset = Math.max(0, Math.min(this.maxScroll, this.scrollOffset - (int)(scrollY * 32.0)));
            return true;
        }
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        int clickedIndex;
        int mouseX = (int)click.comp_4798();
        int mouseY = (int)click.comp_4799();
        if (this.searchBox.method_25402(click, doubled)) {
            this.searchBox.method_25365(true);
            return true;
        }
        this.searchBox.method_25365(false);
        int listTop = 40;
        int listBottom = this.field_22790 - 35;
        if (mouseX >= this.listLeft && mouseX <= this.listRight && mouseY >= listTop && mouseY <= listBottom && (clickedIndex = (mouseY - listTop + this.scrollOffset) / 36) >= 0 && clickedIndex < this.filteredPlayers.size()) {
            this.selectedPlayer = this.filteredPlayers.get((int)clickedIndex).name;
            return true;
        }
        return super.method_25402(click, doubled);
    }

    public boolean method_25404(class_11908 input) {
        if (this.searchBox.method_25404(input)) {
            return true;
        }
        return super.method_25404(input);
    }

    public boolean method_25400(class_11905 input) {
        if (this.searchBox.method_25400(input)) {
            return true;
        }
        return super.method_25400(input);
    }

    private void onSubmitVote() {
        if (this.selectedPlayer != null) {
            if (this.requiresSleep) {
                class_310.method_1551().method_1507((class_437)new EmptySleepScreen(false));
            } else {
                class_310.method_1551().method_1507(null);
            }
            NetworkHandlerClient.sendStringPacket(PacketNames.SUBMIT_VOTE, this.selectedPlayer);
        }
    }

    public boolean method_25421() {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    private static class PlayerEntry {
        final String name;
        final class_2960 skin;

        PlayerEntry(String name, class_2960 skin) {
            this.name = name;
            this.skin = skin;
        }
    }
}

