/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.render;

import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.utils.TextColors;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

@Environment(value=EnvType.CLIENT)
public class CustomTextRenderer {
    private final class_2561 text;
    private class_5481 orderedText;
    private final double x;
    private final double y;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private boolean shadow = false;
    private int textColor = TextColors.DEFAULT;
    private Anchor anchor = Anchor.LEFT;
    private boolean wrapLines = false;
    private int wrapMaxWidth = 100;
    private int wrapGapY = 7;

    public CustomTextRenderer(class_2561 text, double x, double y) {
        this.x = x;
        this.y = y;
        this.text = text;
        this.orderedText = null;
    }

    public CustomTextRenderer(class_5481 orderedText, double x, double y) {
        this.x = x;
        this.y = y;
        this.orderedText = orderedText;
        this.text = null;
    }

    public CustomTextRenderer anchorCenter() {
        this.anchor = Anchor.CENTER;
        return this;
    }

    public CustomTextRenderer anchorRight() {
        this.anchor = Anchor.RIGHT;
        return this;
    }

    public CustomTextRenderer withShadow() {
        this.shadow = true;
        return this;
    }

    public CustomTextRenderer wrapLines(int maxWidth, int gapY) {
        this.wrapLines = true;
        this.wrapMaxWidth = maxWidth;
        this.wrapGapY = gapY;
        if (this.orderedText == null && this.text != null) {
            this.orderedText = this.text.method_30937();
        }
        return this;
    }

    public CustomTextRenderer scaled(float newScaleX, float newScaleY) {
        this.scaleX = newScaleX;
        this.scaleY = newScaleY;
        return this;
    }

    public CustomTextRenderer colored(int color) {
        this.textColor = color;
        return this;
    }

    private boolean isScaled() {
        return this.scaleX != 1.0f || this.scaleY != 1.0f;
    }

    public int render(class_332 context, class_327 textRenderer) {
        if (this.isScaled()) {
            context.method_51448().pushMatrix();
            context.method_51448().scale(this.scaleX, this.scaleY);
        }
        Objects.requireNonNull(textRenderer);
        int renderedTextHeight = 9;
        double offsetX = 0.0;
        double textWidth = 0.0;
        if (this.text != null) {
            textWidth = textRenderer.method_27525((class_5348)this.text);
        }
        if (this.orderedText != null) {
            textWidth = textRenderer.method_30880(this.orderedText);
        }
        if (this.anchor == Anchor.CENTER) {
            offsetX -= textWidth / 2.0;
        }
        if (this.anchor == Anchor.RIGHT) {
            offsetX -= textWidth;
        }
        if (this.orderedText != null) {
            if (this.wrapLines) {
                List wrappedText = textRenderer.method_1728((class_5348)this.text, this.wrapMaxWidth);
                int offsetY = 0;
                for (class_5481 line : wrappedText) {
                    context.method_51430(textRenderer, line, (int)(this.x / (double)this.scaleX + offsetX), (int)(this.y / (double)this.scaleY + (double)offsetY), this.textColor, this.shadow);
                    Objects.requireNonNull(textRenderer);
                    offsetY += 9 + this.wrapGapY;
                }
                renderedTextHeight = offsetY;
            } else {
                context.method_51430(textRenderer, this.orderedText, (int)(this.x / (double)this.scaleX + offsetX), (int)(this.y / (double)this.scaleY), this.textColor, this.shadow);
            }
        } else if (this.text != null) {
            context.method_51439(textRenderer, this.text, (int)(this.x / (double)this.scaleX + offsetX), (int)(this.y / (double)this.scaleY), this.textColor, this.shadow);
        }
        if (this.isScaled()) {
            context.method_51448().popMatrix();
        }
        return renderedTextHeight;
    }

    @Environment(value=EnvType.CLIENT)
    public static enum Anchor {
        LEFT,
        CENTER,
        RIGHT;

    }
}

