/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.render;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_2960;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class CustomTextureRenderer {
    private final class_2960 texture;
    private final float x;
    private final float y;
    private final int width;
    private final int height;
    private int outWidth;
    private int outHeight;
    private int textureWidth;
    private int textureHeight;
    private int u = 0;
    private int v = 0;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;

    public CustomTextureRenderer(class_2960 texture, float x, float y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.outWidth = width;
        this.outHeight = height;
        this.textureWidth = width;
        this.textureHeight = height;
        this.texture = texture;
    }

    public CustomTextureRenderer scaled(float newScaleX, float newScaleY) {
        this.scaleX = newScaleX;
        this.scaleY = newScaleY;
        return this;
    }

    public CustomTextureRenderer uv(int newU, int newV) {
        this.u = newU;
        this.v = newV;
        return this;
    }

    public CustomTextureRenderer outSize(int newOutWidth, int newOutHeight) {
        this.outWidth = newOutWidth;
        this.outHeight = newOutHeight;
        return this;
    }

    public CustomTextureRenderer textureSize(int newTextureWidth, int newTextureHeight) {
        this.textureWidth = newTextureWidth;
        this.textureHeight = newTextureHeight;
        return this;
    }

    private boolean isScaled() {
        return this.scaleX != 1.0f || this.scaleY != 1.0f;
    }

    public void render(class_332 context) {
        if (this.isScaled()) {
            context.method_51448().pushMatrix();
            context.method_51448().scale(this.scaleX, this.scaleY);
        }
        context.method_25302(class_10799.field_56883, this.texture, (int)(this.x / this.scaleX), (int)(this.y / this.scaleY), (float)this.u, (float)this.v, this.outWidth, this.outHeight, this.width, this.height, this.textureWidth, this.textureHeight);
        if (this.isScaled()) {
            context.method_51448().popMatrix();
        }
    }
}

