/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.boogeyman;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.command.manager.Command;
import net.mat0u5.lifeseries.seasons.boogeyman.Boogeyman;
import net.mat0u5.lifeseries.seasons.boogeyman.BoogeymanManager;
import net.mat0u5.lifeseries.seasons.season.pastlife.PastLifeBoogeymanManager;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class BoogeymanCommand
extends Command {
    @Override
    public boolean isAllowed() {
        return this.getBM().BOOGEYMAN_ENABLED;
    }

    @Override
    public class_2561 getBannedText() {
        return class_2561.method_30163((String)"This command is only available when the boogeyman has been enabled in the Life Series config.");
    }

    @Override
    public List<String> getAdminCommands() {
        return List.of("boogeyman");
    }

    @Override
    public List<String> getNonAdminCommands() {
        return List.of("boogeyman");
    }

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)BoogeymanCommand.literal("boogeyman").executes(context -> this.boogeyCheck((class_2168)context.getSource()))).then(((LiteralArgumentBuilder)BoogeymanCommand.literal("clear").requires(PermissionManager::isAdmin)).executes(context -> this.boogeyClear((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)BoogeymanCommand.literal("list").requires(PermissionManager::isAdmin)).executes(context -> this.boogeyList((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)BoogeymanCommand.literal("count").requires(PermissionManager::isAdmin)).executes(context -> this.boogeyCount((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)BoogeymanCommand.literal("add").requires(PermissionManager::isAdmin)).then(BoogeymanCommand.argument("player", class_2186.method_9308()).executes(context -> this.addBoogey((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player")))))).then(((LiteralArgumentBuilder)BoogeymanCommand.literal("remove").requires(PermissionManager::isAdmin)).then(BoogeymanCommand.argument("player", class_2186.method_9308()).executes(context -> this.removeBoogey((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player")))))).then(((LiteralArgumentBuilder)BoogeymanCommand.literal("reset").requires(PermissionManager::isAdmin)).then(BoogeymanCommand.argument("player", class_2186.method_9308()).executes(context -> this.resetBoogey((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player")))))).then(((LiteralArgumentBuilder)BoogeymanCommand.literal("cure").requires(PermissionManager::isAdmin)).then(BoogeymanCommand.argument("player", class_2186.method_9308()).executes(context -> this.cureBoogey((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player")))))).then(((LiteralArgumentBuilder)BoogeymanCommand.literal("fail").requires(PermissionManager::isAdmin)).then(BoogeymanCommand.argument("player", class_2186.method_9308()).executes(context -> this.failBoogey((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player")))))).then(((LiteralArgumentBuilder)BoogeymanCommand.literal("selfFail").then(BoogeymanCommand.literal("confirm").executes(context -> this.selfFailBoogey((class_2168)context.getSource(), true)))).executes(context -> this.selfFailBoogey((class_2168)context.getSource(), false)))).then(((LiteralArgumentBuilder)BoogeymanCommand.literal("randomize").requires(PermissionManager::isAdmin)).executes(context -> this.boogeyChooseRandom((class_2168)context.getSource()))));
    }

    public BoogeymanManager getBM() {
        return Main.currentSeason.boogeymanManager;
    }

    public int boogeyCheck(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        class_3222 self = source.method_44023();
        if (self == null) {
            return -1;
        }
        BoogeymanManager bm = this.getBM();
        if (bm == null) {
            return -1;
        }
        if (!bm.isBoogeyman(self)) {
            source.method_9213(class_2561.method_30163((String)"You are not a Boogeyman"));
            return -1;
        }
        Boogeyman boogeyman = bm.getBoogeyman(self);
        if (boogeyman != null) {
            if (boogeyman.failed) {
                OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"\u00a77You were the Boogeyman, but you have already \u00a7cfailed\u00a77."));
                return 1;
            }
            if (boogeyman.cured) {
                OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"\u00a77You were the Boogeyman, and you have already been \u00a7acured\u00a77."));
                return 1;
            }
        }
        if (bm instanceof PastLifeBoogeymanManager) {
            OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"\u00a7cYou are the Boogeyman."));
        }
        bm.messageBoogeyman(boogeyman, self);
        return 1;
    }

    public int selfFailBoogey(class_2168 source, boolean confirm) {
        if (this.checkBanned(source)) {
            return -1;
        }
        class_3222 self = source.method_44023();
        if (self == null) {
            return -1;
        }
        BoogeymanManager bm = this.getBM();
        if (bm == null) {
            return -1;
        }
        if (!bm.isBoogeyman(self)) {
            source.method_9213(class_2561.method_30163((String)"You are not a Boogeyman"));
            return -1;
        }
        Boogeyman boogeyman = bm.getBoogeyman(self);
        if (boogeyman != null) {
            if (boogeyman.cured) {
                source.method_9213(class_2561.method_30163((String)"You have already been cured"));
                return -1;
            }
            if (boogeyman.failed) {
                source.method_9213(class_2561.method_30163((String)"You have already failed"));
                return -1;
            }
        }
        if (!confirm) {
            source.method_9213(class_2561.method_30163((String)"Warning: This will cause you to fail as the Boogeyman"));
            source.method_9213(class_2561.method_30163((String)"Run \"/boogeyman selfFail \u00a7lconfirm\u00a7r\" to confirm this action."));
            return -1;
        }
        if (!bm.BOOGEYMAN_ANNOUNCE_OUTCOME) {
            OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"\u00a77Failing as the Boogeyman..."));
        } else {
            PlayerUtils.broadcastMessage((class_2561)TextUtils.format("{}\u00a77 voulentarily failed themselves as the Boogeyman. They have been consumed by the curse.", self));
        }
        bm.playerFailBoogeymanManually(self, false);
        return 1;
    }

    public int failBoogey(class_2168 source, Collection<class_3222> targets) {
        class_3222 target;
        if (this.checkBanned(source)) {
            return -1;
        }
        BoogeymanManager bm = this.getBM();
        if (bm == null) {
            return -1;
        }
        if (targets.size() == 1 && !bm.isBoogeyman(target = targets.iterator().next())) {
            source.method_9213(class_2561.method_30163((String)"That player is not a Boogeyman"));
            return -1;
        }
        for (class_3222 player : targets) {
            bm.playerFailBoogeymanManually(player, true);
        }
        if (!bm.BOOGEYMAN_ANNOUNCE_OUTCOME) {
            if (targets.size() == 1) {
                OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("\u00a77Failing Boogeyman for {}\u00a77...", targets.iterator().next()));
            } else {
                OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("\u00a77Failing Boogeyman for {} targets\u00a77...", targets.size()));
            }
        }
        return 1;
    }

    public int resetBoogey(class_2168 source, Collection<class_3222> targets) {
        class_3222 target;
        if (this.checkBanned(source)) {
            return -1;
        }
        BoogeymanManager bm = this.getBM();
        if (bm == null) {
            return -1;
        }
        if (targets.size() == 1 && !bm.isBoogeyman(target = targets.iterator().next())) {
            source.method_9213(class_2561.method_30163((String)"That player is not a Boogeyman"));
            return -1;
        }
        for (class_3222 player : targets) {
            bm.reset(player);
        }
        if (targets.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("\u00a77Resetting Boogeyman cure/failure for {}\u00a77...", targets.iterator().next()));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("\u00a77Resetting Boogeyman cure/failure for {} targets\u00a77...", targets.size()));
        }
        return 1;
    }

    public int cureBoogey(class_2168 source, Collection<class_3222> targets) {
        class_3222 target;
        if (this.checkBanned(source)) {
            return -1;
        }
        BoogeymanManager bm = this.getBM();
        if (bm == null) {
            return -1;
        }
        if (targets.size() == 1 && !bm.isBoogeyman(target = targets.iterator().next())) {
            source.method_9213(class_2561.method_30163((String)"That player is not a Boogeyman"));
            return -1;
        }
        for (class_3222 player : targets) {
            bm.cure(player);
        }
        if (!bm.BOOGEYMAN_ANNOUNCE_OUTCOME) {
            if (targets.size() == 1) {
                OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("\u00a77Curing {}\u00a77...", targets.iterator().next()));
            } else {
                OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("\u00a77Curing {} targets\u00a77...", targets.size()));
            }
        }
        return 1;
    }

    public int addBoogey(class_2168 source, Collection<class_3222> targets) {
        class_3222 target;
        if (this.checkBanned(source)) {
            return -1;
        }
        BoogeymanManager bm = this.getBM();
        if (bm == null) {
            return -1;
        }
        if (targets.size() == 1 && bm.isBoogeyman(target = targets.iterator().next())) {
            source.method_9213(class_2561.method_30163((String)"That player is already a Boogeyman"));
            return -1;
        }
        for (class_3222 player : targets) {
            if (bm.isBoogeyman(player)) continue;
            bm.addBoogeymanManually(player);
        }
        if (targets.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("{} is now a Boogeyman", targets.iterator().next()));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("{} targets are now Boogeymen", targets.size()));
        }
        return 1;
    }

    public int removeBoogey(class_2168 source, Collection<class_3222> targets) {
        class_3222 target;
        if (this.checkBanned(source)) {
            return -1;
        }
        BoogeymanManager bm = this.getBM();
        if (bm == null) {
            return -1;
        }
        if (targets.size() == 1 && !bm.isBoogeyman(target = targets.iterator().next())) {
            source.method_9213(class_2561.method_30163((String)"That player is not a Boogeyman"));
            return -1;
        }
        for (class_3222 player : targets) {
            bm.removeBoogeymanManually(player);
        }
        if (targets.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("{} is no longer a Boogeyman", targets.iterator().next()));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("{} targets are no longer Boogeymen", targets.size()));
        }
        return 1;
    }

    public int boogeyList(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        BoogeymanManager bm = this.getBM();
        if (bm == null) {
            return -1;
        }
        ArrayList<String> allBoogeymen = new ArrayList<String>();
        ArrayList<String> curedBoogeymen = new ArrayList<String>();
        ArrayList<String> failedBoogeymen = new ArrayList<String>();
        for (Boogeyman boogeyman : bm.boogeymen) {
            if (boogeyman.cured) {
                curedBoogeymen.add(boogeyman.name);
                continue;
            }
            if (boogeyman.failed) {
                failedBoogeymen.add(boogeyman.name);
                continue;
            }
            allBoogeymen.add(boogeyman.name);
        }
        if (allBoogeymen.isEmpty()) {
            allBoogeymen.add("\u00a77None");
        }
        if (curedBoogeymen.isEmpty()) {
            curedBoogeymen.add("\u00a77None");
        }
        if (failedBoogeymen.isEmpty()) {
            failedBoogeymen.add("\u00a77None");
        }
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("Remaining Boogeymen: {}", allBoogeymen));
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("Cured Boogeymen: {}", curedBoogeymen));
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("Failed Boogeymen: {}", failedBoogeymen));
        return 1;
    }

    public int boogeyCount(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        BoogeymanManager bm = this.getBM();
        if (bm == null) {
            return -1;
        }
        int allBoogeymen = 0;
        int curedBoogeymen = 0;
        int failedBoogeymen = 0;
        for (Boogeyman boogeyman : bm.boogeymen) {
            if (boogeyman.cured) {
                ++curedBoogeymen;
                continue;
            }
            if (boogeyman.failed) {
                ++failedBoogeymen;
                continue;
            }
            ++allBoogeymen;
        }
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("Remaining Boogeymen: {}", allBoogeymen));
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("Cured Boogeymen: {}", curedBoogeymen));
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("Failed Boogeymen: {}", failedBoogeymen));
        return 1;
    }

    public int boogeyClear(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        BoogeymanManager bm = this.getBM();
        if (bm == null) {
            return -1;
        }
        bm.resetBoogeymen();
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"All Boogeymen have been cleared"));
        return 1;
    }

    public int boogeyChooseRandom(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        BoogeymanManager bm = this.getBM();
        if (bm == null) {
            return -1;
        }
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"\u00a77Choosing random Boogeymen..."));
        bm.resetBoogeymen();
        bm.prepareToChooseBoogeymen();
        return 1;
    }
}

