/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.boogeyman.advanceddeaths;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.boogeyman.advanceddeaths.AdvancedDeath;
import net.mat0u5.lifeseries.seasons.boogeyman.advanceddeaths.AdvancedDeaths;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.limitedlife.LimitedLife;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_3222;

public class AdvancedDeathsManager {
    private static final Random rnd = new Random();
    private static final Map<UUID, PlayerAdvancedDeath> queuedDeaths = new HashMap<UUID, PlayerAdvancedDeath>();

    public static void tick() {
        if (queuedDeaths.isEmpty()) {
            return;
        }
        ArrayList<UUID> toRemove = new ArrayList<UUID>();
        for (Map.Entry<UUID, PlayerAdvancedDeath> entry : queuedDeaths.entrySet()) {
            Integer playerLives;
            UUID uuid = entry.getKey();
            PlayerAdvancedDeath playerAdvancedDeath = entry.getValue();
            class_3222 player = PlayerUtils.getPlayer(uuid);
            Integer n = playerLives = player == null ? null : player.ls$getLives();
            if (player == null || playerAdvancedDeath.queuedDeaths().isEmpty() || playerLives == null || playerLives <= playerAdvancedDeath.lives()) {
                toRemove.add(uuid);
                continue;
            }
            if (playerAdvancedDeath.queuedDeaths().get(0).isFinished() || playerAdvancedDeath.queuedDeaths().get((int)0).started && playerAdvancedDeath.queuedDeaths().get(0).playerNotFound()) {
                playerAdvancedDeath.queuedDeaths().remove(0);
                if (playerAdvancedDeath.queuedDeaths().isEmpty()) {
                    toRemove.add(uuid);
                    continue;
                }
            }
            playerAdvancedDeath.queuedDeaths().get(0).onTick();
        }
        for (UUID uuid : toRemove) {
            PlayerAdvancedDeath playerAdvancedDeath = queuedDeaths.get(uuid);
            Main.livesManager.setScore(playerAdvancedDeath.nameForScoreboard(), playerAdvancedDeath.lives());
            playerAdvancedDeath.queuedDeaths().forEach(AdvancedDeath::onEnd);
            queuedDeaths.remove(uuid);
        }
    }

    public static void setPlayerLives(class_3222 player, int lives) {
        List<AdvancedDeath> queuedPlayerDeaths;
        Integer currentLives = player.ls$getLives();
        if (currentLives == null || currentLives <= lives) {
            player.ls$setLives(lives);
            return;
        }
        int amountOfDeaths = currentLives - lives;
        if (Main.currentSeason.getSeason() == Seasons.LIMITED_LIFE) {
            amountOfDeaths = (int)Math.ceil((double)amountOfDeaths / (double)Math.abs(LimitedLife.NEW_DEATH_NORMAL.getSeconds()));
        }
        if ((queuedPlayerDeaths = AdvancedDeathsManager.getRandomDeaths(player, amountOfDeaths)).isEmpty()) {
            player.ls$setLives(lives);
            return;
        }
        queuedDeaths.put(player.method_5667(), new PlayerAdvancedDeath(player.method_5820(), lives, queuedPlayerDeaths));
    }

    public static void onPlayerDeath(class_3222 player) {
        if (queuedDeaths.isEmpty()) {
            return;
        }
        for (Map.Entry<UUID, PlayerAdvancedDeath> entry : queuedDeaths.entrySet()) {
            UUID uuid = entry.getKey();
            if (uuid != player.method_5667()) continue;
            PlayerAdvancedDeath playerAdvancedDeath = entry.getValue();
            playerAdvancedDeath.queuedDeaths().get(0).onEnd();
            playerAdvancedDeath.queuedDeaths().remove(0);
        }
    }

    public static boolean hasQueuedDeath(class_3222 player) {
        return queuedDeaths.containsKey(player.method_5667());
    }

    public static List<AdvancedDeath> getRandomDeaths(class_3222 player, int deathCount) {
        List<AdvancedDeaths> allDeaths = AdvancedDeaths.getAllDeaths();
        ArrayList<AdvancedDeath> result = new ArrayList<AdvancedDeath>();
        Collections.shuffle(allDeaths);
        AdvancedDeaths lastDeath = null;
        for (int i = 0; i < deathCount; ++i) {
            AdvancedDeath deathInstance;
            AdvancedDeaths death;
            if (i < allDeaths.size()) {
                death = allDeaths.get(i);
            } else {
                List<AdvancedDeaths> newDeaths = AdvancedDeaths.getAllDeaths();
                if (lastDeath != null) {
                    newDeaths.remove((Object)lastDeath);
                }
                death = newDeaths.isEmpty() ? lastDeath : newDeaths.get(rnd.nextInt(newDeaths.size()));
            }
            lastDeath = death;
            if (death == null || (deathInstance = death.getInstance(player)) == null) continue;
            result.add(deathInstance);
        }
        return result;
    }

    public record PlayerAdvancedDeath(String nameForScoreboard, int lives, List<AdvancedDeath> queuedDeaths) {
    }
}

