/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.other;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.season.Season;
import net.mat0u5.lifeseries.seasons.season.doublelife.DoubleLife;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.player.ScoreboardUtils;
import net.mat0u5.lifeseries.utils.player.TeamUtils;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_9011;
import net.minecraft.class_9015;

public class WatcherManager {
    public static final String SCOREBOARD_NAME = "Watchers";
    public static final String TEAM_NAME = "watcher";
    public static final String TEAM_DISPLAY_NAME = "Watcher";
    private static List<String> watchers = new ArrayList<String>();

    public static void createTeams() {
        TeamUtils.createTeam(TEAM_NAME, TEAM_DISPLAY_NAME, class_124.field_1063);
    }

    public static void createScoreboards() {
        ScoreboardUtils.createObjective(SCOREBOARD_NAME);
    }

    public static void reloadWatchers() {
        watchers.clear();
        Collection<class_9011> entries = ScoreboardUtils.getScores(SCOREBOARD_NAME);
        if (entries == null || entries.isEmpty()) {
            return;
        }
        for (class_9011 entry : entries) {
            if (entry.comp_2128() <= 0) continue;
            watchers.add(entry.comp_2127());
        }
    }

    public static void addWatcher(class_3222 player) {
        watchers.add(player.method_5820());
        ScoreboardUtils.setScore((class_9015)player, SCOREBOARD_NAME, (Integer)1);
        Main.livesManager.resetPlayerLife(player);
        player.method_7336(class_1934.field_9219);
        Season season = Main.currentSeason;
        if (season instanceof DoubleLife) {
            DoubleLife doubleLife = (DoubleLife)season;
            doubleLife.resetSoulmate(player);
        }
        player.method_64398(class_2561.method_30163((String)"\u00a77\u00a7nYou are now a Watcher.\n"));
        player.method_64398(class_2561.method_30163((String)"\u00a77Watchers are players that are online, but are not affected by most season mechanics. They can only observe - this is very useful for spectators and for admins."));
    }

    public static void removeWatcher(class_3222 player) {
        watchers.remove(player.method_5820());
        ScoreboardUtils.resetScore((class_9015)player, SCOREBOARD_NAME);
        Main.livesManager.resetPlayerLife(player);
        player.method_64398(class_2561.method_30163((String)"\u00a77You are no longer a Watcher."));
    }

    public static boolean isWatcher(class_1657 player) {
        return watchers.contains(player.method_5820());
    }

    public static boolean isWatcher(String playerName) {
        return watchers.contains(playerName);
    }

    public static List<String> getWatchers() {
        return watchers;
    }

    public static List<class_3222> getWatcherPlayers() {
        List<class_3222> watcherPlayers = PlayerUtils.getAllPlayers();
        watcherPlayers.removeIf(player -> !WatcherManager.isWatcher((class_1657)player));
        return watcherPlayers;
    }
}

