/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.command.manager.Command;
import net.mat0u5.lifeseries.command.manager.CommandManager;
import net.mat0u5.lifeseries.config.ConfigManager;
import net.mat0u5.lifeseries.entity.snail.Snail;
import net.mat0u5.lifeseries.entity.triviabot.TriviaBot;
import net.mat0u5.lifeseries.events.Events;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.seasons.blacklist.Blacklist;
import net.mat0u5.lifeseries.seasons.boogeyman.BoogeymanManager;
import net.mat0u5.lifeseries.seasons.other.LivesManager;
import net.mat0u5.lifeseries.seasons.other.WatcherManager;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.doublelife.DoubleLife;
import net.mat0u5.lifeseries.seasons.season.limitedlife.LimitedLife;
import net.mat0u5.lifeseries.seasons.secretsociety.SecretSociety;
import net.mat0u5.lifeseries.seasons.session.Session;
import net.mat0u5.lifeseries.seasons.session.SessionStatus;
import net.mat0u5.lifeseries.seasons.session.SessionTranscript;
import net.mat0u5.lifeseries.seasons.subin.SubInManager;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.other.Time;
import net.mat0u5.lifeseries.utils.player.AttributeUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.player.ScoreboardUtils;
import net.mat0u5.lifeseries.utils.player.TeamUtils;
import net.mat0u5.lifeseries.utils.world.DatapackIntegration;
import net.mat0u5.lifeseries.utils.world.LevelUtils;
import net.minecraft.class_12279;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1510;
import net.minecraft.class_1528;
import net.minecraft.class_1550;
import net.minecraft.class_1639;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1826;
import net.minecraft.class_1928;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_268;
import net.minecraft.class_274;
import net.minecraft.class_2789;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3966;
import net.minecraft.class_7260;
import net.minecraft.class_8111;
import net.minecraft.class_8646;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public abstract class Season {
    public static final String RESOURCEPACK_MAIN_URL = "https://github.com/Mat0u5/LifeSeries-Resources/releases/download/release-main-27d9e98eb6009401319a5256f7695f1bba902412/main.zip";
    public static final String RESOURCEPACK_MAIN_SHA = "6b3b1e6225156de119926dd32003060b42dbab82";
    public static final String RESOURCEPACK_SECRETLIFE_URL = "https://github.com/Mat0u5/LifeSeries-Resources/releases/download/release-secretlife-fc0fa2a3efe2aefdba5a3c0deda61039fc43a008/secretlife.zip";
    public static final String RESOURCEPACK_SECRETLIFE_SHA = "1befd668fa775f2b8715b348172e1ba776e57294";
    public static final String RESOURCEPACK_MINIMAL_ARMOR_URL = "https://github.com/Mat0u5/LifeSeries-Resources/releases/download/release-minimal_armor-27d9e98eb6009401319a5256f7695f1bba902412/minimal_armor.zip";
    public static final String RESOURCEPACK_MINIMAL_ARMOR_SHA = "e078d9085ea74891ebc4f8ec5686c4da08176a38";
    public static final String RESOURCEPACK_COMBINED_URL = "https://github.com/Mat0u5/LifeSeries-Resources/releases/download/release-combined-27d9e98eb6009401319a5256f7695f1bba902412/combined.zip";
    public static final String RESOURCEPACK_COMBINED_SHA = "d9ef5b0c1074c006820494ca0524de8f8810a77c";
    public int GIVELIFE_MAX_LIVES = 99;
    public boolean TAB_LIST_SHOW_DEAD_PLAYERS = true;
    public boolean TAB_LIST_SHOW_LIVES = false;
    public static boolean TAB_LIST_SHOW_EXACT_LIVES = false;
    public static boolean SHOW_HEALTH_BELOW_NAME = false;
    public boolean WATCHERS_IN_TAB = true;
    public boolean MUTE_DEAD_PLAYERS = false;
    public boolean WATCHERS_MUTED = false;
    public boolean ALLOW_SELF_DEFENSE = true;
    public static boolean GIVELIFE_CAN_REVIVE = false;
    public boolean SHOW_LOGIN_COMMAND_INFO = true;
    public boolean HIDE_UNJUSTIFIED_KILL_MESSAGES = false;
    public static boolean reloadPlayerTeams = false;
    private static boolean BROADCAST_LIFE_GAIN = false;
    private double ADDITIONAL_WITHER_SKULL_RATE = 0.05;
    public static Random rnd = new Random();
    public static class_243 skyColor = null;
    public static boolean skyColorSetMode = false;
    public static class_243 fogColor = null;
    public static boolean fogColorSetMode = false;
    public static class_243 cloudColor = null;
    public static boolean cloudColorSetMode = false;
    public BoogeymanManager boogeymanManager = this.createBoogeymanManager();
    public SecretSociety secretSociety = this.createSecretSociety();
    public LivesManager livesManager = this.createLivesManager();
    private Time timer = Time.zero();
    public final Map<UUID, HashMap<class_243, List<Float>>> respawnPositions = new HashMap<UUID, HashMap<class_243, List<Float>>>();

    public abstract Seasons getSeason();

    public abstract ConfigManager createConfig();

    public Blacklist createBlacklist() {
        return new Blacklist();
    }

    public BoogeymanManager createBoogeymanManager() {
        return new BoogeymanManager();
    }

    public SecretSociety createSecretSociety() {
        return new SecretSociety();
    }

    public LivesManager createLivesManager() {
        return new LivesManager();
    }

    public Integer getDefaultLives() {
        return (Integer)Main.seasonConfig.DEFAULT_LIVES.get(Main.seasonConfig);
    }

    public void initialize() {
        this.reload();
    }

    public void seasonSwitched(Seasons changedTo) {
    }

    public void reloadStart() {
    }

    public void updateStuff() {
        if (Main.server == null) {
            return;
        }
        class_3218 overworld = Main.server.method_3847(class_1937.field_25179);
        if (overworld != null && overworld.method_8621().method_11968() == class_2789.field_12753) {
            overworld.method_8621().method_11969((double)((Integer)Main.seasonConfig.WORLDBORDER_SIZE.get(Main.seasonConfig)).intValue());
        }
        class_3218 nether = Main.server.method_3847(class_1937.field_25180);
        class_3218 end = Main.server.method_3847(class_1937.field_25181);
        if (nether != null && nether.method_8621().method_11968() == class_2789.field_12753) {
            nether.method_8621().method_11969((double)((Integer)Main.seasonConfig.WORLDBORDER_NETHER_SIZE.get(Main.seasonConfig)).intValue());
        }
        if (end != null && end.method_8621().method_11968() == class_2789.field_12753) {
            end.method_8621().method_11969((double)((Integer)Main.seasonConfig.WORLDBORDER_END_SIZE.get(Main.seasonConfig)).intValue());
        }
        if (overworld != null) {
            OtherUtils.setBooleanGameRule(overworld, (class_12279<Boolean>)class_1928.field_19389, (Boolean)Main.seasonConfig.KEEP_INVENTORY.get(Main.seasonConfig));
            OtherUtils.setBooleanGameRule(overworld, (class_12279<Boolean>)class_1928.field_19409, (Boolean)Main.seasonConfig.SHOW_ADVANCEMENTS.get(Main.seasonConfig));
            OtherUtils.setBooleanGameRule(overworld, (class_12279<Boolean>)class_1928.field_19395, this.getSeason() != Seasons.SECRET_LIFE);
            boolean locatorBarEnabled = (Boolean)Main.seasonConfig.LOCATOR_BAR.get(Main.seasonConfig);
            if (!locatorBarEnabled && this instanceof DoubleLife) {
                locatorBarEnabled = DoubleLife.SOULMATE_LOCATOR_BAR;
            }
            OtherUtils.setBooleanGameRule(overworld, (class_12279<Boolean>)class_1928.field_59751, locatorBarEnabled);
        }
        class_8646 listSlot = class_8646.field_45156;
        class_8646 belowNameSlot = class_8646.field_45158;
        class_266 currentListObjective = ScoreboardUtils.getObjectiveInSlot(listSlot);
        if (this.TAB_LIST_SHOW_LIVES) {
            ScoreboardUtils.setObjectiveInSlot(listSlot, "Lives");
        } else if (currentListObjective != null && currentListObjective.method_1113().equals("Lives")) {
            ScoreboardUtils.setObjectiveInSlot(listSlot, null);
        }
        class_266 currentBelowNameObjective = ScoreboardUtils.getObjectiveInSlot(belowNameSlot);
        if (this.getSeason() == Seasons.LIMITED_LIFE && LimitedLife.SHOW_TIME_BELOW_NAME) {
            ScoreboardUtils.setObjectiveInSlot(belowNameSlot, "Lives");
        } else if (SHOW_HEALTH_BELOW_NAME) {
            ScoreboardUtils.setObjectiveInSlot(belowNameSlot, "HP");
        } else if (currentBelowNameObjective != null) {
            if (currentBelowNameObjective.method_1113().equals("HP")) {
                ScoreboardUtils.setObjectiveInSlot(belowNameSlot, null);
            }
            if (currentBelowNameObjective.method_1113().equals("Lives")) {
                ScoreboardUtils.setObjectiveInSlot(belowNameSlot, null);
            }
        }
        if (this.getSeason() != Seasons.SIMPLE_LIFE) {
            OtherUtils.executeCommand("/kill @e[type=wandering_trader,tag=SimpleLifeTrader]");
        }
    }

    public void reload() {
        this.MUTE_DEAD_PLAYERS = (Boolean)Main.seasonConfig.MUTE_DEAD_PLAYERS.get(Main.seasonConfig);
        this.GIVELIFE_MAX_LIVES = (Integer)Main.seasonConfig.GIVELIFE_LIVES_MAX.get(Main.seasonConfig);
        this.TAB_LIST_SHOW_LIVES = (Boolean)Main.seasonConfig.TAB_LIST_SHOW_LIVES.get(Main.seasonConfig);
        this.TAB_LIST_SHOW_DEAD_PLAYERS = (Boolean)Main.seasonConfig.TAB_LIST_SHOW_DEAD_PLAYERS.get(Main.seasonConfig);
        TAB_LIST_SHOW_EXACT_LIVES = (Boolean)Main.seasonConfig.TAB_LIST_SHOW_EXACT_LIVES.get(Main.seasonConfig);
        SHOW_HEALTH_BELOW_NAME = (Boolean)Main.seasonConfig.SHOW_HEALTH_BELOW_NAME.get(Main.seasonConfig);
        this.WATCHERS_IN_TAB = (Boolean)Main.seasonConfig.WATCHERS_IN_TAB.get(Main.seasonConfig);
        this.WATCHERS_MUTED = (Boolean)Main.seasonConfig.WATCHERS_MUTED.get(Main.seasonConfig);
        this.ALLOW_SELF_DEFENSE = (Boolean)Main.seasonConfig.ALLOW_SELF_DEFENSE.get(Main.seasonConfig);
        GIVELIFE_CAN_REVIVE = (Boolean)Main.seasonConfig.GIVELIFE_CAN_REVIVE.get(Main.seasonConfig);
        this.SHOW_LOGIN_COMMAND_INFO = (Boolean)Main.seasonConfig.SHOW_LOGIN_COMMAND_INFO.get(Main.seasonConfig);
        this.HIDE_UNJUSTIFIED_KILL_MESSAGES = (Boolean)Main.seasonConfig.HIDE_UNJUSTIFIED_KILL_MESSAGES.get(Main.seasonConfig);
        Session.TICK_FREEZE_NOT_IN_SESSION = (Boolean)Main.seasonConfig.TICK_FREEZE_NOT_IN_SESSION.get(Main.seasonConfig);
        BROADCAST_LIFE_GAIN = (Boolean)Main.seasonConfig.BROADCAST_LIFE_GAIN.get(Main.seasonConfig);
        this.ADDITIONAL_WITHER_SKULL_RATE = (Double)Main.seasonConfig.ADDITIONAL_WITHER_SKULL_RATE.get(Main.seasonConfig);
        this.boogeymanManager.onReload();
        this.secretSociety.onReload();
        this.createTeams();
        this.createScoreboards();
        this.updateStuff();
        this.reloadAllPlayerTeams();
        this.reloadPlayers();
        Events.updatePlayerListsNextTick = true;
        WatcherManager.reloadWatchers();
        this.livesManager.reload();
        Main.currentSession.freezeIfNecessary();
        DatapackIntegration.reload();
        PlayerUtils.resendCommandTrees();
    }

    public static void setSkyColor(class_243 color, boolean setMode) {
        skyColor = color;
        skyColorSetMode = setMode;
        NetworkHandlerServer.sendUpdatePackets();
    }

    public static void setFogColor(class_243 color, boolean setMode) {
        fogColor = color;
        fogColorSetMode = setMode;
        NetworkHandlerServer.sendUpdatePackets();
    }

    public static void setCloudColor(class_243 color, boolean setMode) {
        cloudColor = color;
        cloudColorSetMode = setMode;
        NetworkHandlerServer.sendUpdatePackets();
    }

    public String getAdminCommands() {
        ArrayList<CallSite> allCommands = new ArrayList<CallSite>();
        for (Command command : CommandManager.commands) {
            if (!command.isAllowed()) continue;
            for (String commandStr : command.getAdminCommands()) {
                allCommands.add((CallSite)((Object)("/" + commandStr)));
            }
        }
        return String.join((CharSequence)", ", allCommands);
    }

    public String getNonAdminCommands() {
        ArrayList<CallSite> allCommands = new ArrayList<CallSite>();
        for (Command command : CommandManager.commands) {
            if (!command.isAllowed()) continue;
            for (String commandStr : command.getNonAdminCommands()) {
                allCommands.add((CallSite)((Object)("/" + commandStr)));
            }
        }
        return String.join((CharSequence)", ", allCommands);
    }

    public void sendSetSeasonPacket(class_3222 player) {
        NetworkHandlerServer.sendStringListPacket(player, PacketNames.SEASON_INFO, List.of(Main.currentSeason.getSeason().getId(), Main.currentSeason.getAdminCommands(), Main.currentSeason.getNonAdminCommands()));
    }

    public void reloadPlayers() {
        PlayerUtils.getAllPlayers().forEach(AttributeUtils::resetAttributesOnPlayerJoin);
    }

    public void createTeams() {
        Collection<class_268> allTeams = TeamUtils.getAllTeams();
        if (allTeams != null) {
            for (class_268 team : allTeams) {
                if (!team.method_1197().startsWith("creaking_")) continue;
                TeamUtils.deleteTeam(team.method_1197());
            }
        }
        WatcherManager.createTeams();
        this.livesManager.createTeams();
    }

    public void createScoreboards() {
        ScoreboardUtils.createObjective("HP", "\u00a7c\u2764", class_274.field_1453);
        WatcherManager.createScoreboards();
        this.livesManager.createScoreboards();
        DatapackIntegration.createScoreboards();
    }

    public void reloadAllPlayerTeams() {
        PlayerUtils.getAllPlayers().forEach(this::reloadPlayerTeam);
    }

    public void reloadPlayerTeam(class_3222 player) {
        this.reloadPlayerTeam(player, false);
    }

    private void reloadPlayerTeam(class_3222 player, boolean waited) {
        if (player == null) {
            return;
        }
        if (!player.method_5805() && !waited) {
            TaskScheduler.scheduleTask(1, () -> this.reloadPlayerTeam(player, true));
            return;
        }
        String team = this.getTeamForPlayer(player);
        class_268 currentTeam = player.method_5781();
        if (!(team == null || currentTeam != null && currentTeam.method_1197().equals(team))) {
            TeamUtils.addEntityToTeam(team, (class_1297)player);
            this.playerChangedTeam(player);
        }
    }

    public void playerChangedTeam(class_3222 player) {
        Events.updatePlayerListsNextTick = true;
    }

    public String getTeamForPlayer(class_3222 player) {
        if (WatcherManager.isWatcher((class_1657)player)) {
            return "watcher";
        }
        return this.livesManager.getTeamForPlayer(player);
    }

    public void dropItemsOnLastDeath(class_3222 player) {
        boolean doDrop = (Boolean)Main.seasonConfig.PLAYERS_DROP_ITEMS_ON_FINAL_DEATH.get(Main.seasonConfig);
        boolean keepInventory = OtherUtils.getBooleanGameRule(player.ls$getServerLevel(), class_1928.field_19389);
        if (doDrop && keepInventory) {
            for (class_1799 item : PlayerUtils.getPlayerInventory(player)) {
                player.method_5775(player.ls$getServerLevel(), item);
            }
            player.method_31548().method_5448();
        }
    }

    public boolean isAllowedToAttack(class_3222 attacker, class_3222 victim) {
        return this.isAllowedToAttack(attacker, victim, this.ALLOW_SELF_DEFENSE);
    }

    public boolean isAllowedToAttack(class_3222 attacker, class_3222 victim, boolean allowSelfDefense) {
        Integer canKillLives;
        if (attacker.ls$isOnLastLife(false)) {
            return true;
        }
        if (this.boogeymanManager.isBoogeymanThatCanBeCured(attacker, victim)) {
            return true;
        }
        if (allowSelfDefense && attacker.method_6124() == victim && this.isAllowedToAttack(victim, attacker, false)) {
            return true;
        }
        class_268 team = attacker.method_5781();
        return team != null && (canKillLives = this.livesManager.getTeamCanKill(team.method_1197())) != null && victim.ls$isOnAtLeastLives(canKillLives.intValue(), false);
    }

    public void sessionEnd() {
        this.boogeymanManager.sessionEnd();
        this.secretSociety.sessionEnd();
    }

    public boolean sessionStart() {
        this.boogeymanManager.resetBoogeymen();
        this.secretSociety.resetMembers();
        this.addSessionActions();
        return true;
    }

    public void sessionChangeStatus(SessionStatus newStatus) {
    }

    public void tick(MinecraftServer server) {
        this.timer.tick();
        this.boogeymanManager.tick();
        this.secretSociety.tick();
        if (this.timer.isMultipleOf(Time.seconds(5)) || reloadPlayerTeams) {
            reloadPlayerTeams = false;
            this.reloadAllPlayerTeams();
        }
    }

    public void tickSessionOn(MinecraftServer server) {
    }

    public void addSessionActions() {
        this.boogeymanManager.addSessionActions();
        this.secretSociety.addSessionActions();
    }

    public void onPlayerDeath(class_3222 player, class_1282 source) {
        boolean soulmateKill = source.method_49708(DoubleLife.SOULMATE_DAMAGE);
        SessionTranscript.onPlayerDeath(player, source);
        boolean killedByPlayer = false;
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_3222) {
            class_3222 serverAttacker = (class_3222)class_12972;
            if (player != source.method_5529() && !soulmateKill) {
                this.onPlayerKilledByPlayer(player, serverAttacker);
                killedByPlayer = true;
            }
        }
        if (player.method_6124() != null && !killedByPlayer && (class_12972 = player.method_6124()) instanceof class_3222) {
            class_3222 serverAdversary = (class_3222)class_12972;
            if (player != player.method_6124() && !soulmateKill) {
                this.onPlayerKilledByPlayer(player, serverAdversary);
                killedByPlayer = true;
            }
        }
        if (!killedByPlayer) {
            this.onPlayerDiedNaturally(player, source);
        }
        DatapackIntegration.EVENT_PLAYER_DEATH.trigger(new DatapackIntegration.Events.MacroEntry("Player", player.method_5820()));
        if (!DatapackIntegration.EVENT_PLAYER_DEATH.isCanceled() && this.livesManager.canChangeLivesNaturally(player) && player.ls$hasAssignedLives()) {
            player.ls$removeLife();
        }
    }

    public void onPlayerDiedNaturally(class_3222 player, class_1282 source) {
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1321) {
            class_1321 tamableAnimal = (class_1321)class_12972;
            class_3222 owner = null;
            if (tamableAnimal.method_66287() != null) {
                owner = PlayerUtils.getPlayer(tamableAnimal.method_66287().method_66263());
            }
            if (owner != null) {
                owner.method_5716((class_1297)player, source);
            }
        }
        if (Main.server == null) {
            return;
        }
        Main.currentSession.playerNaturalDeathLog.remove(player.method_5667());
        Main.currentSession.playerNaturalDeathLog.put(player.method_5667(), Main.server.method_3780());
    }

    public void onPlayerRespawn(class_3222 player) {
        if (!this.respawnPositions.containsKey(player.method_5667())) {
            return;
        }
        HashMap<class_243, List<Float>> info = this.respawnPositions.get(player.method_5667());
        this.respawnPositions.remove(player.method_5667());
        if (player.ls$isAlive()) {
            return;
        }
        for (Map.Entry<class_243, List<Float>> entry : info.entrySet()) {
            class_243 pos = entry.getKey();
            int minY = player.ls$getServerLevel().method_31607();
            if (pos.field_1351 <= (double)minY) continue;
            LevelUtils.teleport((class_1297)player, player.ls$getServerLevel(), pos, entry.getValue().get(0).floatValue(), entry.getValue().get(1).floatValue());
            break;
        }
    }

    public void onClaimKill(class_3222 killer, class_3222 victim) {
        SessionTranscript.claimKill(killer, victim);
        boolean isBoogeyCure = this.boogeymanManager.isBoogeymanThatCanBeCured(killer, victim);
        if (isBoogeyCure) {
            this.boogeymanManager.onBoogeymanKill(killer, victim);
        }
        DatapackIntegration.EVENT_CLAIM_KILL.trigger(List.of(new DatapackIntegration.Events.MacroEntry("Killer", killer.method_5820()), new DatapackIntegration.Events.MacroEntry("Victim", victim.method_5820())));
        if (!DatapackIntegration.EVENT_CLAIM_KILL.isCanceled() && !isBoogeyCure) {
            this.tryClaimKillLifeGain(killer, victim);
        }
        killer.method_5716((class_1297)victim, killer.method_48923().method_48802((class_1657)killer));
    }

    public void tryClaimKillLifeGain(class_3222 killer, class_3222 victim) {
        class_268 team = killer.method_5781();
        if (team != null) {
            Integer canGainLife = this.livesManager.getTeamGainLives(team.method_1197());
            Integer victimLives = victim.ls$getLives();
            if (canGainLife != null && victimLives != null && victimLives > 0 && victimLives + 1 >= canGainLife) {
                this.broadcastLifeGain(killer, victim);
                killer.ls$addLife();
            }
        }
    }

    public void tryKillLifeGain(class_3222 killer, class_3222 victim) {
        Integer canGainLife;
        class_268 team = killer.method_5781();
        if (team != null && (canGainLife = this.livesManager.getTeamGainLives(team.method_1197())) != null && victim.ls$isOnAtLeastLives(canGainLife.intValue(), false)) {
            this.broadcastLifeGain(killer, victim);
            killer.ls$addLife();
        }
    }

    public void broadcastLifeGain(class_3222 player, class_3222 victim) {
        if (BROADCAST_LIFE_GAIN) {
            PlayerUtils.broadcastMessage((class_2561)TextUtils.format("{}\u00a77 gained a life for killing {}.", player, victim));
        }
    }

    public void onPlayerDamage(class_3222 player, class_1282 source, float amount, CallbackInfo ci) {
        DatapackIntegration.EVENT_PLAYER_TAKE_DAMAGE.trigger(List.of(new DatapackIntegration.Events.MacroEntry("Player", player.method_5820()), new DatapackIntegration.Events.MacroEntry("Amount", String.valueOf(amount))));
    }

    public void onPrePlayerDamage(class_3222 player, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (source.method_49708(class_8111.field_44868)) {
            cir.setReturnValue((Object)false);
        }
    }

    public void onPlayerHeal(class_3222 player, float amount) {
    }

    public void onPlayerKilledByPlayer(class_3222 victim, class_3222 killer) {
        boolean isAllowedToAttack = this.isAllowedToAttack(killer, victim, false);
        boolean isBoogeyCure = this.boogeymanManager.isBoogeymanThatCanBeCured(killer, victim);
        if (!this.isAllowedToAttack(killer, victim) && !this.HIDE_UNJUSTIFIED_KILL_MESSAGES) {
            PlayerUtils.broadcastMessageToAdmins((class_2561)TextUtils.format("\u00a7c [Unjustified Kill?] {}\u00a77 was killed by {}", victim, killer));
        }
        if (isBoogeyCure) {
            this.boogeymanManager.onBoogeymanKill(killer, victim);
        }
        SessionTranscript.onPlayerKilledByPlayer(victim, killer);
        DatapackIntegration.EVENT_PLAYER_PVP_KILLED.trigger(List.of(new DatapackIntegration.Events.MacroEntry("Killer", killer.method_5820()), new DatapackIntegration.Events.MacroEntry("Victim", victim.method_5820())));
        if (!DatapackIntegration.EVENT_PLAYER_PVP_KILLED.isCanceled() && !isBoogeyCure && isAllowedToAttack) {
            this.tryKillLifeGain(killer, victim);
        }
    }

    public void onMobDeath(class_1309 entity, class_1282 damageSource) {
    }

    public void onEntityDropItems(class_1309 entity, class_1282 damageSource, CallbackInfo ci) {
        this.modifyEntityDrops(entity, damageSource, ci);
    }

    public void modifyEntityDrops(class_1309 entity, class_1282 damageSource, CallbackInfo ci) {
        if (!entity.method_73183().method_8608() && damageSource.method_5529() instanceof class_3222) {
            this.spawnEggChance(entity);
            if (entity instanceof class_1639 && rnd.nextDouble() <= this.ADDITIONAL_WITHER_SKULL_RATE) {
                class_1799 skullItem = class_1802.field_8791.method_7854();
                entity.method_5775((class_3218)entity.method_73183(), skullItem);
                ci.cancel();
            }
        }
    }

    private void spawnEggChance(class_1309 entity) {
        double chance = (Double)Main.seasonConfig.SPAWN_EGG_DROP_CHANCE.get(Main.seasonConfig);
        boolean onlyNatural = (Boolean)Main.seasonConfig.SPAWN_EGG_DROP_ONLY_NATURAL.get(Main.seasonConfig);
        if (chance <= 0.0) {
            return;
        }
        if (entity instanceof class_1510) {
            return;
        }
        if (entity instanceof class_1528) {
            return;
        }
        if (entity instanceof class_7260) {
            return;
        }
        if (entity instanceof class_1550) {
            return;
        }
        if (entity instanceof Snail) {
            return;
        }
        if (entity instanceof TriviaBot) {
            return;
        }
        if (entity.method_5752().contains("notNatural") && onlyNatural) {
            return;
        }
        class_1299 entityType = entity.method_5864();
        class_1826 spawnEgg = class_1826.method_8019((class_1299)entityType);
        if (spawnEgg == null) {
            return;
        }
        class_1799 spawnEggItem = spawnEgg.method_7854();
        if (spawnEggItem == null) {
            return;
        }
        if (spawnEggItem.method_7960()) {
            return;
        }
        if (Math.random() <= chance) {
            entity.method_5775((class_3218)entity.method_73183(), spawnEggItem);
        }
    }

    public void learnRecipes() {
        OtherUtils.executeCommand("recipe give @a lifeseries:name_tag_recipe");
        OtherUtils.executeCommand("recipe give @a lifeseries:saddle_recipe");
        OtherUtils.executeCommand("recipe give @a lifeseries:spawner_recipe");
        OtherUtils.executeCommand("recipe give @a lifeseries:tnt_recipe_variation");
        OtherUtils.executeCommand("recipe give @a lifeseries:bundle_recipe");
    }

    public void onPlayerJoin(class_3222 player) {
        Season season;
        AttributeUtils.resetAttributesOnPlayerJoin(player);
        this.reloadPlayerTeam(player);
        TaskScheduler.scheduleTask(2, () -> PlayerUtils.applyResourcepack(player.method_5667()));
        if (!player.ls$hasAssignedLives()) {
            this.assignDefaultLives(player);
        }
        if (player.ls$hasAssignedLives() && player.ls$isDead() && !PermissionManager.isAdmin(player)) {
            player.method_7336(class_1934.field_9219);
        }
        if (player.ls$isWatcher() && (season = this) instanceof DoubleLife) {
            DoubleLife doubleLife = (DoubleLife)season;
            doubleLife.resetSoulmate(player);
        }
        TaskScheduler.scheduleTask(1, () -> {
            if (SubInManager.isBeingSubstituted(player.method_5667())) {
                SubInManager.removeSubIn(player);
            }
        });
    }

    public void assignDefaultLives(class_3222 player) {
        Integer lives = this.getDefaultLives();
        if (lives != null) {
            player.ls$setLives(lives.intValue());
        }
    }

    public void onPlayerFinishJoining(class_3222 player) {
        if (this.getSeason() != Seasons.UNASSIGNED && this.SHOW_LOGIN_COMMAND_INFO && !Main.modDisabled()) {
            if (PermissionManager.isAdmin(player)) {
                player.method_64398((class_2561)TextUtils.formatLoosely("\u00a77{} commands: \u00a7r{}", this.getSeason().getName(), this.getAdminCommands()));
            } else {
                player.method_64398((class_2561)TextUtils.formatLoosely("\u00a77{} non-admin commands: \u00a7r{}", this.getSeason().getName(), this.getNonAdminCommands()));
            }
        }
        this.learnRecipes();
        if (Main.currentSession.statusNotStarted() && PermissionManager.isAdmin(player) && !Main.modDisabled()) {
            player.method_64398(class_2561.method_30163((String)"\nUse \u00a7b'/session timer set <time>'\u00a7f to set the desired session time."));
            player.method_64398(class_2561.method_30163((String)"After that, use \u00a7b'/session start'\u00a7f to start the session."));
        }
        this.boogeymanManager.onPlayerFinishJoining(player);
    }

    public void onPlayerDisconnect(class_3222 player) {
    }

    public void onRightClickEntity(class_3222 player, class_1937 level, class_1268 hand, class_1297 entity, class_3966 hitResult) {
    }

    public void onAttackEntity(class_3222 player, class_1937 level, class_1268 hand, class_1297 entity, class_3966 hitResult) {
    }

    public void onUpdatedInventory(class_3222 player) {
        if (Main.blacklist != null) {
            Main.blacklist.onInventoryUpdated(player);
        }
    }
}

