/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.lastlife;

import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.config.ConfigManager;
import net.mat0u5.lifeseries.seasons.other.LivesManager;
import net.mat0u5.lifeseries.seasons.season.Season;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.lastlife.LastLifeConfig;
import net.mat0u5.lifeseries.seasons.season.lastlife.LastLifeLivesManager;
import net.minecraft.class_3222;

public class LastLife
extends Season {
    public static int ROLL_MAX_LIVES = 6;
    public static int ROLL_MIN_LIVES = 2;

    @Override
    public Seasons getSeason() {
        return Seasons.LAST_LIFE;
    }

    @Override
    public ConfigManager createConfig() {
        return new LastLifeConfig();
    }

    @Override
    public LivesManager createLivesManager() {
        return new LastLifeLivesManager();
    }

    @Override
    public void addSessionActions() {
        super.addSessionActions();
        LivesManager livesManager = this.livesManager;
        if (livesManager instanceof LastLifeLivesManager) {
            LastLifeLivesManager lastLifeLivesManager = (LastLifeLivesManager)livesManager;
            Main.currentSession.addSessionAction(lastLifeLivesManager.actionChooseLives);
        }
    }

    @Override
    public void reload() {
        super.reload();
        ConfigManager configManager = Main.seasonConfig;
        if (!(configManager instanceof LastLifeConfig)) {
            return;
        }
        LastLifeConfig config = (LastLifeConfig)configManager;
        int minLivesConfig = LastLifeConfig.RANDOM_LIVES_MIN.get(config);
        int maxLivesConfig = LastLifeConfig.RANDOM_LIVES_MAX.get(config);
        ROLL_MIN_LIVES = Math.min(minLivesConfig, maxLivesConfig);
        ROLL_MAX_LIVES = Math.max(minLivesConfig, maxLivesConfig);
    }

    @Override
    public Integer getDefaultLives() {
        return null;
    }

    @Override
    public boolean sessionStart() {
        LivesManager livesManager = this.livesManager;
        if (livesManager instanceof LastLifeLivesManager) {
            LastLifeLivesManager lastLifeLivesManager = (LastLifeLivesManager)livesManager;
            lastLifeLivesManager.reset();
        }
        return super.sessionStart();
    }

    @Override
    public void sessionEnd() {
        super.sessionEnd();
        LivesManager livesManager = this.livesManager;
        if (livesManager instanceof LastLifeLivesManager) {
            LastLifeLivesManager lastLifeLivesManager = (LastLifeLivesManager)livesManager;
            lastLifeLivesManager.reset();
        }
    }

    @Override
    public void onPlayerFinishJoining(class_3222 player) {
        super.onPlayerFinishJoining(player);
        LivesManager livesManager = this.livesManager;
        if (livesManager instanceof LastLifeLivesManager) {
            LastLifeLivesManager lastLifeLivesManager = (LastLifeLivesManager)livesManager;
            lastLifeLivesManager.onPlayerFinishJoining(player);
        }
    }
}

