/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.lastlife;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.other.LivesManager;
import net.mat0u5.lifeseries.seasons.season.lastlife.LastLife;
import net.mat0u5.lifeseries.seasons.session.SessionAction;
import net.mat0u5.lifeseries.seasons.session.SessionTranscript;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.other.Time;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5250;

public class LastLifeLivesManager
extends LivesManager {
    public boolean assignedLives = false;
    public SessionAction actionChooseLives = new SessionAction(Time.minutes(1), "Assign lives if necessary"){

        @Override
        public void trigger() {
            LastLifeLivesManager.this.assignRandomLivesToUnassignedPlayers();
        }
    };
    Random rnd = new Random();

    public void assignRandomLivesToUnassignedPlayers() {
        this.assignedLives = true;
        ArrayList<class_3222> assignTo = new ArrayList<class_3222>();
        for (class_3222 player : PlayerUtils.getAllFunctioningPlayers()) {
            if (player.ls$hasAssignedLives()) continue;
            assignTo.add(player);
        }
        if (assignTo.isEmpty()) {
            return;
        }
        this.assignRandomLives(assignTo);
    }

    public void assignRandomLives(List<class_3222> players) {
        players.forEach(this::resetPlayerLife);
        PlayerUtils.sendTitleToPlayers(players, (class_2561)class_2561.method_43470((String)"You will have...").method_27692(class_124.field_1080), 10, 40, 10);
        TaskScheduler.scheduleTask(Time.seconds(3), () -> this.rollLives(players));
    }

    public void rollLives(List<class_3222> players) {
        int delay = this.showRandomNumbers(players) + 20;
        HashMap<class_3222, Integer> lives = new HashMap<class_3222, Integer>();
        int totalSize = players.size();
        int chosenNotRandomly = LastLife.ROLL_MIN_LIVES;
        for (class_3222 player : players) {
            int diff = LastLife.ROLL_MAX_LIVES - LastLife.ROLL_MIN_LIVES + 2;
            if (chosenNotRandomly <= LastLife.ROLL_MAX_LIVES && totalSize > diff) {
                lives.put(player, chosenNotRandomly);
                ++chosenNotRandomly;
                continue;
            }
            int randomLives = this.getRandomLife();
            lives.put(player, randomLives);
        }
        TaskScheduler.scheduleTask(delay, () -> {
            for (Map.Entry playerEntry : lives.entrySet()) {
                Integer livesNum = (Integer)playerEntry.getValue();
                class_3222 player = (class_3222)playerEntry.getKey();
                class_2561 textLives = this.getFormattedLives(livesNum);
                PlayerUtils.sendTitle(player, textLives, 0, 25, 0);
            }
            PlayerUtils.playSoundToPlayers(players, (class_3414)class_3417.field_15015.comp_349());
        });
        TaskScheduler.scheduleTask(delay += 20, () -> {
            for (Map.Entry playerEntry : lives.entrySet()) {
                Integer livesNum = (Integer)playerEntry.getValue();
                class_3222 player = (class_3222)playerEntry.getKey();
                class_5250 textLives = TextUtils.format("{}\u00a7a {}.", this.getFormattedLives(livesNum), TextUtils.pluralize("life", "lives", livesNum));
                PlayerUtils.sendTitle(player, (class_2561)textLives, 0, 60, 20);
                SessionTranscript.assignRandomLives(player, livesNum);
                this.setPlayerLives(player, livesNum);
            }
            PlayerUtils.playSoundToPlayers(lives.keySet(), class_3417.field_14981);
            Main.currentSeason.reloadAllPlayerTeams();
        });
    }

    public int showRandomNumbers(List<class_3222> players) {
        int currentDelay = 0;
        int lastLives = -1;
        for (int i = 0; i < 80; ++i) {
            int lives;
            currentDelay = i >= 75 ? (currentDelay += 20) : (i >= 65 ? (currentDelay += 8) : (i >= 50 ? (currentDelay += 4) : (i >= 30 ? (currentDelay += 2) : ++currentDelay)));
            lastLives = lives = this.getRandomLife(lastLives);
            TaskScheduler.scheduleTask(currentDelay, () -> {
                PlayerUtils.sendTitleToPlayers(players, this.getFormattedLives(lives), 0, 25, 0);
                PlayerUtils.playSoundToPlayers(players, (class_3414)class_3417.field_15015.comp_349());
            });
        }
        return currentDelay;
    }

    public int getRandomLife() {
        int minLives = LastLife.ROLL_MIN_LIVES;
        int maxLives = LastLife.ROLL_MAX_LIVES;
        return this.rnd.nextInt(minLives, maxLives + 1);
    }

    public boolean onlyOnePossibleLife() {
        return LastLife.ROLL_MIN_LIVES == LastLife.ROLL_MAX_LIVES;
    }

    public int getRandomLife(int except) {
        if (!this.onlyOnePossibleLife()) {
            for (int tries = 0; tries < 100; ++tries) {
                int lives = this.getRandomLife();
                if (lives == except) continue;
                return lives;
            }
        }
        return this.getRandomLife();
    }

    public void reset() {
        this.assignedLives = false;
    }

    public void onPlayerFinishJoining(class_3222 player) {
        if (!this.assignedLives) {
            return;
        }
        if (this.hasAssignedLives(player)) {
            return;
        }
        if (player.ls$isWatcher()) {
            return;
        }
        PlayerUtils.broadcastMessageToAdmins((class_2561)TextUtils.format("\u00a77Assigning random lives to {}\u00a77...", player));
        this.assignRandomLives(new ArrayList<class_3222>(List.of(player)));
    }
}

