/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.limitedlife;

import java.util.Collection;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.config.ConfigManager;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.seasons.boogeyman.BoogeymanManager;
import net.mat0u5.lifeseries.seasons.other.LivesManager;
import net.mat0u5.lifeseries.seasons.season.Season;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.limitedlife.LimitedLifeBoogeymanManager;
import net.mat0u5.lifeseries.seasons.season.limitedlife.LimitedLifeConfig;
import net.mat0u5.lifeseries.seasons.season.limitedlife.LimitedLifeLivesManager;
import net.mat0u5.lifeseries.seasons.season.limitedlife.LimitedLifeSecretSociety;
import net.mat0u5.lifeseries.seasons.secretsociety.SecretSociety;
import net.mat0u5.lifeseries.seasons.session.SessionTranscript;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.mat0u5.lifeseries.utils.enums.SessionTimerStates;
import net.mat0u5.lifeseries.utils.interfaces.IServerPlayer;
import net.mat0u5.lifeseries.utils.other.Time;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.player.ScoreboardUtils;
import net.mat0u5.lifeseries.utils.world.DatapackIntegration;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_9011;
import net.minecraft.server.MinecraftServer;

public class LimitedLife
extends Season {
    private boolean SHOW_DEATH_TITLE = true;
    public static Time NEW_DEATH_NORMAL = Time.hours(-1);
    private static Time NEW_DEATH_BOOGEYMAN = Time.hours(-2);
    private static Time NEW_KILL_NORMAL = Time.minutes(30);
    private static Time NEW_KILL_BOOGEYMAN = Time.hours(1);
    public static boolean TICK_OFFLINE_PLAYERS = false;
    public static boolean SHOW_TIME_BELOW_NAME = false;
    private int secondCounter = 0;

    @Override
    public Seasons getSeason() {
        return Seasons.LIMITED_LIFE;
    }

    @Override
    public ConfigManager createConfig() {
        return new LimitedLifeConfig();
    }

    @Override
    public BoogeymanManager createBoogeymanManager() {
        return new LimitedLifeBoogeymanManager();
    }

    @Override
    public SecretSociety createSecretSociety() {
        return new LimitedLifeSecretSociety();
    }

    @Override
    public LivesManager createLivesManager() {
        return new LimitedLifeLivesManager();
    }

    public void displayTimers(MinecraftServer server) {
        String message = "";
        if (Main.currentSession.statusNotStarted()) {
            message = "Session has not started";
        } else if (Main.currentSession.statusStarted()) {
            message = Main.currentSession.getRemainingTimeStr();
        } else if (Main.currentSession.statusPaused()) {
            message = "Session has been paused";
        } else if (Main.currentSession.statusFinished()) {
            message = "Session has ended";
        }
        for (class_3222 player : PlayerUtils.getAllPlayers()) {
            if (NetworkHandlerServer.wasHandshakeSuccessful(player)) {
                Integer playerLivesInt;
                long timestamp = SessionTimerStates.OFF.getValue();
                if (Main.currentSession.statusNotStarted()) {
                    timestamp = SessionTimerStates.NOT_STARTED.getValue();
                } else if (Main.currentSession.statusPaused()) {
                    timestamp = SessionTimerStates.PAUSED.getValue();
                } else if (Main.currentSession.statusFinished()) {
                    timestamp = SessionTimerStates.ENDED.getValue();
                } else if (Main.currentSession.validTime()) {
                    Time remainingTime = Main.currentSession.getRemainingTime();
                    timestamp = Time.now().add(remainingTime).getMillis();
                }
                if (timestamp != (long)SessionTimerStates.OFF.getValue()) {
                    NetworkHandlerServer.sendLongPacket(player, PacketNames.SESSION_TIMER, timestamp);
                }
                if (!player.ls$hasAssignedLives() || player.ls$getLives() == null) continue;
                long playerLives = player.ls$isAlive() ? ((playerLivesInt = player.ls$getLives()) == null ? -1L : (long)playerLivesInt.intValue()) : -1L;
                String livesColor = this.livesManager.getColorForLives(player).toString();
                NetworkHandlerServer.sendLongPacket(player, PacketNames.fromName(PacketNames.LIMITED_LIFE_TIMER.getName() + livesColor), playerLives);
                continue;
            }
            class_5250 fullMessage = class_2561.method_43473();
            if (Main.currentSession.displayTimer.contains(player.method_5667())) {
                fullMessage.method_10852((class_2561)class_2561.method_43470((String)message).method_27692(class_124.field_1080));
            }
            if (player.ls$hasAssignedLives()) {
                if (!fullMessage.getString().isEmpty()) {
                    fullMessage.method_10852(class_2561.method_30163((String)"  |  "));
                }
                fullMessage.method_10852(this.livesManager.getFormattedLives(player));
            }
            player.method_7353((class_2561)fullMessage, true);
        }
    }

    @Override
    public void tickSessionOn(MinecraftServer server) {
        super.tickSessionOn(server);
        if (!Main.currentSession.statusStarted()) {
            return;
        }
        --this.secondCounter;
        if (this.secondCounter <= 0) {
            this.secondCounter = 20;
            this.livesManager.getAlivePlayers().forEach(IServerPlayer::ls$removeLife);
            if (TICK_OFFLINE_PLAYERS) {
                Collection<class_9011> entries = ScoreboardUtils.getScores("Lives");
                for (class_9011 entry : entries) {
                    if (entry.comp_2128() <= 0 || PlayerUtils.getPlayer(entry.comp_2127()) != null) continue;
                    ScoreboardUtils.setScore(entry.comp_2127(), "Lives", entry.comp_2128() - 1);
                }
            }
        }
    }

    @Override
    public void onPlayerDeath(class_3222 player, class_1282 source) {
        class_1297 class_12972;
        SessionTranscript.onPlayerDeath(player, source);
        if (source != null && (class_12972 = source.method_5529()) instanceof class_3222) {
            class_3222 serverAttacker = (class_3222)class_12972;
            if (player != source.method_5529()) {
                this.onPlayerKilledByPlayer(player, serverAttacker);
                return;
            }
        }
        if (player.method_6124() != null && (class_12972 = player.method_6124()) instanceof class_3222) {
            class_3222 serverAdversary = (class_3222)class_12972;
            if (player != player.method_6124()) {
                this.onPlayerKilledByPlayer(player, serverAdversary);
                return;
            }
        }
        this.onPlayerDiedNaturally(player, source);
        DatapackIntegration.EVENT_PLAYER_DEATH.trigger(new DatapackIntegration.Events.MacroEntry("Player", player.method_5820()));
        if (!DatapackIntegration.EVENT_PLAYER_DEATH.isCanceled() && this.livesManager.canChangeLivesNaturally(player)) {
            player.ls$addLives(NEW_DEATH_NORMAL.getSeconds());
        }
    }

    @Override
    public void onClaimKill(class_3222 killer, class_3222 victim) {
        boolean wasBoogeyCure = this.boogeymanManager.isBoogeymanThatCanBeCured(killer, victim);
        super.onClaimKill(killer, victim);
        boolean cancelGain = DatapackIntegration.EVENT_CLAIM_KILL.isCanceled();
        boolean cancelPunishment = DatapackIntegration.EVENT_PLAYER_DEATH.isCanceled();
        if (cancelGain && cancelPunishment) {
            return;
        }
        if (wasBoogeyCure && this.livesManager.canChangeLivesNaturally()) {
            boolean wasAlive = victim.ls$isAlive();
            if (wasAlive && !cancelPunishment) {
                victim.ls$addLives(NEW_DEATH_BOOGEYMAN.diff(NEW_DEATH_NORMAL).getSeconds());
            }
            if (!cancelGain) {
                killer.ls$addLives(NEW_KILL_BOOGEYMAN.getSeconds());
            }
        }
    }

    @Override
    public void tryClaimKillLifeGain(class_3222 killer, class_3222 victim) {
        class_268 team = killer.method_5781();
        if (team != null) {
            Integer canGainLife = this.livesManager.getTeamGainLives(team.method_1197());
            Integer victimLives = victim.ls$getLives();
            int amount = NEW_KILL_NORMAL.getSeconds();
            if (canGainLife != null && victimLives != null && victimLives > 0 && victimLives + amount >= canGainLife) {
                this.broadcastLifeGain(killer, victim);
                killer.ls$addLives(amount);
            }
        }
    }

    @Override
    public void tryKillLifeGain(class_3222 killer, class_3222 victim) {
        Integer canGainLife;
        class_268 team = killer.method_5781();
        if (team != null && (canGainLife = this.livesManager.getTeamGainLives(team.method_1197())) != null && victim.ls$isOnAtLeastLives(canGainLife.intValue(), false)) {
            this.broadcastLifeGain(killer, victim);
            killer.ls$addLives(NEW_KILL_NORMAL.getSeconds());
        }
    }

    @Override
    public void onPlayerKilledByPlayer(class_3222 victim, class_3222 killer) {
        boolean wasBoogeyCure = this.boogeymanManager.isBoogeymanThatCanBeCured(killer, victim);
        super.onPlayerKilledByPlayer(victim, killer);
        if (DatapackIntegration.EVENT_PLAYER_PVP_KILLED.isCanceled()) {
            return;
        }
        if (!wasBoogeyCure && this.livesManager.canChangeLivesNaturally()) {
            victim.ls$addLives(NEW_DEATH_NORMAL.getSeconds());
        } else if (this.livesManager.canChangeLivesNaturally()) {
            victim.ls$addLives(NEW_DEATH_BOOGEYMAN.getSeconds());
            this.livesManager.addToLivesNoUpdate(killer, NEW_KILL_BOOGEYMAN.getSeconds());
            Main.currentSeason.reloadPlayerTeam(killer);
        }
    }

    @Override
    public void reload() {
        SHOW_TIME_BELOW_NAME = LimitedLifeConfig.SHOW_TIME_BELOW_NAME.get(Main.seasonConfig);
        super.reload();
        LimitedLifeLivesManager.DEFAULT_TIME = LimitedLifeConfig.TIME_DEFAULT.get(Main.seasonConfig);
        LimitedLifeLivesManager.YELLOW_TIME = LimitedLifeConfig.TIME_YELLOW.get(Main.seasonConfig);
        LimitedLifeLivesManager.RED_TIME = LimitedLifeConfig.TIME_RED.get(Main.seasonConfig);
        NEW_DEATH_NORMAL = Time.seconds(LimitedLifeConfig.TIME_DEATH.get(Main.seasonConfig));
        NEW_DEATH_BOOGEYMAN = Time.seconds(LimitedLifeConfig.TIME_DEATH_BOOGEYMAN.get(Main.seasonConfig));
        NEW_KILL_NORMAL = Time.seconds(LimitedLifeConfig.TIME_KILL.get(Main.seasonConfig));
        NEW_KILL_BOOGEYMAN = Time.seconds(LimitedLifeConfig.TIME_KILL_BOOGEYMAN.get(Main.seasonConfig));
        TICK_OFFLINE_PLAYERS = LimitedLifeConfig.TICK_OFFLINE_PLAYERS.get(Main.seasonConfig);
        LimitedLifeLivesManager.BROADCAST_COLOR_CHANGES = LimitedLifeConfig.BROADCAST_COLOR_CHANGES.get(Main.seasonConfig);
    }

    @Override
    public Integer getDefaultLives() {
        return LimitedLifeLivesManager.DEFAULT_TIME;
    }

    public static Integer getNextLivesColorLives(Integer currentLives) {
        if (currentLives == null) {
            return null;
        }
        if (currentLives > LimitedLifeLivesManager.DEFAULT_TIME) {
            return LimitedLifeLivesManager.DEFAULT_TIME;
        }
        if (currentLives > LimitedLifeLivesManager.YELLOW_TIME) {
            return LimitedLifeLivesManager.YELLOW_TIME;
        }
        if (currentLives > LimitedLifeLivesManager.RED_TIME) {
            return LimitedLifeLivesManager.RED_TIME;
        }
        return 0;
    }
}

