/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.limitedlife;

import java.util.Locale;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.other.LivesManager;
import net.mat0u5.lifeseries.seasons.other.WatcherManager;
import net.mat0u5.lifeseries.seasons.season.limitedlife.LimitedLife;
import net.mat0u5.lifeseries.seasons.session.SessionTranscript;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.other.Time;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.player.ScoreboardUtils;
import net.mat0u5.lifeseries.utils.world.AnimationUtils;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;

public class LimitedLifeLivesManager
extends LivesManager {
    public static int DEFAULT_TIME = 86400;
    public static int YELLOW_TIME = 57600;
    public static int RED_TIME = 28800;
    public static boolean BROADCAST_COLOR_CHANGES = false;

    @Override
    public class_124 getColorForLives(Integer lives) {
        if ((lives = this.getEquivalentLives(lives)) == null) {
            return class_124.field_1080;
        }
        if (lives == 1) {
            return class_124.field_1061;
        }
        if (lives == 2) {
            return class_124.field_1054;
        }
        if (lives == 3) {
            return class_124.field_1060;
        }
        if (lives >= 4) {
            return class_124.field_1077;
        }
        return class_124.field_1063;
    }

    @Override
    public class_2561 getFormattedLives(Integer lives) {
        if (lives == null) {
            return class_2561.method_43473();
        }
        class_124 color = this.getColorForLives(lives);
        return class_2561.method_43470((String)Time.seconds(lives).formatLong()).method_27692(color);
    }

    @Override
    public String getTeamForLives(Integer lives) {
        if ((lives = this.getEquivalentLives(lives)) == null) {
            return "lives_null";
        }
        if (lives == 1) {
            return "lives_1";
        }
        if (lives == 2) {
            return "lives_2";
        }
        if (lives == 3) {
            return "lives_3";
        }
        if (lives >= 4) {
            return "lives_4";
        }
        return "lives_0";
    }

    @Override
    public void setPlayerLives(class_3222 player, int lives) {
        class_124 colorNow;
        if (WatcherManager.isWatcher((class_1657)player)) {
            return;
        }
        Integer livesBefore = this.getPlayerLives(player);
        class_124 colorBefore = null;
        if (player.method_5781() != null) {
            colorBefore = player.method_5781().method_1202();
        }
        ScoreboardUtils.setScore(player.method_5820(), "Lives", lives);
        if (lives <= 0) {
            this.playerLostAllLives(player, livesBefore);
        }
        if (colorBefore != (colorNow = this.getColorForLives(lives))) {
            if (player.method_7325() && lives > 0) {
                PlayerUtils.safelyPutIntoSurvival(player);
            }
            if (lives > 0 && colorBefore != null && livesBefore != null && BROADCAST_COLOR_CHANGES) {
                class_5250 livesText = TextUtils.format("{} name", colorNow.method_537().replaceAll("_", " ").toLowerCase(Locale.ROOT)).method_27692(colorNow);
                PlayerUtils.broadcastMessage((class_2561)TextUtils.format("{}\u00a77 is now a {}\u00a77.", player, livesText));
            }
        }
        Main.currentSeason.reloadPlayerTeam(player);
    }

    @Override
    public Boolean isOnSpecificLives(class_3222 player, int check) {
        if (this.isDead(player)) {
            return null;
        }
        Integer lives = this.getEquivalentLives(this.getPlayerLives(player));
        if (lives == null) {
            return null;
        }
        return lives == check;
    }

    public Integer getEquivalentLives(Integer limitedLifeLives) {
        if (limitedLifeLives == null) {
            return null;
        }
        if (limitedLifeLives <= 0) {
            return 0;
        }
        if (limitedLifeLives <= RED_TIME) {
            return 1;
        }
        if (limitedLifeLives <= YELLOW_TIME) {
            return 2;
        }
        if (limitedLifeLives <= DEFAULT_TIME) {
            return 3;
        }
        return 4;
    }

    @Override
    public void receiveLifeFromOtherPlayer(class_2561 playerName, class_3222 target, boolean isRevive) {
        target.ls$playNotifySound(class_3417.field_26980, class_3419.field_15250, 10.0f, 1.0f);
        class_5250 amount = class_2561.method_43470((String)LimitedLife.NEW_DEATH_NORMAL.copy().multiply(-1L).formatLong());
        if (((Boolean)Main.seasonConfig.GIVELIFE_BROADCAST.get(Main.seasonConfig)).booleanValue()) {
            PlayerUtils.broadcastMessageExcept((class_2561)TextUtils.format("{} received {} from {}", target, amount, playerName), target);
        }
        target.method_64398((class_2561)TextUtils.format("You received {} from {}", amount, playerName));
        PlayerUtils.sendTitleWithSubtitle(target, (class_2561)TextUtils.format("You received {}", amount), (class_2561)TextUtils.format("from {}", playerName), 10, 60, 10);
        AnimationUtils.createSpiral(target, 175);
        Main.currentSeason.reloadPlayerTeam(target);
        SessionTranscript.givelife(playerName, target);
        if (isRevive && this.isAlive(target)) {
            PlayerUtils.safelyPutIntoSurvival(target);
        }
    }

    @Override
    public void addToPlayerLives(class_3222 player, int amount) {
        if (Math.abs(amount) >= 2) {
            this.sendTimeTitle(player, Time.seconds(amount), amount < 0 ? class_124.field_1061 : class_124.field_1060);
        }
        super.addToPlayerLives(player, amount);
    }

    public void sendTimeTitle(class_3222 player, Time time, class_124 style) {
        this.sendTimeTitle(player, (class_2561)class_2561.method_43470((String)time.formatReadable()).method_27692(style));
    }

    public void sendTimeTitle(class_3222 player, class_2561 text) {
        PlayerUtils.sendTitle(player, text, 20, 80, 20);
    }
}

