/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.nicelife;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.compatibilities.CompatibilityManager;
import net.mat0u5.lifeseries.compatibilities.voicechat.VoicechatMain;
import net.mat0u5.lifeseries.config.ConfigManager;
import net.mat0u5.lifeseries.entity.triviabot.TriviaBot;
import net.mat0u5.lifeseries.entity.triviabot.server.trivia.NiceLifeTriviaHandler;
import net.mat0u5.lifeseries.entity.triviabot.server.trivia.TriviaHandler;
import net.mat0u5.lifeseries.mixin.ServerLevelAccessor;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.seasons.season.Season;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.nicelife.NiceLifeConfig;
import net.mat0u5.lifeseries.seasons.season.nicelife.NiceLifeTriviaManager;
import net.mat0u5.lifeseries.seasons.season.nicelife.NiceLifeVotingManager;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.mat0u5.lifeseries.utils.other.IdentifierHelper;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.other.Time;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_12279;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2488;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_4538;
import net.minecraft.server.MinecraftServer;

public class NiceLife
extends Season {
    public static boolean SNOWY_NETHER = true;
    public static boolean LIGHT_MELTS_SNOW = false;
    public boolean SNOW_WHEN_NOT_IN_SESSION = false;
    public static boolean ADVANCE_TIME_WHEN_NOT_IN_SESSION = false;
    public Time SNOW_LAYER_INCREASE_INTERVAL = Time.seconds(600);
    public Time snowTicks = Time.zero();
    public double snowLayerTickChance = 0.023255813953488372;
    public int precipitationTicks = 1;
    public double chancePerTick = this.snowLayerTickChance;
    public int currentMaxSnowLayers = -1;
    public static boolean playedMidnightChimes = false;
    public static boolean reachedSunset = false;
    public static boolean reachedPreSunset = false;
    public static boolean redWinter = false;
    public static Time naughtyListGlowTimeInterval = Time.seconds(60);
    public static Time naughtyListGlowTime = Time.seconds(5);
    public static Time timePassed = Time.zero();
    public static Time triviaCannotStartFor = Time.zero();
    public static final class_2680 blueIce = class_2246.field_10384.method_9564();
    public static final class_2680 snowBlock = class_2246.field_10491.method_9564();
    public static final class_2680 air = class_2246.field_10124.method_9564();
    public static final class_2680 froglight = class_2246.field_37574.method_9564();

    @Override
    public void initialize() {
        super.initialize();
        NiceLifeTriviaHandler.initializeItemSpawner();
        NiceLifeTriviaManager.initialize();
    }

    @Override
    public Seasons getSeason() {
        return Seasons.NICE_LIFE;
    }

    @Override
    public ConfigManager createConfig() {
        return new NiceLifeConfig();
    }

    @Override
    public void seasonSwitched(Seasons changedTo) {
        if (changedTo != Seasons.NICE_LIFE) {
            if (Main.server == null) {
                return;
            }
            OtherUtils.setBooleanGameRule(Main.server.method_30002(), (class_12279<Boolean>)class_1928.field_19396, true);
            NiceLifeTriviaManager.killAllSnowmen();
            NiceLifeTriviaManager.killAllBots();
        }
    }

    @Override
    public void reload() {
        super.reload();
        NiceLifeVotingManager.createTeams();
        LIGHT_MELTS_SNOW = NiceLifeConfig.LIGHT_MELTS_SNOW.get(Main.seasonConfig);
        this.SNOW_WHEN_NOT_IN_SESSION = NiceLifeConfig.SNOW_WHEN_NOT_IN_SESSION.get(Main.seasonConfig);
        this.SNOW_LAYER_INCREASE_INTERVAL = Time.seconds(NiceLifeConfig.SNOW_LAYER_INCREMENT_DELAY.get(Main.seasonConfig));
        ADVANCE_TIME_WHEN_NOT_IN_SESSION = NiceLifeConfig.ADVANCE_TIME_WHEN_NOT_IN_SESSION.get(Main.seasonConfig);
        SNOWY_NETHER = NiceLifeConfig.SNOWY_NETHER.get(Main.seasonConfig);
        this.snowLayerTickChance = 280.0 / (double)Math.max(this.SNOW_LAYER_INCREASE_INTERVAL.getTicks(), 1);
        if (this.currentMaxSnowLayers == -1) {
            this.currentMaxSnowLayers = Main.seasonConfig.getOrCreateInt("current_snow_layers", 1);
        }
        this.updateSnowTick();
        NiceLifeTriviaManager.initialize();
        NiceLifeTriviaManager.QUESTION_TIME = NiceLifeConfig.TRIVIA_QUESTION_TIME.get(Main.seasonConfig);
        NiceLifeTriviaManager.CAN_BREAK_BEDS = NiceLifeConfig.BOT_CAN_BREAK_BEDS.get(Main.seasonConfig);
        NiceLifeTriviaManager.BREAKING_DROPS_RESOURCES = NiceLifeConfig.BOT_BREAKING_BLOCKS_DROP_RESOURCES.get(Main.seasonConfig);
        NiceLifeVotingManager.NICE_LIST_CHANCE = NiceLifeConfig.NICE_LIST_CHANCE.get(Main.seasonConfig);
        NiceLifeVotingManager.VOTING_TIME = Time.seconds(NiceLifeConfig.VOTING_TIME.get(Main.seasonConfig));
        NiceLifeVotingManager.REDS_ON_NAUGHTY_LIST = NiceLifeConfig.ALLOW_REDS_ON_NAUGHTY_LIST.get(Main.seasonConfig);
        NiceLifeVotingManager.NAUGHTY_LIST_COUNT = NiceLifeConfig.NAUGHTY_LIST_PLAYERS.get(Main.seasonConfig);
        NiceLifeVotingManager.NICE_LIST_COUNT = NiceLifeConfig.NICE_LIST_PLAYERS.get(Main.seasonConfig);
    }

    public void updateSnowTick() {
        double chance = this.snowLayerTickChance;
        if (redWinter) {
            chance *= 5.0;
        }
        if (this.currentMaxSnowLayers >= 8) {
            chance *= 3.0;
        }
        this.precipitationTicks = Math.max(1, (int)Math.ceil(chance));
        this.chancePerTick = chance / (double)this.precipitationTicks;
    }

    @Override
    public void tick(MinecraftServer server) {
        super.tick(server);
        timePassed.tick();
        if (Main.currentSession.statusStarted() || this.SNOW_WHEN_NOT_IN_SESSION) {
            this.snowTicks.tick();
            if (this.snowTicks.isLarger(this.SNOW_LAYER_INCREASE_INTERVAL)) {
                this.snowTicks = Time.zero();
                ++this.currentMaxSnowLayers;
                if (this.currentMaxSnowLayers > 8) {
                    this.currentMaxSnowLayers = 1;
                }
                this.updateSnowTick();
                Main.seasonConfig.setProperty("current_snow_layers", String.valueOf(this.currentMaxSnowLayers));
            }
        }
        class_3218 overworld = server.method_30002();
        overworld.method_27910(0, 1000, true, false);
        boolean advanceTime = !this.isMidnight() && (Main.currentSession.statusStarted() || ADVANCE_TIME_WHEN_NOT_IN_SESSION);
        OtherUtils.setBooleanGameRule(overworld, (class_12279<Boolean>)class_1928.field_19396, advanceTime);
        if (!this.isMidnight()) {
            for (class_3222 serverPlayer : PlayerUtils.getAllPlayers()) {
                if (!serverPlayer.method_6113()) continue;
                serverPlayer.method_7353(class_2561.method_30163((String)"You are too excited to fall asleep"), true);
            }
            if (!playedMidnightChimes && this.isTimeBetween(17540, 20000)) {
                playedMidnightChimes = true;
                PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), class_3414.method_47908((class_2960)IdentifierHelper.vanilla("nicelife_midnight_chimes")), 1.0f, 1.0f);
                NiceLife.postponeTriviaStart(Time.ticks(779));
            }
        }
        if (triviaCannotStartFor.isSmaller(Time.zero())) {
            int percentage = (Integer)overworld.method_64395().method_76185(class_1928.field_28357);
            if (NiceLife.areEnoughSleeping(percentage) && this.isMidnight() && Main.currentSession.statusStarted() && !NiceLifeTriviaManager.triviaInProgress) {
                ArrayList<class_3222> triviaPlayers = new ArrayList<class_3222>();
                for (class_3222 player : this.livesManager.getAlivePlayers()) {
                    if (player.method_7325() || !player.method_6113()) continue;
                    triviaPlayers.add(player);
                }
                if (!triviaPlayers.isEmpty()) {
                    NiceLifeTriviaManager.startTrivia(triviaPlayers);
                }
            }
        } else {
            triviaCannotStartFor.add(Time.ticks(-1));
        }
        if (this.isMidnight() && NiceLifeTriviaManager.triviaInProgress && !NiceLifeTriviaManager.preparingForSpawn) {
            ArrayList<class_3222> remainingTriviaPlayers = new ArrayList<class_3222>();
            for (UUID playerUUID : NiceLifeTriviaManager.triviaPlayersUUID) {
                TriviaHandler triviaHandler;
                TriviaBot bot;
                class_3222 player;
                player = PlayerUtils.getPlayer(playerUUID);
                if (player == null || !player.method_6113() || player.ls$isDead() || (bot = NiceLifeTriviaManager.bots.get(playerUUID)) == null || !bot.method_5805() || !((triviaHandler = bot.triviaHandler) instanceof NiceLifeTriviaHandler)) continue;
                NiceLifeTriviaHandler triviaHandler2 = (NiceLifeTriviaHandler)triviaHandler;
                if (triviaHandler2.currentState == NiceLifeTriviaHandler.BotState.FINISHED) continue;
                remainingTriviaPlayers.add(player);
            }
            if (remainingTriviaPlayers.isEmpty()) {
                this.sleepThroughNight();
            }
        }
        if (!reachedPreSunset && this.isTimeBetween(11800, 13000) && !NiceLifeVotingManager.niceListMembers.isEmpty()) {
            NiceLifeVotingManager.warnNiceListMembers();
        }
        if (!reachedSunset && this.isSunset()) {
            NiceLifeVotingManager.endListsIfNecessary();
        }
        reachedSunset = this.isSunset();
        reachedPreSunset = this.isTimeBetween(11800, 13000);
        boolean shouldRedWinter = this.shouldRedWinter();
        if (redWinter != shouldRedWinter) {
            redWinter = shouldRedWinter;
            if (redWinter) {
                this.triggerRedWinter();
            } else {
                Season.setSkyColor(null, false);
                Season.setFogColor(null, false);
                Season.setCloudColor(null, false);
            }
        }
        if (timePassed.getTicks() % 20 == 0 && CompatibilityManager.voicechatLoaded()) {
            VoicechatMain.niceLifeTick();
        }
    }

    public static boolean areEnoughSleeping(int percentage) {
        List<class_3222> players = Main.livesManager.getAlivePlayers();
        int allPlayers = 0;
        int sleepingPlayers = 0;
        for (class_3222 player : players) {
            if (player.method_7325()) continue;
            ++allPlayers;
            if (!player.method_6113()) continue;
            ++sleepingPlayers;
        }
        return sleepingPlayers >= Math.max(1, class_3532.method_15386((float)((float)(allPlayers * percentage) / 100.0f)));
    }

    public static void postponeTriviaStart(Time time) {
        if (!triviaCannotStartFor.isLarger(time)) {
            triviaCannotStartFor = time;
        }
    }

    @Override
    public void tickSessionOn(MinecraftServer server) {
        super.tickSessionOn(server);
        if (timePassed.isMultipleOf(naughtyListGlowTimeInterval)) {
            class_1293 glowing = new class_1293(class_1294.field_5912, naughtyListGlowTime.getTicks(), 0);
            for (UUID uuid : NiceLifeVotingManager.naughtyListMembers) {
                class_3222 player = PlayerUtils.getPlayer(uuid);
                if (player == null) continue;
                player.method_6092(glowing);
            }
        }
    }

    public void triggerRedWinter() {
        TaskScheduler.scheduleTask(20, () -> PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), class_3414.method_47908((class_2960)IdentifierHelper.vanilla("nicelife_red_winter")), 1.0f, 1.0f));
        TaskScheduler.scheduleTask(32, () -> PlayerUtils.sendTitleToPlayers(PlayerUtils.getAllPlayers(), (class_2561)class_2561.method_43470((String)"\u00a7eThe last yellow falls.."), 15, 65, 15));
        TaskScheduler.scheduleTask(128, () -> PlayerUtils.sendTitleToPlayers(PlayerUtils.getAllPlayers(), (class_2561)class_2561.method_43470((String)"\u00a7cRed winter is here.."), 15, 40, 15));
        TaskScheduler.scheduleTask(235, () -> NetworkHandlerServer.sendNumberPackets(PacketNames.FAKE_THUNDER, 7.0));
        TaskScheduler.scheduleTask(244, () -> {
            Season.setSkyColor(new class_243(15.0, -140.0, -255.0), false);
            Season.setFogColor(new class_243(40.0, -104.0, -163.0), false);
            Season.setCloudColor(new class_243(-255.0, -255.0, -255.0), true);
        });
    }

    public boolean shouldRedWinter() {
        if (Main.currentSession.statusNotStarted()) {
            return false;
        }
        List<class_3222> redPlayers = this.livesManager.getAlivePlayers();
        List<class_3222> nonRedPlayers = this.livesManager.getNonRedPlayers();
        return !redPlayers.isEmpty() && nonRedPlayers.isEmpty();
    }

    public void sleepThroughNight() {
        if (Main.server == null) {
            return;
        }
        class_3218 overworld = Main.server.method_30002();
        if (overworld instanceof ServerLevelAccessor) {
            ServerLevelAccessor accessor = (ServerLevelAccessor)overworld;
            long newTime = overworld.method_8532() + 24000L;
            overworld.method_29199(newTime - newTime % 24000L);
            accessor.ls$wakeUpAllPlayers();
            playedMidnightChimes = false;
            NiceLifeTriviaManager.endTrivia();
        }
    }

    public void wakeUpAllPlayers() {
        if (Main.server == null) {
            return;
        }
        class_3218 overworld = Main.server.method_30002();
        if (overworld instanceof ServerLevelAccessor) {
            ServerLevelAccessor accessor = (ServerLevelAccessor)overworld;
            accessor.ls$wakeUpAllPlayers();
        }
    }

    @Override
    public boolean sessionStart() {
        super.sessionStart();
        NiceLifeTriviaManager.sessionStart();
        NiceLifeVotingManager.endListsIfNecessary();
        this.wakeUpAllPlayers();
        playedMidnightChimes = false;
        return true;
    }

    @Override
    public void sessionEnd() {
        super.sessionEnd();
        NiceLifeTriviaManager.sessionEnd();
        NiceLifeVotingManager.endListsIfNecessary();
        this.wakeUpAllPlayers();
    }

    public boolean isMidnight() {
        return this.isTimeBetween(18000, 20000);
    }

    public boolean isSunset() {
        return this.isTimeBetween(13000, 20000);
    }

    public boolean isTimeBetween(int minTime, int maxTime) {
        if (Main.server == null) {
            return false;
        }
        long dayTime = Main.server.method_30002().method_8532() % 24000L;
        return dayTime >= (long)minTime && dayTime <= (long)maxTime;
    }

    public void tickChunk(class_3218 level, class_1923 chunkPos) {
        if (level.method_27983() != class_1937.field_25179) {
            return;
        }
        if (Main.currentSession.statusStarted() || this.SNOW_WHEN_NOT_IN_SESSION) {
            int minX = chunkPos.method_8326();
            int maxX = chunkPos.method_8328();
            for (int i = 0; i < this.precipitationTicks; ++i) {
                if (!(level.field_9229.method_43058() <= this.chancePerTick)) continue;
                this.customPrecipitation(level, level.method_8536(minX, 0, maxX, 15));
            }
        }
    }

    public void customPrecipitation(class_3218 level, class_2338 pos) {
        class_1959.class_1963 precipitation;
        class_2338 topPos = level.method_8598(class_2902.class_2903.field_13197, pos);
        class_2338 belowPos = topPos.method_10074();
        class_1959 biome = (class_1959)level.method_23753(topPos).comp_349();
        if (this.shouldFreeze(level, belowPos)) {
            level.method_8501(belowPos, class_2246.field_10295.method_9564());
        }
        if (this.shouldSnow(level, topPos)) {
            class_2680 state = level.method_8320(topPos);
            if (this.currentMaxSnowLayers > 0) {
                if (state.method_27852(class_2246.field_10477)) {
                    int currentLayers = (Integer)state.method_11654((class_2769)class_2488.field_11518);
                    if (currentLayers < Math.min(this.currentMaxSnowLayers, 8)) {
                        if (currentLayers == 7) {
                            class_2680 newState = class_2246.field_10491.method_9564();
                            level.method_8501(topPos, newState);
                            class_2248.method_9582((class_2680)state, (class_2680)newState, (class_1936)level, (class_2338)topPos);
                        } else {
                            class_2680 newState = (class_2680)state.method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(currentLayers + 1));
                            level.method_8501(topPos, newState);
                            class_2248.method_9582((class_2680)state, (class_2680)newState, (class_1936)level, (class_2338)topPos);
                        }
                    }
                } else if (!level.method_8320(belowPos).method_27852(class_2246.field_10491) || this.currentMaxSnowLayers != 8) {
                    class_2680 newState = class_2246.field_10477.method_9564();
                    level.method_8501(topPos, newState);
                    class_2248.method_9582((class_2680)state, (class_2680)newState, (class_1936)level, (class_2338)topPos);
                }
            }
        }
        if ((precipitation = biome.method_48162(belowPos, level.method_8615())) != class_1959.class_1963.field_9384) {
            class_2680 belowState = level.method_8320(belowPos);
            belowState.method_26204().method_9504(belowState, (class_1937)level, belowPos, precipitation);
        }
    }

    private boolean shouldFreeze(class_3218 level, class_2338 blockPos) {
        boolean darkEnough = level.method_8314(class_1944.field_9282, blockPos) < 10 || !LIGHT_MELTS_SNOW;
        int minY = level.method_31607();
        int maxY = level.method_31600();
        if (blockPos.method_10264() >= minY && blockPos.method_10264() < maxY && darkEnough) {
            class_2680 blockState = level.method_8320(blockPos);
            class_3610 fluidState = level.method_8316(blockPos);
            if (fluidState.method_15772() == class_3612.field_15910 && blockState.method_26204() instanceof class_2404) {
                boolean middleLiquid;
                boolean bl = middleLiquid = level.method_22351(blockPos.method_10067()) && level.method_22351(blockPos.method_10078()) && level.method_22351(blockPos.method_10095()) && level.method_22351(blockPos.method_10072());
                if (!middleLiquid) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean shouldSnow(class_3218 level, class_2338 blockPos) {
        boolean darkEnough = level.method_8314(class_1944.field_9282, blockPos) < 10 || !LIGHT_MELTS_SNOW;
        int minY = level.method_31607();
        int maxY = level.method_31600();
        if (blockPos.method_10264() >= minY && blockPos.method_10264() < maxY && darkEnough) {
            boolean canSnowOverride;
            class_2680 blockState = level.method_8320(blockPos);
            boolean bl = canSnowOverride = blockState.method_26215() || blockState.method_27852(class_2246.field_10477) || blockState.method_27852(class_2246.field_10479) || blockState.method_27852(class_2246.field_55742) || blockState.method_27852(class_2246.field_10214) || blockState.method_27852(class_2246.field_10182) || blockState.method_27852(class_2246.field_42734) || blockState.method_27852(class_2246.field_10449) || blockState.method_27852(class_2246.field_10086) || blockState.method_27852(class_2246.field_10226) || blockState.method_27852(class_2246.field_10573) || blockState.method_27852(class_2246.field_10270) || blockState.method_27852(class_2246.field_10048) || blockState.method_27852(class_2246.field_10156) || blockState.method_27852(class_2246.field_10315) || blockState.method_27852(class_2246.field_10554) || blockState.method_27852(class_2246.field_9995) || blockState.method_27852(class_2246.field_10606) || blockState.method_27852(class_2246.field_10548);
            if (canSnowOverride && class_2246.field_10477.method_9564().method_26184((class_4538)level, blockPos)) {
                return true;
            }
        }
        return false;
    }

    public class_2680 transformBlockState(class_2680 oldState) {
        if (oldState.method_27852(class_2246.field_10515) || oldState.method_27852(class_2246.field_23869) || oldState.method_27852(class_2246.field_22091) || oldState.method_27852(class_2246.field_10114) || oldState.method_27852(class_2246.field_22090) || oldState.method_27852(class_2246.field_22120) || oldState.method_27852(class_2246.field_22113) || oldState.method_27852(class_2246.field_10092) || oldState.method_27852(class_2246.field_10255)) {
            return snowBlock;
        }
        if (oldState.method_27852(class_2246.field_10164)) {
            return blueIce;
        }
        if (oldState.method_27852(class_2246.field_22121) || oldState.method_27852(class_2246.field_22125) || oldState.method_27852(class_2246.field_22114) || oldState.method_27852(class_2246.field_22116) || oldState.method_27852(class_2246.field_22117)) {
            return air;
        }
        if (oldState.method_27852(class_2246.field_10171) || oldState.method_27852(class_2246.field_22122)) {
            return froglight;
        }
        return null;
    }

    @Override
    public String getTeamForPlayer(class_3222 player) {
        if (NiceLifeVotingManager.naughtyListMembers.contains(player.method_5667())) {
            return NiceLifeVotingManager.NAUGHTY_LIST_TEAM;
        }
        if (NiceLifeVotingManager.niceListMembers.contains(player.method_5667())) {
            return NiceLifeVotingManager.NICE_LIST_TEAM;
        }
        return super.getTeamForPlayer(player);
    }

    @Override
    public boolean isAllowedToAttack(class_3222 attacker, class_3222 victim, boolean allowSelfDefense) {
        if (NiceLifeVotingManager.niceListMembers.contains(victim.method_5667())) {
            return false;
        }
        if (NiceLifeVotingManager.naughtyListMembers.contains(victim.method_5667())) {
            return true;
        }
        return super.isAllowedToAttack(attacker, victim, allowSelfDefense);
    }

    @Override
    public void onPlayerDeath(class_3222 player, class_1282 source) {
        super.onPlayerDeath(player, source);
        NiceLifeVotingManager.naughtyListMembers.remove(player.method_5667());
        if (player.ls$isDead()) {
            NiceLifeVotingManager.niceListMembers.remove(player.method_5667());
        }
        this.reloadPlayerTeam(player);
    }
}

