/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.nicelife;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.command.manager.Command;
import net.mat0u5.lifeseries.seasons.season.Season;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.nicelife.NiceLife;
import net.mat0u5.lifeseries.seasons.season.nicelife.NiceLifeVotingManager;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class NiceLifeCommands
extends Command {
    @Override
    public boolean isAllowed() {
        return Main.currentSeason.getSeason() == Seasons.NICE_LIFE;
    }

    @Override
    public class_2561 getBannedText() {
        return class_2561.method_30163((String)"This command is only available when playing Nice Life.");
    }

    @Override
    public List<String> getAdminCommands() {
        return List.of("vote", "nicelife");
    }

    @Override
    public List<String> getNonAdminCommands() {
        return List.of("vote");
    }

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)NiceLifeCommands.literal("vote").executes(context -> this.vote((class_2168)context.getSource()))).then(((LiteralArgumentBuilder)NiceLifeCommands.literal("forceNext").requires(PermissionManager::isAdmin)).then(NiceLifeCommands.argument("type", StringArgumentType.string()).suggests((context, builder) -> class_2172.method_9265(List.of("none", "nicelist", "naughtylist"), (SuggestionsBuilder)builder)).executes(context -> this.forceNextVote((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"type"))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)NiceLifeCommands.literal("nicelife").requires(PermissionManager::isAdmin)).then(((LiteralArgumentBuilder)NiceLifeCommands.literal("wakeUp").executes(context -> this.wakeup((class_2168)context.getSource()))).then(NiceLifeCommands.argument("players", class_2186.method_9308()).executes(context -> this.wakeup((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"players")))))).then(NiceLifeCommands.literal("skipNight").executes(context -> this.skipNight((class_2168)context.getSource()))));
    }

    private int forceNextVote(class_2168 source, String type) {
        if (this.checkBanned(source)) {
            return -1;
        }
        switch (type) {
            case "none": {
                NiceLifeVotingManager.forcedTriviaVote = Optional.of(NiceLifeVotingManager.VoteType.NONE);
                break;
            }
            case "nicelist": {
                NiceLifeVotingManager.forcedTriviaVote = Optional.of(NiceLifeVotingManager.VoteType.NICE_LIST);
                break;
            }
            case "naughtylist": {
                NiceLifeVotingManager.forcedTriviaVote = Optional.of(NiceLifeVotingManager.VoteType.NAUGHTY_LIST);
                break;
            }
            default: {
                source.method_9213(class_2561.method_30163((String)"Vote type not found"));
                return -1;
            }
        }
        OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Next midnight vote will be '{}'", type));
        return 1;
    }

    private int wakeup(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        class_3222 self = source.method_44023();
        if (self == null) {
            return -1;
        }
        if (!self.method_6113()) {
            source.method_9213(class_2561.method_30163((String)"You are not sleeping"));
            return -1;
        }
        self.method_7358(false, true);
        OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Woke up {}", self));
        return 1;
    }

    private int wakeup(class_2168 source, Collection<class_3222> targets) {
        if (this.checkBanned(source)) {
            return -1;
        }
        for (class_3222 player : targets) {
            if (!player.method_6113()) continue;
            player.method_7358(false, true);
        }
        if (targets.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Woke up {}", targets.iterator().next()));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Woke up {} players", targets.size()));
        }
        return 1;
    }

    private int skipNight(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        Season season = Main.currentSeason;
        if (season instanceof NiceLife) {
            NiceLife niceLife = (NiceLife)season;
            if (!source.method_9211().method_30002().method_23886()) {
                source.method_9213(class_2561.method_30163((String)"It is not night time"));
                return -1;
            }
            niceLife.sleepThroughNight();
        }
        return 1;
    }

    private int vote(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        class_3222 self = source.method_44023();
        if (self == null) {
            return -1;
        }
        if (!NiceLifeVotingManager.niceListMembers.contains(self.method_5667())) {
            source.method_9213((class_2561)class_2561.method_43470((String)"You are not on the nice list"));
            return -1;
        }
        if (NiceLifeVotingManager.voteType != NiceLifeVotingManager.VoteType.NICE_LIST_LIFE) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Nice list voting is not in progress"));
            return -1;
        }
        if (self.ls$isDead()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Dead players cannot vote"));
            return -1;
        }
        if (self.ls$isWatcher()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Watchers cannot vote"));
            return -1;
        }
        boolean success = NiceLifeVotingManager.openNiceListLifeVote(self);
        if (!success) {
            source.method_9213((class_2561)class_2561.method_43470((String)"There are no players to vote for"));
            return -1;
        }
        return 1;
    }
}

