/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.nicelife;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.command.manager.Command;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.nicelife.NiceLifeTriviaManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.trivia.TriviaQuestion;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.trivia.TriviaQuestionManager;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;

public class NiceLifeTriviaCommand
extends Command {
    @Override
    public boolean isAllowed() {
        return Main.currentSeason.getSeason() == Seasons.NICE_LIFE;
    }

    @Override
    public class_2561 getBannedText() {
        return class_2561.method_30163((String)"This command is only available in Nice Life.");
    }

    @Override
    public List<String> getAdminCommands() {
        return List.of("trivia");
    }

    @Override
    public List<String> getNonAdminCommands() {
        return List.of();
    }

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)NiceLifeTriviaCommand.literal("trivia").requires(PermissionManager::isAdmin)).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)NiceLifeTriviaCommand.literal("set").requires(source -> this.isAllowed())).then(NiceLifeTriviaCommand.argument("question", StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9265(this.getTriviaSuggestionsStr(), (SuggestionsBuilder)builder)).executes(context -> this.setTrivia((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"question"))))).then(NiceLifeTriviaCommand.literal("reset").executes(context -> this.resetTrivia((class_2168)context.getSource())))));
    }

    public List<String> getTriviaSuggestionsStr() {
        ArrayList<String> result = new ArrayList<String>();
        for (TriviaQuestion question : this.getTriviaQuestions()) {
            result.add(question.getQuestion());
        }
        return result;
    }

    public List<TriviaQuestion> getTriviaQuestions() {
        ArrayList<TriviaQuestion> result = new ArrayList<TriviaQuestion>();
        TriviaQuestionManager manager = NiceLifeTriviaManager.triviaQuestions;
        if (manager != null) {
            try {
                result.addAll(manager.getTriviaQuestions());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private int setTrivia(class_2168 source, String question) {
        if (this.checkBanned(source)) {
            return -1;
        }
        TriviaQuestion triviaQuestion = null;
        for (TriviaQuestion possibleQuestion : this.getTriviaQuestions()) {
            if (!possibleQuestion.getQuestion().equals(question)) continue;
            triviaQuestion = possibleQuestion;
            break;
        }
        if (triviaQuestion == null) {
            source.method_9213(class_2561.method_30163((String)"Could not find trivia with that question."));
            return -1;
        }
        NiceLifeTriviaManager.preAssignedTrivia = triviaQuestion;
        OtherUtils.sendCommandFeedback(source, (class_2561)class_2561.method_43470((String)"Successfuly assigned trivia"));
        return 1;
    }

    private int resetTrivia(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        NiceLifeTriviaManager.preAssignedTrivia = null;
        OtherUtils.sendCommandFeedback(source, (class_2561)class_2561.method_43470((String)"Reset assigned trivia"));
        return 1;
    }
}

