/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.nicelife;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.compatibilities.CompatibilityManager;
import net.mat0u5.lifeseries.compatibilities.voicechat.VoicechatMain;
import net.mat0u5.lifeseries.entity.angrysnowman.AngrySnowman;
import net.mat0u5.lifeseries.entity.triviabot.TriviaBot;
import net.mat0u5.lifeseries.entity.triviabot.server.trivia.NiceLifeTriviaHandler;
import net.mat0u5.lifeseries.entity.triviabot.server.trivia.TriviaHandler;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.registries.MobRegistry;
import net.mat0u5.lifeseries.seasons.season.nicelife.NiceLifeVotingManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.trivia.TriviaQuestion;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.trivia.TriviaQuestionManager;
import net.mat0u5.lifeseries.seasons.session.SessionTranscript;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.mat0u5.lifeseries.utils.other.IdentifierHelper;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.other.Tuple;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.world.DatapackIntegration;
import net.mat0u5.lifeseries.utils.world.LevelUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;

public class NiceLifeTriviaManager {
    public static Map<UUID, TriviaBot> bots = new HashMap<UUID, TriviaBot>();
    public static TriviaQuestionManager triviaQuestions;
    private static List<String> usedQuestions;
    public static boolean triviaInProgress;
    public static boolean firstTriviaInSession;
    public static TriviaQuestion currentQuestion;
    public static Random rnd;
    public static int QUESTION_TIME;
    public static boolean CAN_BREAK_BEDS;
    public static boolean BREAKING_DROPS_RESOURCES;
    public static List<TriviaSpawn> triviaSpawns;
    public static List<UUID> triviaPlayersUUID;
    public static boolean preparingForSpawn;
    public static List<UUID> correctAnswers;
    public static List<UUID> incorrectAnswers;
    public static TriviaQuestion preAssignedTrivia;

    public static void initialize() {
        triviaQuestions = new TriviaQuestionManager("./config/lifeseries/nicelife", "trivia.json");
    }

    public static void startTrivia(List<class_3222> triviaPlayers) {
        triviaPlayersUUID.clear();
        for (class_3222 player : triviaPlayers) {
            triviaPlayersUUID.add(player.method_5667());
        }
        correctAnswers.clear();
        incorrectAnswers.clear();
        if (CompatibilityManager.voicechatLoaded()) {
            VoicechatMain.niceLifeTriviaStart(triviaPlayers);
        }
        NetworkHandlerServer.sendUpdatePackets();
        triviaInProgress = true;
        NiceLifeTriviaManager.killAllBots();
        usedQuestions.clear();
        NiceLifeVotingManager.reset();
        NiceLifeTriviaManager.initialize();
        triviaSpawns.clear();
        currentQuestion = NiceLifeTriviaManager.getQuestion();
        NiceLifeVotingManager.chooseVote();
        for (class_3222 player : triviaPlayers) {
            class_2338 newPos;
            class_2338 frontBedPos;
            class_3218 level;
            class_2680 bedState;
            NetworkHandlerServer.sendStringPacket(player, PacketNames.HIDE_SLEEP_DARKNESS, "true");
            NetworkHandlerServer.sendStringPacket(player, PacketNames.EMPTY_SCREEN, "true");
            class_2338 bedPos = player.method_18398().orElse(null);
            if (bedPos == null || !((bedState = (level = player.ls$getServerLevel()).method_8320(bedPos)).method_26204() instanceof class_2244)) continue;
            class_2350 bedDirection = class_2244.method_24163((class_2680)bedState);
            class_2338 headPos = bedPos.method_10093(bedDirection);
            class_2338 spawnBotPos = frontBedPos = headPos.method_10093(bedDirection);
            int maxDistance = 7 - rnd.nextInt(firstTriviaInSession ? 3 : 5);
            for (int i = 0; i <= maxDistance && level.method_8320((newPos = frontBedPos.method_10079(bedDirection, i)).method_10074()).method_26206((class_1922)level, newPos, class_2350.field_11036); ++i) {
                spawnBotPos = newPos;
            }
            triviaSpawns.add(new TriviaSpawn(player.method_5667(), spawnBotPos, frontBedPos, bedDirection));
        }
        preparingForSpawn = true;
        if (firstTriviaInSession) {
            sound = class_3414.method_47908((class_2960)IdentifierHelper.vanilla("nicelife_santabot_introduction_long"));
            PlayerUtils.playSoundToPlayers(triviaPlayers, sound, 1.0f, 1.0f);
            for (TriviaSpawn triviaSpawnInfo : triviaSpawns) {
                int botSpawnHeight = 20;
                NiceLifeTriviaManager.breakBotSpawnBlocks(triviaSpawnInfo, 456, botSpawnHeight);
                TaskScheduler.scheduleTask(456, () -> NiceLifeTriviaManager.spawnTriviaBots(triviaSpawnInfo, 160, botSpawnHeight));
            }
        } else {
            sound = class_3414.method_47908((class_2960)IdentifierHelper.vanilla("nicelife_santabot_introduction_short"));
            PlayerUtils.playSoundToPlayers(triviaPlayers, sound, 1.0f, 1.0f);
            for (TriviaSpawn triviaSpawnInfo : triviaSpawns) {
                int botSpawnHeight = rnd.nextInt(15, 30);
                NiceLifeTriviaManager.breakBotSpawnBlocks(triviaSpawnInfo, 71, botSpawnHeight);
                TaskScheduler.scheduleTask(71, () -> NiceLifeTriviaManager.spawnTriviaBots(triviaSpawnInfo, 0, botSpawnHeight));
            }
        }
        firstTriviaInSession = false;
    }

    public static void endTrivia() {
        NiceLifeTriviaManager.killAllBots();
        triviaInProgress = false;
        if (correctAnswers.isEmpty() && incorrectAnswers.isEmpty()) {
            return;
        }
        if (correctAnswers.isEmpty()) {
            TaskScheduler.scheduleTask(100, NiceLifeTriviaManager::allWrong);
        } else {
            NiceLifeVotingManager.endTriviaVoting();
        }
        if (CompatibilityManager.voicechatLoaded()) {
            VoicechatMain.niceLifeTick();
        }
    }

    public static void allWrong() {
        class_3414 sound = class_3414.method_47908((class_2960)IdentifierHelper.vanilla("nicelife_santabot_incorrect_all_wrong"));
        PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), sound, 1.0f, 1.0f);
        PlayerUtils.broadcastMessage((class_2561)class_2561.method_43470((String)"\u00a7f<\u00a72\u00a7mTrivia\u00a7m\u00a72 Santa Bot\u00a7f>\u00a74 WRONG! WRONG! WRONG! ALL WRONG!"));
        NetworkHandlerServer.sendStringPackets(PacketNames.TRIVIA_ALL_WRONG, "");
        TaskScheduler.scheduleTask(120, () -> {
            PlayerUtils.broadcastMessage((class_2561)class_2561.method_43470((String)"\u00a7f<\u00a72\u00a7mTrivia\u00a7m\u00a72 Santa Bot\u00a7f>\u00a74 SNOW MUST GO ON!"));
            for (class_3222 player : Main.livesManager.getAlivePlayers()) {
                for (int i = 0; i < 3; ++i) {
                    class_2338 pos = LevelUtils.getCloseBlockPos((class_1937)player.ls$getServerLevel(), player.method_24515(), 8.0, 2, true);
                    AngrySnowman snowman = LevelUtils.spawnEntity(MobRegistry.ANGRY_SNOWMAN, player.ls$getServerLevel(), pos);
                    if (snowman == null) continue;
                    snowman.method_6642(false);
                }
            }
        });
    }

    public static void breakBotSpawnBlocks(TriviaSpawn triviaSpawnInfo, int overTicks, int botSpawnHeight) {
        class_3222 player = PlayerUtils.getPlayer(triviaSpawnInfo.uuid());
        if (player == null) {
            return;
        }
        class_2338 spawnBotPos = triviaSpawnInfo.spawnPos().method_10069(0, botSpawnHeight, 0);
        class_3218 level = player.ls$getServerLevel();
        int maxY = level.method_31600();
        ArrayList<Integer> breakYPositions = new ArrayList<Integer>();
        for (int breakY = spawnBotPos.method_10264(); breakY < maxY; ++breakY) {
            class_2338 breakBlockPos = spawnBotPos.method_33096(breakY);
            class_2338 aboveBreakBlockPos = breakBlockPos.method_10084();
            breakYPositions.add(breakY);
            if (!level.method_8320(breakBlockPos).method_26215() || !level.method_8320(aboveBreakBlockPos).method_26215()) continue;
            breakYPositions.add(breakY + 1);
            break;
        }
        Collections.reverse(breakYPositions);
        double delay = 0.0;
        double step = (double)overTicks / (double)breakYPositions.size();
        Iterator iterator = breakYPositions.iterator();
        while (iterator.hasNext()) {
            int yPos = (Integer)iterator.next();
            class_2338 breakBlockPos = spawnBotPos.method_33096(yPos);
            TaskScheduler.scheduleTask((int)delay, () -> NiceLifeTriviaManager.breakBlocksAround(level, breakBlockPos, triviaSpawnInfo.bedPos.method_10264()));
            delay += step;
        }
    }

    public static void spawnTriviaBots(TriviaSpawn triviaSpawnInfo, int soundDelay, int botSpawnHeight) {
        class_3222 player = PlayerUtils.getPlayer(triviaSpawnInfo.uuid());
        if (player == null) {
            return;
        }
        class_2338 spawnBotPos = triviaSpawnInfo.spawnPos().method_10069(0, botSpawnHeight, 0);
        TriviaBot bot = LevelUtils.spawnEntity(MobRegistry.TRIVIA_BOT, player.ls$getServerLevel(), spawnBotPos);
        if (bot != null) {
            bot.sounds.delay = soundDelay;
            SessionTranscript.newTriviaBot(player);
            bot.serverData.setBoundPlayer(player);
            bots.put(player.method_5667(), bot);
            DatapackIntegration.EVENT_TRIVIA_BOT_SPAWN.trigger(List.of(new DatapackIntegration.Events.MacroEntry("Player", player.method_5820()), new DatapackIntegration.Events.MacroEntry("TriviaBot", bot.method_5845())));
            TriviaHandler triviaHandler = bot.triviaHandler;
            if (triviaHandler instanceof NiceLifeTriviaHandler) {
                NiceLifeTriviaHandler triviaHandler2 = (NiceLifeTriviaHandler)triviaHandler;
                triviaHandler2.spawnInfo = triviaSpawnInfo;
            }
        }
        preparingForSpawn = false;
    }

    public static void breakBlocksAround(class_3218 level, class_2338 pos, int bedYPos) {
        for (int dirX = -1; dirX <= 1; ++dirX) {
            for (int dirZ = -1; dirZ <= 1; ++dirZ) {
                class_2338 breakBlockPos = pos.method_10069(dirX, 0, dirZ);
                if ((breakBlockPos.method_10264() <= bedYPos || !CAN_BREAK_BEDS) && level.method_8320(breakBlockPos).method_26204() instanceof class_2244 || level.method_8320(breakBlockPos).method_26204().method_36555() == -1.0f) continue;
                level.method_22352(breakBlockPos, BREAKING_DROPS_RESOURCES);
            }
        }
    }

    public static void sessionStart() {
        firstTriviaInSession = true;
        NiceLifeTriviaManager.killAllBots();
        triviaInProgress = false;
    }

    public static void sessionEnd() {
        NiceLifeTriviaManager.killAllBots();
        triviaInProgress = false;
    }

    public static void killAllBots() {
        NetworkHandlerServer.sendStringPackets(PacketNames.STOP_TRIVIA_SOUNDS, "");
        if (Main.server == null) {
            return;
        }
        ArrayList<class_1297> toKill = new ArrayList<class_1297>();
        for (class_3218 level : Main.server.method_3738()) {
            for (class_1297 entity : level.method_27909()) {
                if (!(entity instanceof TriviaBot)) continue;
                toKill.add(entity);
            }
        }
        toKill.forEach(class_1297::method_31472);
        for (class_3222 player : PlayerUtils.getAllPlayers()) {
            NetworkHandlerServer.sendStringPacket(player, PacketNames.RESET_TRIVIA, "true");
        }
    }

    public static void killAllSnowmen() {
        if (Main.server == null) {
            return;
        }
        ArrayList<class_1297> toKill = new ArrayList<class_1297>();
        for (class_3218 level : Main.server.method_3738()) {
            for (class_1297 entity : level.method_27909()) {
                if (!(entity instanceof AngrySnowman)) continue;
                toKill.add(entity);
            }
        }
        toKill.forEach(class_1297::method_31472);
    }

    public static void handleAnswer(class_3222 player, int answer) {
        TriviaBot bot;
        if (bots.containsKey(player.method_5667()) && (bot = bots.get(player.method_5667())).method_5805()) {
            bot.triviaHandler.handleAnswer(answer);
        }
    }

    public static Tuple<Integer, TriviaQuestion> getTriviaQuestion(class_3222 player) {
        return new Tuple<Integer, TriviaQuestion>(1, currentQuestion);
    }

    public static TriviaQuestion getQuestion() {
        if (preAssignedTrivia != null) {
            TriviaQuestion returnQuestion = preAssignedTrivia;
            preAssignedTrivia = null;
            return returnQuestion;
        }
        try {
            if (triviaQuestions == null) {
                NiceLifeTriviaManager.initialize();
            }
            List<Object> unusedQuestions = new ArrayList();
            for (TriviaQuestion trivia : triviaQuestions.getTriviaQuestions()) {
                if (usedQuestions.contains(trivia.getQuestion())) continue;
                unusedQuestions.add(trivia);
            }
            if (unusedQuestions.isEmpty()) {
                usedQuestions.clear();
                unusedQuestions = triviaQuestions.getTriviaQuestions();
            }
            if (unusedQuestions.isEmpty()) {
                return TriviaQuestion.getDefault();
            }
            TriviaQuestion result = (TriviaQuestion)unusedQuestions.get(rnd.nextInt(unusedQuestions.size()));
            usedQuestions.add(result.getQuestion());
            return result;
        }
        catch (Exception exception) {
            return TriviaQuestion.getDefault();
        }
    }

    static {
        usedQuestions = new ArrayList<String>();
        triviaInProgress = false;
        firstTriviaInSession = true;
        currentQuestion = TriviaQuestion.getDefault();
        rnd = new Random();
        QUESTION_TIME = 68;
        CAN_BREAK_BEDS = true;
        BREAKING_DROPS_RESOURCES = true;
        triviaSpawns = new ArrayList<TriviaSpawn>();
        triviaPlayersUUID = new ArrayList<UUID>();
        preparingForSpawn = false;
        correctAnswers = new ArrayList<UUID>();
        incorrectAnswers = new ArrayList<UUID>();
        preAssignedTrivia = null;
    }

    public record TriviaSpawn(UUID uuid, class_2338 spawnPos, class_2338 bedPos, class_2350 bedDirection) {
    }
}

