/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.nicelife;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.entity.triviabot.TriviaBot;
import net.mat0u5.lifeseries.entity.triviabot.server.trivia.NiceLifeTriviaHandler;
import net.mat0u5.lifeseries.entity.triviabot.server.trivia.TriviaHandler;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.seasons.season.nicelife.NiceLife;
import net.mat0u5.lifeseries.seasons.season.nicelife.NiceLifeTriviaManager;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.mat0u5.lifeseries.utils.other.IdentifierHelper;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.other.Time;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.player.TeamUtils;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5250;

public class NiceLifeVotingManager {
    public static Random rnd = new Random();
    public static VoteType voteType = VoteType.NAUGHTY_LIST;
    public static double NICE_LIST_CHANCE = 0.5;
    public static Time VOTING_TIME = Time.seconds(60);
    public static boolean REDS_ON_NAUGHTY_LIST = false;
    public static List<UUID> allowedToVote = new ArrayList<UUID>();
    public static List<UUID> playersVoted = new ArrayList<UUID>();
    public static Map<UUID, Integer> votesByCount = new HashMap<UUID, Integer>();
    public static Map<UUID, UUID> votesByPerson = new HashMap<UUID, UUID>();
    public static int NICE_LIST_COUNT = 3;
    public static int NAUGHTY_LIST_COUNT = 3;
    public static List<UUID> niceListMembers = new ArrayList<UUID>();
    public static List<UUID> naughtyListMembers = new ArrayList<UUID>();
    public static String NAUGHTY_LIST_TEAM = "naughty_list";
    public static String NAUGHTY_LIST_TEAM_NAME = "Naughty List";
    public static String NICE_LIST_TEAM = "nice_list";
    public static String NICE_LIST_TEAM_NAME = "Nice List";
    public static Optional<VoteType> forcedTriviaVote = Optional.empty();

    public static void createTeams() {
        TeamUtils.createTeam(NAUGHTY_LIST_TEAM, NAUGHTY_LIST_TEAM_NAME, class_124.field_1064);
        TeamUtils.createTeam(NICE_LIST_TEAM, NICE_LIST_TEAM_NAME, class_124.field_1076);
    }

    public static void reset() {
        allowedToVote.clear();
        playersVoted.clear();
        votesByCount.clear();
        votesByPerson.clear();
        voteType = VoteType.NONE;
    }

    public static void chooseVote() {
        if (forcedTriviaVote.isPresent()) {
            voteType = forcedTriviaVote.get();
            forcedTriviaVote = Optional.empty();
            return;
        }
        voteType = VoteType.NICE_LIST;
        if (rnd.nextDouble() > NICE_LIST_CHANCE) {
            voteType = VoteType.NONE;
            if (Main.livesManager.anyPlayersAtLeastLives(2) || REDS_ON_NAUGHTY_LIST) {
                voteType = VoteType.NAUGHTY_LIST;
            }
        }
    }

    public static void handleVote(class_3222 player, String vote) {
        if (NiceLifeTriviaManager.triviaInProgress) {
            if (voteType == VoteType.NICE_LIST || voteType == VoteType.NAUGHTY_LIST) {
                NiceLifeVotingManager.handleTriviaVote(player, vote);
            }
        } else if (voteType == VoteType.NICE_LIST_LIFE) {
            NiceLifeVotingManager.handleNiceListLifeVote(player, vote);
        }
    }

    public static void handleTriviaVote(class_3222 player, String vote) {
        if (player == null) {
            return;
        }
        if (voteType == VoteType.NONE) {
            return;
        }
        TriviaBot bot = NiceLifeTriviaManager.bots.get(player.method_5667());
        if (bot == null) {
            return;
        }
        if (!bot.method_5805()) {
            return;
        }
        TriviaHandler triviaHandler = bot.triviaHandler;
        if (!(triviaHandler instanceof NiceLifeTriviaHandler)) {
            return;
        }
        NiceLifeTriviaHandler triviaHandler2 = (NiceLifeTriviaHandler)triviaHandler;
        if (triviaHandler2.currentState != NiceLifeTriviaHandler.BotState.VOTING) {
            return;
        }
        triviaHandler2.changeStateTo(NiceLifeTriviaHandler.BotState.LEAVING);
        if (!player.method_6113()) {
            return;
        }
        if (player.ls$isDead()) {
            return;
        }
        if (!allowedToVote.contains(player.method_5667())) {
            return;
        }
        if (playersVoted.contains(player.method_5667())) {
            return;
        }
        if (vote.isEmpty()) {
            return;
        }
        class_3222 votedFor = PlayerUtils.getPlayer(vote);
        if (votedFor == null) {
            return;
        }
        if (votedFor.ls$isDead()) {
            return;
        }
        if (voteType == VoteType.NAUGHTY_LIST && votedFor.ls$isOnSpecificLives(1, true) && !REDS_ON_NAUGHTY_LIST) {
            return;
        }
        if (voteType == VoteType.NICE_LIST && player == votedFor) {
            return;
        }
        playersVoted.add(player.method_5667());
        if (!votesByCount.containsKey(votedFor.method_5667())) {
            votesByCount.put(votedFor.method_5667(), 0);
        }
        votesByCount.put(votedFor.method_5667(), votesByCount.get(votedFor.method_5667()) + 1);
        votesByPerson.put(player.method_5667(), votedFor.method_5667());
    }

    public static List<UUID> getMostVotedForPlayers(int count) {
        HashMap<Integer, List> voteGroups = new HashMap<Integer, List>();
        for (Map.Entry<UUID, Integer> entry : votesByCount.entrySet()) {
            voteGroups.computeIfAbsent(entry.getValue(), k -> new ArrayList()).add(entry.getKey());
        }
        ArrayList sortedVoteCounts = new ArrayList(voteGroups.keySet());
        sortedVoteCounts.sort(Collections.reverseOrder());
        ArrayList<UUID> result = new ArrayList<UUID>();
        Random random = new Random();
        Iterator iterator = sortedVoteCounts.iterator();
        while (iterator.hasNext()) {
            int voteCount = (Integer)iterator.next();
            ArrayList group = new ArrayList((Collection)voteGroups.get(voteCount));
            if (result.size() + group.size() > count) {
                Collections.shuffle(group, random);
                int remaining = count - result.size();
                result.addAll(group.subList(0, remaining));
                break;
            }
            result.addAll(group);
            if (result.size() < count) continue;
            break;
        }
        return result;
    }

    public static void endTriviaVoting() {
        if (voteType == VoteType.NAUGHTY_LIST) {
            NiceLifeVotingManager.announceNaughtyList();
        }
        if (voteType == VoteType.NICE_LIST) {
            NiceLifeVotingManager.announceNiceList();
        }
        Main.currentSeason.reloadAllPlayerTeams();
        NiceLifeVotingManager.reset();
    }

    public static void endListsIfNecessary() {
        if (!naughtyListMembers.isEmpty()) {
            NiceLifeVotingManager.endNaughtyList();
        }
        if (!niceListMembers.isEmpty()) {
            NiceLifeVotingManager.endNiceList();
        }
    }

    public static void announceNaughtyList() {
        List<UUID> players = NiceLifeVotingManager.getMostVotedForPlayers(NAUGHTY_LIST_COUNT);
        naughtyListMembers.clear();
        if (players.isEmpty()) {
            return;
        }
        int delay = 80;
        TaskScheduler.scheduleTask(delay, () -> {
            class_3414 sound = class_3414.method_47908((class_2960)IdentifierHelper.vanilla("nicelife_vote_result"));
            PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), sound, 1.0f, 1.0f);
            PlayerUtils.sendTitleToPlayers(PlayerUtils.getAllPlayers(), (class_2561)class_2561.method_43470((String)"\u00a7cThese players are on..."), 15, 80, 20);
        });
        TaskScheduler.scheduleTask(delay += 90, () -> {
            class_3414 sound = class_3414.method_47908((class_2960)IdentifierHelper.vanilla("nicelife_naughtylist"));
            PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), sound, 1.0f, 1.0f);
            PlayerUtils.sendTitleToPlayers(PlayerUtils.getAllPlayers(), (class_2561)class_2561.method_43470((String)"\u00a7cTHE NAUGHTY LIST"), 15, 80, 20);
        });
        delay += 80;
        for (UUID uuid : players) {
            class_3222 player = PlayerUtils.getPlayer(uuid);
            if (player == null || player.ls$isDead()) continue;
            TaskScheduler.scheduleTask(delay, () -> {
                if (player != null) {
                    class_3414 sound = class_3414.method_47908((class_2960)IdentifierHelper.vanilla("nicelife_naughtylist"));
                    PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), sound, 1.0f, 1.0f);
                    naughtyListMembers.add(uuid);
                    Main.currentSeason.reloadPlayerTeam(player);
                    PlayerUtils.sendTitleToPlayers(PlayerUtils.getAllPlayers(), PlayerUtils.getPlayerNameWithIcon(player), 15, 80, 20);
                }
            });
            delay += 55;
        }
        TaskScheduler.scheduleTask(delay += 55, () -> {
            PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), (class_3414)class_3417.field_14793.comp_349(), 1.0f, 1.0f);
            PlayerUtils.broadcastMessage((class_2561)TextUtils.formatLoosely("\n \u00a76[\u00a7e!\u00a76]\u00a77 You have voted for {} {} to be on the \u00a7cNAUGHTY LIST\u00a77.\n", players.size(), TextUtils.pluralize("person", "people", players.size())));
        });
        TaskScheduler.scheduleTask(delay += 110, () -> {
            PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), (class_3414)class_3417.field_14793.comp_349(), 1.0f, 1.0f);
            PlayerUtils.broadcastMessage((class_2561)class_2561.method_43470((String)" \u00a76[\u00a7e!\u00a76]\u00a77 People on the \u00a7cnaughty list\u00a77 have a purple name and can be killed.\n"));
        });
        TaskScheduler.scheduleTask(delay += 110, () -> {
            PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), (class_3414)class_3417.field_14793.comp_349(), 1.0f, 1.0f);
            PlayerUtils.broadcastMessage((class_2561)class_2561.method_43470((String)" \u00a76[\u00a7e!\u00a76]\u00a77 They return to their previous colour at sunset. They can defend themselves.\n"));
        });
    }

    public static void announceNiceList() {
        List<UUID> players = NiceLifeVotingManager.getMostVotedForPlayers(NICE_LIST_COUNT);
        niceListMembers.clear();
        if (players.isEmpty()) {
            return;
        }
        int delay = 80;
        TaskScheduler.scheduleTask(delay, () -> {
            class_3414 sound = class_3414.method_47908((class_2960)IdentifierHelper.vanilla("nicelife_vote_result"));
            PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), sound, 1.0f, 1.0f);
            PlayerUtils.sendTitleToPlayers(PlayerUtils.getAllPlayers(), (class_2561)class_2561.method_43470((String)"\u00a7aThese players are on..."), 15, 80, 20);
        });
        TaskScheduler.scheduleTask(delay += 90, () -> {
            class_3414 sound = class_3414.method_47908((class_2960)IdentifierHelper.vanilla("nicelife_nicelist_start"));
            PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), sound, 1.0f, 1.0f);
            PlayerUtils.sendTitleToPlayers(PlayerUtils.getAllPlayers(), (class_2561)class_2561.method_43470((String)"\u00a7aTHE NICE LIST"), 15, 80, 20);
        });
        delay += 80;
        for (UUID uuid : players) {
            class_3222 player = PlayerUtils.getPlayer(uuid);
            if (player == null || player.ls$isDead()) continue;
            TaskScheduler.scheduleTask(delay, () -> {
                if (player != null) {
                    class_3414 sound = class_3414.method_47908((class_2960)IdentifierHelper.vanilla("nicelife_nicelist_person"));
                    PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), sound, 1.0f, 1.0f);
                    niceListMembers.add(uuid);
                    Main.currentSeason.reloadPlayerTeam(player);
                    PlayerUtils.sendTitleToPlayers(PlayerUtils.getAllPlayers(), PlayerUtils.getPlayerNameWithIcon(player), 15, 80, 20);
                }
            });
            delay += 55;
        }
        TaskScheduler.scheduleTask(delay += 55, () -> {
            PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), (class_3414)class_3417.field_14793.comp_349(), 1.0f, 1.0f);
            PlayerUtils.broadcastMessage((class_2561)class_2561.method_43470((String)"\n \u00a76[\u00a7e!\u00a76]\u00a77 At sunset, players on the nice list will vote to give a \u00a72non-pink\u00a77 name a life.\n"));
        });
        TaskScheduler.scheduleTask(delay += 110, () -> {
            PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), (class_3414)class_3417.field_14793.comp_349(), 1.0f, 1.0f);
            PlayerUtils.broadcastMessage((class_2561)class_2561.method_43470((String)" \u00a76[\u00a7e!\u00a76]\u00a77 The majority of the \u00a7dpinks\u00a77 must vote for the same player for the life to be given.\n"));
        });
        TaskScheduler.scheduleTask(delay += 110, () -> {
            PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), (class_3414)class_3417.field_14793.comp_349(), 1.0f, 1.0f);
            PlayerUtils.broadcastMessage((class_2561)class_2561.method_43470((String)" \u00a76[\u00a7e!\u00a76]\u00a77 Pink names are not allowed to be targeted by any other players, including \u00a7creds\u00a77.\n"));
        });
        ArrayList<class_3222> niceListPlayers = new ArrayList<class_3222>();
        for (UUID uuid : players) {
            allowedToVote.add(uuid);
            class_3222 player = PlayerUtils.getPlayer(uuid);
            if (player == null) continue;
            niceListPlayers.add(player);
        }
        TaskScheduler.scheduleTask(delay += 150, () -> {
            voteType = VoteType.NICE_LIST_LIFE;
            PlayerUtils.playSoundToPlayers(niceListPlayers, (class_3414)class_3417.field_14793.comp_349(), 1.0f, 1.0f);
            PlayerUtils.broadcastMessage(niceListPlayers, (class_2561)TextUtils.format(" \u00a76[\u00a7e!\u00a76]\u00a77 You are on the nice list. Type {}\u00a77 to choose who you would like to give a life to.\n", TextUtils.clickableText("\u00a7f\u00a7l/vote", TextUtils.runCommandClickEvent("/vote"))));
        });
        TaskScheduler.scheduleTask(delay += 110, () -> {
            voteType = VoteType.NICE_LIST_LIFE;
            PlayerUtils.playSoundToPlayers(niceListPlayers, (class_3414)class_3417.field_14793.comp_349(), 1.0f, 1.0f);
            PlayerUtils.broadcastMessage(niceListPlayers, (class_2561)class_2561.method_43470((String)" \u00a76[\u00a7e!\u00a76]\u00a77 You can change your vote at anytime, but the results will be locked in at sunset.\n"));
        });
    }

    public static void endNaughtyList() {
        class_3414 voteSound = class_3414.method_47908((class_2960)IdentifierHelper.vanilla("nicelife_vote_result"));
        PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), voteSound, 1.0f, 1.0f);
        PlayerUtils.sendTitleToPlayers(PlayerUtils.getAllPlayers(), (class_2561)class_2561.method_43470((String)"\u00a7cPlayers return to normal in..."), 15, 80, 20);
        int delay = 95;
        TaskScheduler.scheduleTask(delay, () -> {
            class_3414 sound = class_3414.method_47908((class_2960)IdentifierHelper.vanilla("nicelife_nicelist_countdown_3"));
            PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), sound, 1.0f, 1.0f);
            PlayerUtils.sendTitleToPlayers(PlayerUtils.getAllPlayers(), (class_2561)class_2561.method_43470((String)"\u00a723.."), 15, 25, 15);
        });
        TaskScheduler.scheduleTask(delay += 40, () -> {
            class_3414 sound = class_3414.method_47908((class_2960)IdentifierHelper.vanilla("nicelife_nicelist_countdown_2"));
            PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), sound, 1.0f, 1.0f);
            PlayerUtils.sendTitleToPlayers(PlayerUtils.getAllPlayers(), (class_2561)class_2561.method_43470((String)"\u00a7e2.."), 15, 25, 15);
        });
        TaskScheduler.scheduleTask(delay += 40, () -> {
            class_3414 sound = class_3414.method_47908((class_2960)IdentifierHelper.vanilla("nicelife_nicelist_countdown_1"));
            PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), sound, 1.0f, 1.0f);
            PlayerUtils.sendTitleToPlayers(PlayerUtils.getAllPlayers(), (class_2561)class_2561.method_43470((String)"\u00a7c1.."), 15, 25, 15);
        });
        TaskScheduler.scheduleTask(delay += 55, () -> {
            PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), class_3417.field_15219, 1.0f, 1.0f);
            naughtyListMembers.clear();
            Main.currentSeason.reloadAllPlayerTeams();
        });
        NiceLife.postponeTriviaStart(Time.ticks(delay + 20));
    }

    public static void endNiceList() {
        class_3414 voteSound = class_3414.method_47908((class_2960)IdentifierHelper.vanilla("nicelife_nicelist_end"));
        PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), voteSound, 1.0f, 1.0f);
        PlayerUtils.sendTitleToPlayers(PlayerUtils.getAllPlayers(), (class_2561)class_2561.method_43470((String)"\u00a7cThe nice vote will end in..."), 15, 80, 20);
        int delay = 95;
        TaskScheduler.scheduleTask(delay, () -> {
            class_3414 sound = class_3414.method_47908((class_2960)IdentifierHelper.vanilla("nicelife_nicelist_countdown_3"));
            PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), sound, 1.0f, 1.0f);
            PlayerUtils.sendTitleToPlayers(PlayerUtils.getAllPlayers(), (class_2561)class_2561.method_43470((String)"\u00a723.."), 15, 25, 15);
        });
        TaskScheduler.scheduleTask(delay += 40, () -> {
            class_3414 sound = class_3414.method_47908((class_2960)IdentifierHelper.vanilla("nicelife_nicelist_countdown_2"));
            PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), sound, 1.0f, 1.0f);
            PlayerUtils.sendTitleToPlayers(PlayerUtils.getAllPlayers(), (class_2561)class_2561.method_43470((String)"\u00a7e2.."), 15, 25, 15);
        });
        TaskScheduler.scheduleTask(delay += 40, () -> {
            class_3414 sound = class_3414.method_47908((class_2960)IdentifierHelper.vanilla("nicelife_nicelist_countdown_1"));
            PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), sound, 1.0f, 1.0f);
            PlayerUtils.sendTitleToPlayers(PlayerUtils.getAllPlayers(), (class_2561)class_2561.method_43470((String)"\u00a7c1.."), 15, 25, 15);
        });
        TaskScheduler.scheduleTask(delay += 55, () -> NiceLifeVotingManager.actuallyEndNiceList());
        NiceLife.postponeTriviaStart(Time.ticks(delay + 85));
    }

    public static void actuallyEndNiceList() {
        HashMap<Object, Integer> reloadedVotesByCount = new HashMap<Object, Integer>();
        int availableVotes = 0;
        int validVotes = 0;
        for (UUID uUID : niceListMembers) {
            class_3222 player = PlayerUtils.getPlayer(uUID);
            if (player == null || player.ls$isDead()) continue;
            ++availableVotes;
        }
        for (Map.Entry entry : votesByPerson.entrySet()) {
            UUID votedForUUID = (UUID)entry.getValue();
            class_3222 class_32222 = PlayerUtils.getPlayer((UUID)entry.getKey());
            class_3222 votedFor = PlayerUtils.getPlayer(votedForUUID);
            if (class_32222 == null || votedFor == null || class_32222.ls$isDead() || votedFor.ls$isDead() || !niceListMembers.contains(class_32222.method_5667()) || niceListMembers.contains(votedFor.method_5667())) continue;
            ++validVotes;
            if (!reloadedVotesByCount.containsKey(votedForUUID)) {
                reloadedVotesByCount.put(votedForUUID, 0);
            }
            reloadedVotesByCount.put(votedForUUID, (Integer)reloadedVotesByCount.get(votedForUUID) + 1);
        }
        if (reloadedVotesByCount.isEmpty() || availableVotes == 0 || validVotes == 0) {
            class_3414 sound = class_3414.method_47908((class_2960)IdentifierHelper.vanilla("nicelife_naughtylist"));
            PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), sound, 1.0f, 1.0f);
            PlayerUtils.sendTitleToPlayers(PlayerUtils.getAllPlayers(), (class_2561)class_2561.method_43470((String)"\u00a7cInsufficient votes"), 15, 80, 20);
        } else {
            int n;
            UUID mostVotedFor = (UUID)reloadedVotesByCount.keySet().stream().iterator().next();
            boolean bl = false;
            for (Map.Entry entry : reloadedVotesByCount.entrySet()) {
                UUID vote = (UUID)entry.getKey();
                int votes = (Integer)entry.getValue();
                if (votes <= n) continue;
                mostVotedFor = vote;
                n = votes;
            }
            double requiredVotes = (double)availableVotes / 2.0;
            class_3222 winner = PlayerUtils.getPlayer(mostVotedFor);
            if ((double)n > requiredVotes && winner != null) {
                class_3414 sound = class_3414.method_47908((class_2960)IdentifierHelper.vanilla("nicelife_vote_result"));
                PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), sound, 1.0f, 1.0f);
                PlayerUtils.sendTitleToPlayers(PlayerUtils.getAllPlayers(), (class_2561)class_2561.method_43470((String)"\u00a72The winner is..."), 15, 80, 20);
                TaskScheduler.scheduleTask(85, () -> {
                    winner.ls$addLife();
                    Main.currentSeason.reloadPlayerTeam(winner);
                    PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), class_3417.field_14702, 1.0f, 1.0f);
                    PlayerUtils.sendTitleToPlayers(PlayerUtils.getAllPlayers(), PlayerUtils.getPlayerNameWithIcon(winner), 15, 80, 20);
                });
            } else {
                class_3414 sound = class_3414.method_47908((class_2960)IdentifierHelper.vanilla("nicelife_naughtylist"));
                PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), sound, 1.0f, 1.0f);
                if ((double)validVotes > requiredVotes) {
                    PlayerUtils.sendTitleToPlayers(PlayerUtils.getAllPlayers(), (class_2561)class_2561.method_43470((String)"\u00a7cNo agreement reached"), 15, 80, 20);
                } else {
                    PlayerUtils.sendTitleToPlayers(PlayerUtils.getAllPlayers(), (class_2561)class_2561.method_43470((String)"\u00a7cInsufficient votes"), 15, 80, 20);
                }
            }
        }
        niceListMembers.clear();
        Main.currentSeason.reloadAllPlayerTeams();
        NiceLifeVotingManager.reset();
    }

    public static boolean openNiceListLifeVote(class_3222 player) {
        ArrayList<String> availableForVoting = new ArrayList<String>();
        availableForVoting.add("Vote for who should get a life");
        for (class_3222 availableVotePlayer : Main.livesManager.getAlivePlayers()) {
            if (niceListMembers.contains(availableVotePlayer.method_5667())) continue;
            availableForVoting.add(availableVotePlayer.method_5820());
        }
        if (availableForVoting.size() <= 1) {
            return false;
        }
        NetworkHandlerServer.sendStringListPacket(player, PacketNames.VOTING_SCREEN, availableForVoting);
        return true;
    }

    public static void handleNiceListLifeVote(class_3222 player, String vote) {
        if (voteType != VoteType.NICE_LIST_LIFE) {
            return;
        }
        if (player.ls$isDead()) {
            return;
        }
        if (!niceListMembers.contains(player.method_5667())) {
            return;
        }
        if (vote.isEmpty()) {
            return;
        }
        class_3222 votedFor = PlayerUtils.getPlayer(vote);
        if (votedFor == null) {
            return;
        }
        if (votedFor.ls$isDead()) {
            return;
        }
        if (niceListMembers.contains(votedFor.method_5667())) {
            return;
        }
        PlayerUtils.playSoundToPlayer(player, (class_3414)class_3417.field_14793.comp_349(), 1.0f, 1.0f);
        player.method_43502((class_2561)TextUtils.format("\n \u00a76[\u00a7e!\u00a76]\u00a77 You voted for {}\u00a77.\n", PlayerUtils.getPlayerNameWithIcon(votedFor)), false);
        votesByPerson.put(player.method_5667(), votedFor.method_5667());
    }

    public static void warnNiceListMembers() {
        ArrayList<class_3222> niceListPlayers = new ArrayList<class_3222>();
        for (UUID uuid : niceListMembers) {
            class_3222 player = PlayerUtils.getPlayer(uuid);
            if (player == null) continue;
            niceListPlayers.add(player);
        }
        if (!niceListPlayers.isEmpty()) {
            class_5250 message = TextUtils.format("\n\u00a77Don't forget to {}\u00a77!\n", TextUtils.clickableText("\u00a7f\u00a7l/vote", TextUtils.runCommandClickEvent("/vote")));
            PlayerUtils.playSoundToPlayers(niceListPlayers, (class_3414)class_3417.field_14793.comp_349(), 1.0f, 1.0f);
            PlayerUtils.broadcastMessage(niceListPlayers, (class_2561)message);
            TaskScheduler.scheduleTask(Time.seconds(30), () -> NiceLifeVotingManager.lambda$warnNiceListMembers$0(niceListPlayers, (class_2561)message));
        }
    }

    private static /* synthetic */ void lambda$warnNiceListMembers$0(List niceListPlayers, class_2561 message) {
        PlayerUtils.playSoundToPlayers(niceListPlayers, (class_3414)class_3417.field_14793.comp_349(), 1.0f, 1.0f);
        PlayerUtils.broadcastMessage(niceListPlayers, message);
    }

    public static enum VoteType {
        NICE_LIST,
        NAUGHTY_LIST,
        NICE_LIST_LIFE,
        NONE;

    }
}

