/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.secretlife;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.season.secretlife.TaskTypes;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_9262;

public class Task {
    public String rawTask;
    public TaskTypes type;
    public boolean anyPlayers = true;
    public boolean anyGreenPlayers = true;
    public boolean anyYellowPlayers = true;
    public boolean anyRedPlayers = true;
    public String formattedTask = "";

    public Task(String task, TaskTypes type) {
        this.rawTask = task;
        this.type = type;
    }

    public static boolean anyPlayersOnLives(class_3222 exception, int lives) {
        for (class_3222 player : Main.livesManager.getAlivePlayers()) {
            if (player == exception || !player.ls$isOnSpecificLives(lives, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean anyAlivePlayers(class_3222 exception) {
        for (class_3222 player : Main.livesManager.getAlivePlayers()) {
            if (player == exception) continue;
            return true;
        }
        return false;
    }

    public void checkPlayerColors(class_3222 owner) {
        this.anyGreenPlayers = Task.anyPlayersOnLives(owner, 3);
        this.anyYellowPlayers = Task.anyPlayersOnLives(owner, 2);
        this.anyRedPlayers = Task.anyPlayersOnLives(owner, 1);
        this.anyPlayers = Task.anyAlivePlayers(owner);
    }

    public boolean isValid(class_3222 owner) {
        if (this.rawTask == null) {
            return false;
        }
        if (this.rawTask.isEmpty()) {
            return false;
        }
        this.checkPlayerColors(owner);
        if (this.rawTask.contains("${random_player}") && !this.anyPlayers) {
            return false;
        }
        if (this.rawTask.contains("${green/yellow}") && !this.anyGreenPlayers && !this.anyYellowPlayers) {
            return false;
        }
        if (this.rawTask.contains("${green}") && !this.anyGreenPlayers) {
            return false;
        }
        if (this.rawTask.contains("${yellow}") && !this.anyYellowPlayers) {
            return false;
        }
        return !this.rawTask.contains("${red}") || this.anyRedPlayers;
    }

    public List<class_9262<class_2561>> getBookLines(class_3222 owner) {
        this.formattedTask = "";
        ArrayList<class_9262<class_2561>> lines = new ArrayList<class_9262<class_2561>>();
        int pageNum = 0;
        for (String page : this.rawTask.split("\\\\p")) {
            page = this.formatString(owner, page);
            lines.add((class_9262<class_2561>)class_9262.method_57137((Object)class_2561.method_30163((String)page)));
            if (pageNum != 0) {
                this.formattedTask = this.formattedTask + "\n";
            }
            this.formattedTask = this.formattedTask + page;
            ++pageNum;
        }
        return lines;
    }

    public String formatString(class_3222 owner, String page) {
        this.checkPlayerColors(owner);
        if (page.contains("${random_player}")) {
            List<class_3222> players = Main.livesManager.getAlivePlayers();
            players.remove(owner);
            if (!players.isEmpty()) {
                Collections.shuffle(players);
                page = page.replaceAll("\\$\\{random_player}", players.get(0).method_5820());
            }
        }
        if (page.contains("${green/yellow}")) {
            if (this.anyGreenPlayers) {
                page = page.replaceAll("\\$\\{green/yellow}", "green");
            } else if (this.anyYellowPlayers) {
                page = page.replaceAll("\\$\\{green/yellow}", "yellow");
            }
        }
        if (page.contains("${green}") && this.anyGreenPlayers) {
            page = page.replaceAll("\\$\\{green}", "green");
        }
        if (page.contains("${yellow}") && this.anyYellowPlayers) {
            page = page.replaceAll("\\$\\{yellow}", "yellow");
        }
        if (page.contains("${red}") && this.anyRedPlayers) {
            page = page.replaceAll("\\$\\{red}", "red");
        }
        if (page.contains("${kill_not_permitted}") && this.anyYellowPlayers) {
            page = page.replaceAll("\\$\\{kill_not_permitted}", "");
        }
        return page;
    }

    public int getDifficulty() {
        if (this.type == TaskTypes.EASY) {
            return 1;
        }
        if (this.type == TaskTypes.HARD) {
            return 2;
        }
        if (this.type == TaskTypes.RED) {
            return 3;
        }
        return 0;
    }
}

