/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.wildlife;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.command.manager.Command;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcard;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.WildcardManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcards;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.Callback;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.Hunger;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.snails.SnailSkins;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.snails.Snails;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.Superpower;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.Superpowers;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.SuperpowersWildcard;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class WildLifeCommands
extends Command {
    @Override
    public boolean isAllowed() {
        return Main.currentSeason.getSeason() == Seasons.WILD_LIFE;
    }

    @Override
    public class_2561 getBannedText() {
        return class_2561.method_30163((String)"This command is only available when playing Wild Life.");
    }

    @Override
    public List<String> getAdminCommands() {
        return List.of("wildcard", "snail", "superpower", "hunger");
    }

    @Override
    public List<String> getNonAdminCommands() {
        return List.of("snail");
    }

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)WildLifeCommands.literal("wildcard").requires(PermissionManager::isAdmin)).then(WildLifeCommands.literal("list").executes(context -> this.listWildcards((class_2168)context.getSource())))).then(WildLifeCommands.literal("listActive").executes(context -> this.listActiveWildcards((class_2168)context.getSource())))).then(WildLifeCommands.literal("activate").then(WildLifeCommands.argument("wildcard", StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9265(this.suggestionsActivateWildcard(), (SuggestionsBuilder)builder)).executes(context -> this.activateWildcard((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"wildcard")))))).then(WildLifeCommands.literal("deactivate").then(WildLifeCommands.argument("wildcard", StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9265(this.suggestionsDeactivateWildcard(), (SuggestionsBuilder)builder)).executes(context -> this.deactivateWildcard((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"wildcard")))))).then(((LiteralArgumentBuilder)WildLifeCommands.literal("choose").requires(source -> NetworkHandlerServer.wasHandshakeSuccessful(source.method_44023()) || source.method_9228() == null)).executes(context -> this.chooseWildcard((class_2168)context.getSource())))).then(WildLifeCommands.literal("finale").executes(context -> this.activateFinale((class_2168)context.getSource())))).then(((LiteralArgumentBuilder)WildLifeCommands.literal("effect").then(WildLifeCommands.literal("dots").executes(context -> this.effectDots((class_2168)context.getSource())))).then(WildLifeCommands.literal("makeItWild").executes(context -> this.effectMakeItWild((class_2168)context.getSource())))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)WildLifeCommands.literal("snail").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)WildLifeCommands.literal("names").then(((LiteralArgumentBuilder)WildLifeCommands.literal("set").requires(PermissionManager::isAdmin)).then(WildLifeCommands.argument("player", class_2186.method_9305()).then(WildLifeCommands.argument("name", StringArgumentType.greedyString()).executes(context -> this.setSnailName((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"name"))))))).then(((LiteralArgumentBuilder)WildLifeCommands.literal("reset").requires(PermissionManager::isAdmin)).then(WildLifeCommands.argument("player", class_2186.method_9308()).executes(context -> this.resetSnailName((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player")))))).then(WildLifeCommands.literal("get").then(WildLifeCommands.argument("player", class_2186.method_9308()).executes(context -> this.getSnailNames((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player")))))).then(WildLifeCommands.literal("request").then(WildLifeCommands.argument("name", StringArgumentType.greedyString()).executes(context -> this.requestSnailName((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)WildLifeCommands.literal("textures").requires(PermissionManager::isAdmin)).executes(context -> this.getSnailTexturesInfo((class_2168)context.getSource()))).then(WildLifeCommands.literal("list").executes(context -> this.getSnailTextures((class_2168)context.getSource())))).then(WildLifeCommands.literal("info").executes(context -> this.getSnailTexturesInfo((class_2168)context.getSource())))).then(WildLifeCommands.literal("reload").executes(context -> this.snailTexturesReload((class_2168)context.getSource())))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)WildLifeCommands.literal("superpower").requires(PermissionManager::isAdmin)).then(WildLifeCommands.literal("set").then(WildLifeCommands.argument("player", class_2186.method_9308()).then(WildLifeCommands.argument("superpower", StringArgumentType.string()).suggests((context, builder) -> class_2172.method_9265(Superpowers.getImplementedStr(), (SuggestionsBuilder)builder)).executes(context -> this.setSuperpower((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"superpower"))))))).then(WildLifeCommands.literal("reset").then(WildLifeCommands.argument("player", class_2186.method_9308()).executes(context -> this.resetSuperpowers((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player")))))).then(((LiteralArgumentBuilder)WildLifeCommands.literal("randomize").then(WildLifeCommands.argument("player", class_2186.method_9308()).executes(context -> this.setRandomSuperpowers((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"))))).executes(context -> this.setRandomSuperpowers((class_2168)context.getSource())))).then(WildLifeCommands.literal("get").then(WildLifeCommands.argument("player", class_2186.method_9305()).executes(context -> this.getSuperpower((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player")))))).then(WildLifeCommands.literal("skipCooldown").executes(context -> this.skipSuperpowerCooldown((class_2168)context.getSource())))).then(WildLifeCommands.literal("force").then(((RequiredArgumentBuilder)WildLifeCommands.argument("player", class_2186.method_9308()).then(WildLifeCommands.argument("superpower", StringArgumentType.string()).suggests((context, builder) -> class_2172.method_9265(Superpowers.getImplementedStr(), (SuggestionsBuilder)builder)).executes(context -> this.assignSuperpower((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"superpower"))))).then(WildLifeCommands.literal("reset").executes(context -> this.assignSuperpower((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), null))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)WildLifeCommands.literal("hunger").requires(PermissionManager::isAdmin)).then(WildLifeCommands.literal("randomizeFood").executes(context -> this.randomizeFood((class_2168)context.getSource()))));
    }

    public int effectDots(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        WildcardManager.showDots();
        return 1;
    }

    public int effectMakeItWild(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        Callback.showEndingTitles();
        return 1;
    }

    public int activateFinale(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        WildcardManager.FINALE = true;
        OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"All wildcards will act as if the finale (so the Callback wildcard) was activated."));
        return 1;
    }

    public int randomizeFood(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (!WildcardManager.isActiveWildcard(Wildcards.HUNGER)) {
            source.method_9213(class_2561.method_30163((String)"The Hunger wildcard is not active right now."));
            return -1;
        }
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"\u00a77Randomizing food..."));
        Wildcard wildcard = WildcardManager.activeWildcards.get((Object)Wildcards.HUNGER);
        if (wildcard instanceof Hunger) {
            Hunger hungerWildcard = (Hunger)wildcard;
            hungerWildcard.newFoodRules();
        }
        return 1;
    }

    public int requestSnailName(class_2168 source, String name) {
        if (this.checkBanned(source)) {
            return -1;
        }
        class_3222 player = source.method_44023();
        if (player == null) {
            return -1;
        }
        PlayerUtils.broadcastMessageToAdmins((class_2561)TextUtils.format("{}\u00a77 requests their snail name to be \u00a7f{}\u00a77", player, name));
        class_5250 adminText = TextUtils.format("\u00a77Click {}\u00a77 to accept.", TextUtils.runCommandText(TextUtils.formatString("/snail names set {} {}", player, name)));
        PlayerUtils.broadcastMessageToAdmins((class_2561)adminText);
        return 1;
    }

    public int snailTexturesReload(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        class_3222 player = source.method_44023();
        if (player == null) {
            return -1;
        }
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"\u00a77Reloading snail textures..."));
        SnailSkins.sendTextures();
        return 1;
    }

    public int getSnailTexturesInfo(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        class_3222 player = source.method_44023();
        if (player == null) {
            return -1;
        }
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.formatLoosely("\u00a7fClick {}\u00a7f to open the Snail Textures info page in the Wiki.", TextUtils.openURLText("mat0u5.github.io/LifeSeries-docs/config/wild-life-snails")));
        return 1;
    }

    public int getSnailTextures(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        List<String> textures = SnailSkins.getAllSkins();
        if (textures.isEmpty()) {
            OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"\u00a77No snail skins have been added yet. Run '\u00a7f/snail textures info\u00a77' to learn how to add them."));
            return -1;
        }
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("\u00a77The following skins have been found: \u00a7f{}", textures));
        return 1;
    }

    public int chooseWildcard(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (source.method_44023() == null) {
            return -1;
        }
        if (!NetworkHandlerServer.wasHandshakeSuccessful(source.method_44023())) {
            source.method_9213(class_2561.method_30163((String)"You must have the Life Series mod installed \u00a7nclient-side\u00a7c to open the wildcard GUI"));
            return -1;
        }
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"\u00a77Opening the Wildcard selection GUI..."));
        NetworkHandlerServer.sendStringPacket(source.method_44023(), PacketNames.SELECT_WILDCARDS, "true");
        return 1;
    }

    public List<String> suggestionsDeactivateWildcard() {
        List<String> allWildcards = Wildcards.getActiveWildcardsStr();
        allWildcards.add("*");
        return allWildcards;
    }

    public List<String> suggestionsActivateWildcard() {
        List<String> allWildcards = Wildcards.getInactiveWildcardsStr();
        allWildcards.add("*");
        return allWildcards;
    }

    public int assignSuperpower(class_2168 source, Collection<class_3222> targets, String name) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (targets == null || targets.isEmpty()) {
            return -1;
        }
        if (name == null) {
            for (class_3222 player : targets) {
                SuperpowersWildcard.preAssignedSuperpowers.remove(player.method_5667());
            }
            if (targets.size() == 1) {
                OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Reset {}'s superpower assignment", targets.iterator().next()));
            } else {
                OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Reset the superpower assignment of {} targets", targets.size()));
            }
            return 1;
        }
        if (!Superpowers.getImplementedStr().contains(name)) {
            source.method_9213(class_2561.method_30163((String)"That superpower doesn't exist"));
            return -1;
        }
        Superpowers superpower = Superpowers.fromString(name);
        if (superpower == Superpowers.NULL) {
            source.method_9213(class_2561.method_30163((String)"That superpower doesn't exist"));
            return -1;
        }
        for (class_3222 player : targets) {
            SuperpowersWildcard.preAssignedSuperpowers.put(player.method_5667(), superpower);
        }
        if (targets.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Forced {}'s superpower to be {} when the next superpower randomization happens", targets.iterator().next(), name));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Forced the superpower of {} targets to be {} when the next superpower randomization happens", targets.size(), name));
        }
        return 1;
    }

    public int skipSuperpowerCooldown(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        class_3222 player = source.method_44023();
        if (player == null) {
            return -1;
        }
        Superpower superpower = SuperpowersWildcard.getSuperpowerInstance(player);
        if (superpower == null) {
            source.method_9213(class_2561.method_30163((String)"You do not have an active superpower"));
            return -1;
        }
        superpower.cooldown = 0L;
        NetworkHandlerServer.sendLongPacket(player, PacketNames.SUPERPOWER_COOLDOWN, 0L);
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"Your superpower cooldown has been skipped"));
        return 1;
    }

    public int setRandomSuperpowers(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        SuperpowersWildcard.rollRandomSuperpowers();
        OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"Randomized everyone's superpowers"));
        return 1;
    }

    public int setRandomSuperpowers(class_2168 source, Collection<class_3222> targets) {
        if (this.checkBanned(source)) {
            return -1;
        }
        SuperpowersWildcard.rollRandomSuperpowers(new ArrayList<class_3222>(targets));
        if (targets.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Randomized {}'s superpower", targets.iterator().next()));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Randomized the superpower of {} targets", targets.size()));
        }
        return 1;
    }

    public int resetSuperpowers(class_2168 source, Collection<class_3222> targets) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (targets == null || targets.isEmpty()) {
            return -1;
        }
        for (class_3222 player : targets) {
            SuperpowersWildcard.resetSuperpower(player);
        }
        if (targets.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Deactivated {}'s superpower", targets.iterator().next()));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Deactivated the superpower of {} targets", targets.size()));
        }
        return 1;
    }

    public int getSuperpower(class_2168 source, class_3222 player) {
        if (this.checkBanned(source)) {
            return -1;
        }
        Superpowers superpower = SuperpowersWildcard.getSuperpower(player);
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("{}'s superpower is: {}", player, superpower.getString()));
        return 1;
    }

    public int setSuperpower(class_2168 source, Collection<class_3222> targets, String name) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (targets == null || targets.isEmpty()) {
            return -1;
        }
        if (!Superpowers.getImplementedStr().contains(name)) {
            source.method_9213(class_2561.method_30163((String)"That superpower doesn't exist"));
            return -1;
        }
        Superpowers superpower = Superpowers.fromString(name);
        if (superpower == Superpowers.NULL) {
            source.method_9213(class_2561.method_30163((String)"That superpower doesn't exist"));
            return -1;
        }
        for (class_3222 player : targets) {
            SuperpowersWildcard.setSuperpower(player, superpower);
        }
        if (targets.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Set {}'s superpower to {}", targets.iterator().next(), name));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Set the superpower to {} for {} targets", name, targets.size()));
        }
        return 1;
    }

    public int setSnailName(class_2168 source, class_3222 player, String name) {
        if (this.checkBanned(source)) {
            return -1;
        }
        Snails.setSnailName(player, name);
        OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Set {}'s snail name to {}", player, name));
        return 1;
    }

    public int resetSnailName(class_2168 source, Collection<class_3222> targets) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (targets == null || targets.isEmpty()) {
            return -1;
        }
        for (class_3222 player : targets) {
            Snails.resetSnailName(player);
        }
        if (targets.size() == 1) {
            class_3222 player = targets.iterator().next();
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Reset {}'s snail name to {}'s Snail", player, player.method_5820()));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Reset the snail name for {} targets", targets.size()));
        }
        return 1;
    }

    public int getSnailNames(class_2168 source, Collection<class_3222> targets) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (targets == null || targets.isEmpty()) {
            return -1;
        }
        if (targets.size() == 1) {
            class_3222 player = targets.iterator().next();
            OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("{}'s snail is called {}", player, Snails.getSnailName((class_1657)player)));
        } else {
            for (class_3222 player : targets) {
                OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("{}'s snail is called {}", player, Snails.getSnailName((class_1657)player)));
            }
        }
        return 1;
    }

    public int deactivateWildcard(class_2168 source, String wildcardName) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (wildcardName.equalsIgnoreCase("*")) {
            WildcardManager.onSessionEnd();
            OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"Deactivated all wildcards"));
            return 1;
        }
        Wildcards wildcard = Wildcards.getFromString(wildcardName);
        if (wildcard == Wildcards.NULL) {
            source.method_9213(class_2561.method_30163((String)"That Wildcard doesn't exist"));
            return -1;
        }
        if (!WildcardManager.isActiveWildcard(wildcard)) {
            source.method_9213(class_2561.method_30163((String)"That Wildcard is not active"));
            return -1;
        }
        WildcardManager.fadedWildcard();
        Wildcard wildcardInstance = WildcardManager.activeWildcards.get((Object)wildcard);
        wildcardInstance.deactivate();
        WildcardManager.activeWildcards.remove((Object)wildcard);
        OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Deactivated {}", wildcardName));
        NetworkHandlerServer.sendUpdatePackets();
        return 1;
    }

    public int activateWildcard(class_2168 source, String wildcardName) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (wildcardName.equalsIgnoreCase("*")) {
            List<Wildcards> inactiveWildcards = Wildcards.getInactiveWildcards();
            for (Wildcards wildcard : inactiveWildcards) {
                Wildcard wildcardInstance;
                if (wildcard == Wildcards.CALLBACK || (wildcardInstance = wildcard.getInstance()) == null) continue;
                WildcardManager.activeWildcards.put(wildcard, wildcardInstance);
            }
            WildcardManager.showDots();
            TaskScheduler.scheduleTask(90, () -> {
                for (Wildcard wildcard : WildcardManager.activeWildcards.values()) {
                    if (wildcard.active) continue;
                    wildcard.activate();
                }
                WildcardManager.showRainbowCryptTitle("All wildcards are active!");
            });
            NetworkHandlerServer.sendUpdatePackets();
            OtherUtils.sendCommandFeedback(source, class_2561.method_30163((String)"Activated all wildcards (Except Callback)"));
            return 1;
        }
        Wildcards wildcard = Wildcards.getFromString(wildcardName);
        if (wildcard == Wildcards.NULL) {
            source.method_9213(class_2561.method_30163((String)"That Wildcard doesn't exist"));
            return -1;
        }
        if (WildcardManager.isActiveWildcard(wildcard)) {
            source.method_9213(class_2561.method_30163((String)"That Wildcard is already active"));
            return -1;
        }
        Wildcard actualWildcard = wildcard.getInstance();
        if (actualWildcard == null) {
            source.method_9213(class_2561.method_30163((String)"That Wildcard has not been implemented yet"));
            return -1;
        }
        TaskScheduler.scheduleTask(89, () -> WildcardManager.activeWildcards.put(wildcard, actualWildcard));
        WildcardManager.activateWildcards();
        OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Activated {}", wildcardName));
        return 1;
    }

    public int listWildcards(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("Available Wildcards: {}", Wildcards.getWildcardsStr()));
        return 1;
    }

    public int listActiveWildcards(class_2168 source) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (Wildcards.getActiveWildcardsStr().isEmpty()) {
            OtherUtils.sendCommandFeedbackQuiet(source, class_2561.method_30163((String)"\u00a77There are no active Wildcards right now. \nYou will be able to select a Wildcard when you start a session, or you can use '\u00a7f/wildcard activate <wildcard>\u00a77' to activate a specific Wildcard right now."));
            return 1;
        }
        OtherUtils.sendCommandFeedbackQuiet(source, (class_2561)TextUtils.format("Activated Wildcards: {}", Wildcards.getActiveWildcardsStr()));
        return 1;
    }
}

