/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.wildlife;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.command.manager.Command;
import net.mat0u5.lifeseries.compatibilities.CompatibilityManager;
import net.mat0u5.lifeseries.compatibilities.voicechat.VoicechatMain;
import net.mat0u5.lifeseries.entity.triviabot.server.trivia.WildLifeTriviaHandler;
import net.mat0u5.lifeseries.seasons.season.Seasons;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.trivia.TriviaQuestion;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.trivia.TriviaQuestionManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.trivia.TriviaWildcard;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TextUtils;
import net.mat0u5.lifeseries.utils.other.Tuple;
import net.mat0u5.lifeseries.utils.player.PermissionManager;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class WildLifeTriviaCommand
extends Command {
    private static Random rnd = new Random();

    @Override
    public boolean isAllowed() {
        return Main.currentSeason.getSeason() == Seasons.WILD_LIFE;
    }

    @Override
    public class_2561 getBannedText() {
        return class_2561.method_30163((String)"This command is only available in Wild Life.");
    }

    @Override
    public List<String> getAdminCommands() {
        return List.of("trivia");
    }

    @Override
    public List<String> getNonAdminCommands() {
        return List.of();
    }

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)WildLifeTriviaCommand.literal("trivia").requires(PermissionManager::isAdmin)).then(((LiteralArgumentBuilder)WildLifeTriviaCommand.literal("assign").requires(source -> this.isAllowed())).then(((RequiredArgumentBuilder)WildLifeTriviaCommand.argument("player", class_2186.method_9308()).then(WildLifeTriviaCommand.argument("difficulty", StringArgumentType.string()).suggests((context, builder) -> class_2172.method_9265(List.of("easy", "normal", "hard"), (SuggestionsBuilder)builder)).then(WildLifeTriviaCommand.argument("question", StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9265(this.getTriviaSuggestionsStr(StringArgumentType.getString((CommandContext)context, (String)"difficulty")), (SuggestionsBuilder)builder)).executes(context -> this.setTrivia((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"difficulty"), StringArgumentType.getString((CommandContext)context, (String)"question")))))).then(WildLifeTriviaCommand.literal("reset").executes(context -> this.resetTrivia((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"))))))).then(((LiteralArgumentBuilder)WildLifeTriviaCommand.literal("bot").requires(source -> this.isAllowed())).then(WildLifeTriviaCommand.literal("spawnFor").then(WildLifeTriviaCommand.argument("player", class_2186.method_9308()).executes(context -> this.spawnBotFor((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)WildLifeTriviaCommand.literal("punishment").requires(source -> this.isAllowed())).then(WildLifeTriviaCommand.literal("clear").then(WildLifeTriviaCommand.argument("player", class_2186.method_9308()).executes(context -> this.clearPunishment((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player")))))).then(WildLifeTriviaCommand.literal("set").then(WildLifeTriviaCommand.argument("player", class_2186.method_9308()).then(WildLifeTriviaCommand.argument("punishment", StringArgumentType.string()).suggests((context, builder) -> class_2172.method_9265(List.of("random", "slippery_ground", "hunger", "beeswarm", "moonjump", "robotic_voice", "binding_armor", "ravager", "hearts", "infestation", "gigantification"), (SuggestionsBuilder)builder)).executes(context -> this.setPunishment((class_2168)context.getSource(), class_2186.method_9312((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"punishment"))))))));
    }

    public int setPunishment(class_2168 source, Collection<class_3222> targets, String punishment) {
        if (this.checkBanned(source)) {
            return -1;
        }
        if (!CompatibilityManager.voicechatLoaded() && punishment.equals("robotic_voice")) {
            source.method_9213(class_2561.method_30163((String)"The server does not have Simple Voice Chat installed"));
            return -1;
        }
        int totalSVC = 0;
        block23: for (class_3222 player : targets) {
            String playerPunishment = punishment;
            if (punishment.equalsIgnoreCase("random")) {
                ArrayList<String> possibleValues = new ArrayList<String>(List.of("slippery_ground", "hunger", "beeswarm", "moonjump", "binding_armor", "ravager", "hearts", "infestation", "gigantification"));
                if (VoicechatMain.isConnectedToSVC(player.method_5667())) {
                    possibleValues.add("robotic_voice");
                }
                playerPunishment = (String)possibleValues.get(rnd.nextInt(possibleValues.size()));
            }
            switch (playerPunishment) {
                case "infestation": {
                    WildLifeTriviaHandler.curseInfestation(player);
                    continue block23;
                }
                case "slippery_ground": {
                    WildLifeTriviaHandler.curseSlipperyGround(player);
                    continue block23;
                }
                case "hunger": {
                    WildLifeTriviaHandler.curseHunger(player);
                    continue block23;
                }
                case "beeswarm": {
                    WildLifeTriviaHandler.curseBeeswarm(player, player.method_24515());
                    continue block23;
                }
                case "gigantification": {
                    WildLifeTriviaHandler.curseGigantification(player);
                    continue block23;
                }
                case "moonjump": {
                    WildLifeTriviaHandler.curseMoonjump(player);
                    continue block23;
                }
                case "robotic_voice": {
                    if (!VoicechatMain.isConnectedToSVC(player.method_5667())) continue block23;
                    WildLifeTriviaHandler.curseRoboticVoice(player);
                    ++totalSVC;
                    continue block23;
                }
                case "binding_armor": {
                    WildLifeTriviaHandler.curseBindingArmor(player);
                    continue block23;
                }
                case "ravager": {
                    WildLifeTriviaHandler.curseRavager(player, player.method_24515());
                    continue block23;
                }
            }
            WildLifeTriviaHandler.curseHearts(player);
        }
        if (punishment.equals("robotic_voice") && totalSVC == 0) {
            if (targets.size() == 1) {
                source.method_9213((class_2561)TextUtils.format("{} does not have Simple Voice Chat installed", targets.iterator().next()));
            } else {
                source.method_9213(class_2561.method_30163((String)"None of the targets have Simple Voice Chat installed"));
            }
            return -1;
        }
        if (targets.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Punished {} with {}", targets.iterator().next(), punishment));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Punished {} targets with {}", targets.size(), punishment));
        }
        return 1;
    }

    public int clearPunishment(class_2168 source, Collection<class_3222> targets) {
        if (this.checkBanned(source)) {
            return -1;
        }
        for (class_3222 player : targets) {
            TriviaWildcard.resetPlayerPunishments(player);
        }
        if (targets.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Cleared {}'s trivia punishments", targets.iterator().next()));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Cleared trivia punishments for {} targets", targets.size()));
        }
        return 1;
    }

    public int spawnBotFor(class_2168 source, Collection<class_3222> targets) {
        if (this.checkBanned(source)) {
            return -1;
        }
        for (class_3222 player : targets) {
            TriviaWildcard.spawnBotFor(player);
        }
        if (targets.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Spawned a trivia bot for {}", targets.iterator().next()));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Spawned a trivia bot for {} targets", targets.size()));
        }
        return 1;
    }

    public List<String> getTriviaSuggestionsStr(String questionType) {
        ArrayList<String> result = new ArrayList<String>();
        for (TriviaQuestion question : this.getTriviaQuestions(questionType)) {
            result.add(question.getQuestion());
        }
        return result;
    }

    public List<TriviaQuestion> getTriviaQuestions(String questionType) {
        ArrayList<TriviaQuestion> result = new ArrayList<TriviaQuestion>();
        TriviaQuestionManager manager = null;
        if (questionType.equalsIgnoreCase("easy")) {
            manager = TriviaWildcard.easyTrivia;
        } else if (questionType.equalsIgnoreCase("normal")) {
            manager = TriviaWildcard.normalTrivia;
        } else if (questionType.equalsIgnoreCase("hard")) {
            manager = TriviaWildcard.hardTrivia;
        }
        if (manager != null) {
            try {
                result.addAll(manager.getTriviaQuestions());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private int setTrivia(class_2168 source, Collection<class_3222> targets, String difficulty, String question) {
        if (this.checkBanned(source)) {
            return -1;
        }
        TriviaQuestion triviaQuestion = null;
        for (TriviaQuestion possibleQuestion : this.getTriviaQuestions(difficulty)) {
            if (!possibleQuestion.getQuestion().equals(question)) continue;
            triviaQuestion = possibleQuestion;
            break;
        }
        if (triviaQuestion == null) {
            source.method_9213(class_2561.method_30163((String)"Could not find trivia with that question."));
            return -1;
        }
        int difficultyInt = 1;
        if (difficulty.equalsIgnoreCase("normal")) {
            difficultyInt = 2;
        }
        if (difficulty.equalsIgnoreCase("hard")) {
            difficultyInt = 3;
        }
        for (class_3222 player : targets) {
            UUID uuid = player.method_5667();
            TriviaWildcard.preAssignedTrivia.put(uuid, new Tuple<Integer, TriviaQuestion>(difficultyInt, triviaQuestion));
        }
        if (targets.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Assigned {}'s trivia", targets.iterator().next()));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Assigned trivia of {} targets", targets.size()));
        }
        return 1;
    }

    private int resetTrivia(class_2168 source, Collection<class_3222> targets) {
        if (this.checkBanned(source)) {
            return -1;
        }
        for (class_3222 player : targets) {
            UUID uuid = player.method_5667();
            TriviaWildcard.preAssignedTrivia.remove(uuid);
        }
        if (targets.size() == 1) {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Reset {}'s assigned trivia", targets.iterator().next()));
        } else {
            OtherUtils.sendCommandFeedback(source, (class_2561)TextUtils.format("Reset assigned trivia of {} targets", targets.size()));
        }
        return 1;
    }
}

