/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.wildlife.morph;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.seasons.season.wildlife.morph.MorphComponent;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class MorphManager {
    public static final Map<UUID, MorphComponent> morphComponents = new HashMap<UUID, MorphComponent>();

    public static MorphComponent getOrCreateComponent(class_1657 player) {
        return MorphManager.getOrCreateComponent(player.method_5667());
    }

    public static MorphComponent getOrCreateComponent(UUID playerUUID) {
        return morphComponents.computeIfAbsent(playerUUID, k -> new MorphComponent(playerUUID));
    }

    public static void removeComponent(class_3222 player) {
        morphComponents.remove(player.method_5667());
        MorphManager.syncFromPlayer((class_1657)player);
    }

    public static void resetMorphs() {
        morphComponents.clear();
    }

    @Nullable
    public static MorphComponent getComponent(class_1657 player) {
        return morphComponents.get(player.method_5667());
    }

    public static boolean hasComponent(class_1657 player) {
        return morphComponents.containsKey(player.method_5667());
    }

    public static void setMorph(class_1657 player, class_1299<?> morph) {
        MorphComponent component = MorphManager.getOrCreateComponent(player);
        component.setMorph(morph);
        MorphManager.syncFromPlayer(player);
    }

    public static void resetMorph(class_1657 player) {
        MorphManager.setMorph(player, null);
    }

    public static void onPlayerJoin(class_3222 player) {
        MorphManager.getOrCreateComponent((class_1657)player);
    }

    public static void onPlayerDisconnect(class_3222 player) {
        MorphManager.removeComponent(player);
    }

    public static void syncFromPlayer(class_1657 player) {
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        MorphComponent component = MorphManager.getComponent((class_1657)serverPlayer);
        String typeStr = "null";
        if (component != null) {
            typeStr = component.getTypeAsString();
        }
        NetworkHandlerServer.sendStringListPackets(PacketNames.MORPH, List.of(serverPlayer.method_5845(), typeStr));
    }

    public static void syncToPlayer(class_1657 player) {
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        for (class_3222 otherPlayer : PlayerUtils.getAllPlayers()) {
            MorphComponent component = MorphManager.getOrCreateComponent((class_1657)otherPlayer);
            String typeStr = component.getTypeAsString();
            NetworkHandlerServer.sendStringListPacket(serverPlayer, PacketNames.MORPH, List.of(otherPlayer.method_5845(), typeStr));
        }
    }

    public static MorphComponent setFromPacket(UUID uuid, class_1299<?> morph) {
        MorphComponent component = MorphManager.getOrCreateComponent(uuid);
        component.setMorph(morph);
        return component;
    }
}

