/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.wildlife.wildcards;

import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.season.wildlife.WildLife;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.WildcardManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcards;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.Callback;
import net.mat0u5.lifeseries.seasons.session.SessionTranscript;
import net.mat0u5.lifeseries.utils.world.DatapackIntegration;

public abstract class Wildcard {
    public boolean active = false;

    public abstract Wildcards getType();

    public void activate() {
        WildLife season = WildcardManager.getSeason();
        if (season == null) {
            return;
        }
        this.active = true;
        Main.LOGGER.info("[WildLife] Activated Wildcard: {}", (Object)this.getType());
        SessionTranscript.activateWildcard(this.getType());
        DatapackIntegration.activateWildcard(this.getType());
    }

    public void deactivate() {
        WildLife season = WildcardManager.getSeason();
        if (season == null) {
            return;
        }
        this.active = false;
        Main.LOGGER.info("[WildLife] Dectivated Wildcard: {}", (Object)this.getType());
        SessionTranscript.deactivateWildcard(this.getType());
        DatapackIntegration.deactivateWildcard(this.getType());
    }

    public void tickSessionOn() {
    }

    public void tick() {
    }

    public void softTick() {
    }

    public static boolean isFinale() {
        return WildcardManager.FINALE || WildcardManager.isActiveWildcard(Wildcards.CALLBACK) && Callback.NERFED_WILDCARDS;
    }
}

