/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.wildlife.wildcards;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcard;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.WildcardManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.Callback;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.Hunger;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.MobSwap;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.SizeShifting;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.TimeDilation;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.snails.Snails;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.SuperpowersWildcard;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.trivia.TriviaWildcard;

public enum Wildcards {
    NULL,
    SIZE_SHIFTING,
    HUNGER,
    SNAILS,
    TIME_DILATION,
    TRIVIA,
    MOB_SWAP,
    SUPERPOWERS,
    CALLBACK;


    public Wildcard getInstance() {
        if (this == HUNGER) {
            return new Hunger();
        }
        if (this == SNAILS) {
            return new Snails();
        }
        if (this == SIZE_SHIFTING) {
            return new SizeShifting();
        }
        if (this == TIME_DILATION) {
            return new TimeDilation();
        }
        if (this == TRIVIA) {
            return new TriviaWildcard();
        }
        if (this == MOB_SWAP) {
            return new MobSwap();
        }
        if (this == SUPERPOWERS) {
            return new SuperpowersWildcard();
        }
        if (this == CALLBACK) {
            return new Callback();
        }
        return null;
    }

    public String getStringName() {
        return this.toString().toLowerCase(Locale.ROOT);
    }

    public int getIndex() {
        return this.ordinal();
    }

    public static Wildcards getFromIndex(int index) {
        for (Wildcards wildcard : Wildcards.values()) {
            if (wildcard.getIndex() != index) continue;
            return wildcard;
        }
        return NULL;
    }

    public static Wildcards getFromString(String wildcardStr) {
        for (Wildcards wildcard : Wildcards.getWildcards()) {
            if (!wildcard.getStringName().equalsIgnoreCase(wildcardStr)) continue;
            return wildcard;
        }
        return NULL;
    }

    public static List<Wildcards> getWildcards() {
        ArrayList<Wildcards> wildcards = new ArrayList<Wildcards>(List.of(Wildcards.values()));
        wildcards.remove((Object)NULL);
        return wildcards;
    }

    public static List<String> getWildcardsStr() {
        ArrayList<String> result = new ArrayList<String>();
        for (Wildcards wildcard : Wildcards.getWildcards()) {
            String name = wildcard.getStringName();
            result.add(name);
        }
        return result;
    }

    public static List<Wildcards> getActiveWildcards() {
        return new ArrayList<Wildcards>(WildcardManager.activeWildcards.keySet());
    }

    public static List<Wildcards> getInactiveWildcards() {
        ArrayList<Wildcards> result = new ArrayList<Wildcards>(Wildcards.getWildcards());
        result.removeAll(Wildcards.getActiveWildcards());
        return result;
    }

    public static List<String> getInactiveWildcardsStr() {
        ArrayList<String> result = new ArrayList<String>();
        for (Wildcards wildcard : Wildcards.getInactiveWildcards()) {
            String name = wildcard.getStringName();
            result.add(name);
        }
        return result;
    }

    public static List<String> getActiveWildcardsStr() {
        ArrayList<String> result = new ArrayList<String>();
        for (Wildcards wildcard : Wildcards.getActiveWildcards()) {
            String name = wildcard.getStringName();
            result.add(name);
        }
        return result;
    }
}

