/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcard;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.WildcardManager;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcards;
import net.mat0u5.lifeseries.seasons.session.SessionTranscript;
import net.mat0u5.lifeseries.utils.other.OtherUtils;
import net.mat0u5.lifeseries.utils.other.TaskScheduler;
import net.mat0u5.lifeseries.utils.other.Time;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;

public class Callback
extends Wildcard {
    private static final Random rnd = new Random();
    private static int activatedAt = -1;
    public static double TURN_OFF = 0.75;
    private static final Time INITIAL_ACTIVATION_INTERVAL = Time.minutes(5);
    private static final Time INITIAL_DEACTIVATION_INTERVAL = Time.seconds(30);
    public static boolean NERFED_WILDCARDS = true;
    private int nextActivationTick = -1;
    private int nextDeactivationTick = -1;
    public static boolean allWildcardsPhaseReached = false;
    private boolean preAllWildcardsPhaseReached = false;
    private static List<Wildcards> blacklistedWildcards = List.of(Wildcards.HUNGER);
    private Wildcards lastActivatedWildcard;

    public static void setBlacklist(String blacklist) {
        String[] wildcards;
        blacklistedWildcards = new ArrayList<Wildcards>();
        for (String wildcardName : wildcards = blacklist.replace("[", "").replace("]", "").split(",")) {
            Wildcards wildcard = Wildcards.getFromString(wildcardName.trim());
            if (wildcard == null || wildcard == Wildcards.NULL) continue;
            blacklistedWildcards.add(wildcard);
        }
    }

    @Override
    public Wildcards getType() {
        return Wildcards.CALLBACK;
    }

    @Override
    public void tick() {
        if (!Main.currentSession.validTime()) {
            return;
        }
        int passedTimeTicks = Main.currentSession.getPassedTime().getTicks();
        int sessionLengthTicks = Main.currentSession.getSessionLength().getTicks();
        double sessionProgress = (passedTimeTicks - activatedAt) / (sessionLengthTicks - activatedAt);
        if (this.nextActivationTick == -1) {
            this.nextActivationTick = passedTimeTicks + 6000;
        }
        if (sessionProgress >= TURN_OFF && this.active) {
            this.deactivate();
            allWildcardsPhaseReached = true;
            return;
        }
        if (allWildcardsPhaseReached) {
            return;
        }
        double approachingEndPhase = TURN_OFF - 6000.0 / (double)sessionLengthTicks;
        if (sessionProgress >= approachingEndPhase) {
            this.activateAllWildcards();
            allWildcardsPhaseReached = true;
            return;
        }
        if (this.preAllWildcardsPhaseReached) {
            return;
        }
        double furtherApproachingEndPhase = TURN_OFF - 6600.0 / (double)sessionLengthTicks;
        if (sessionProgress >= furtherApproachingEndPhase) {
            if (WildcardManager.isActiveWildcard(Wildcards.TIME_DILATION)) {
                WildcardManager.fadedWildcard();
                Wildcard wildcardInstance = WildcardManager.activeWildcards.get((Object)Wildcards.TIME_DILATION);
                wildcardInstance.deactivate();
                WildcardManager.activeWildcards.remove((Object)Wildcards.TIME_DILATION);
                NetworkHandlerServer.sendUpdatePackets();
            }
            this.preAllWildcardsPhaseReached = true;
            return;
        }
        int targetActiveCount = this.getTargetActiveWildcardCount(sessionProgress, sessionLengthTicks);
        int currentActiveCount = Wildcards.getActiveWildcards().size() - 1;
        if (currentActiveCount < targetActiveCount && passedTimeTicks >= this.nextActivationTick || passedTimeTicks >= this.nextActivationTick && this.nextActivationTick > 0) {
            this.activateRandomWildcard();
            double progressFactor = 1.0 - sessionProgress;
            int activationIntervalTicks = (int)((double)INITIAL_ACTIVATION_INTERVAL.getTicks() * Math.max(0.5, progressFactor));
            this.nextActivationTick = passedTimeTicks + activationIntervalTicks;
            double deactivationProgressFactor = 1.0 + sessionProgress / TURN_OFF * 4.0;
            int deactivationIntervalTicks = (int)((double)INITIAL_DEACTIVATION_INTERVAL.getTicks() * OtherUtils.clamp(deactivationProgressFactor, 1.0, 5.0));
            this.nextDeactivationTick = passedTimeTicks + deactivationIntervalTicks;
        }
        if (currentActiveCount > targetActiveCount && this.nextDeactivationTick > 0 && passedTimeTicks >= this.nextDeactivationTick) {
            this.deactivateRandomWildcard();
            this.nextDeactivationTick = -1;
        }
    }

    private int getTargetActiveWildcardCount(double sessionProgress, int sessionLengthTicks) {
        double approachingEndPhase = TURN_OFF - 6000.0 / (double)sessionLengthTicks;
        double newProgress = sessionProgress / approachingEndPhase;
        if (newProgress < 0.25) {
            return 1;
        }
        if (newProgress < 0.5) {
            return 2;
        }
        if (newProgress < 0.75) {
            return 3;
        }
        return 4;
    }

    @Override
    public void activate() {
        activatedAt = Main.currentSession.getPassedTime().getTicks();
        this.nextActivationTick = -1;
        this.nextDeactivationTick = -1;
        allWildcardsPhaseReached = false;
        this.preAllWildcardsPhaseReached = false;
        if (!blacklistedWildcards.contains((Object)Wildcards.SIZE_SHIFTING)) {
            this.softActivateWildcard(Wildcards.SIZE_SHIFTING);
        } else {
            this.softActivateWildcard(this.getRandomInactiveWildcard());
        }
        super.activate();
    }

    @Override
    public void deactivate() {
        this.deactivateAllWildcards();
        TaskScheduler.scheduleTask(50, () -> {
            if (Main.currentSession.statusStarted()) {
                Callback.showEndingTitles();
            }
        });
        super.deactivate();
    }

    public static void showEndingTitles() {
        SessionTranscript.endingIsYours();
        List<class_3222> players = PlayerUtils.getAllPlayers();
        PlayerUtils.sendTitleToPlayers(players, class_2561.method_30163((String)"\u00a77The ending is \u00a7cyours\u00a77..."), 0, 90, 0);
        TaskScheduler.scheduleTask(80, () -> {
            PlayerUtils.playSoundToPlayers(players, (class_3414)class_3417.field_18310.comp_349(), 0.4f, 1.0f);
            PlayerUtils.sendTitleToPlayers(players, class_2561.method_30163((String)"\u00a7cMake"), 0, 40, 0);
        });
        TaskScheduler.scheduleTask(110, () -> {
            PlayerUtils.playSoundToPlayers(players, (class_3414)class_3417.field_18310.comp_349(), 0.4f, 1.0f);
            PlayerUtils.sendTitleToPlayers(players, class_2561.method_30163((String)"\u00a7cMake \u00a7eit"), 0, 40, 0);
        });
        TaskScheduler.scheduleTask(140, () -> {
            PlayerUtils.playSoundToPlayers(players, class_3417.field_14905, 0.2f, 1.0f);
            PlayerUtils.sendTitleToPlayers(players, class_2561.method_30163((String)"\u00a7cMake \u00a7eit \u00a7a\u00a7lWILD"), 0, 90, 20);
        });
    }

    public void activateAllWildcards() {
        List<Wildcards> inactiveWildcards = Wildcards.getInactiveWildcards();
        for (Wildcards wildcard : inactiveWildcards) {
            Wildcard wildcardInstance;
            if (wildcard == Wildcards.CALLBACK || blacklistedWildcards.contains((Object)wildcard) || (wildcardInstance = wildcard.getInstance()) == null) continue;
            WildcardManager.activeWildcards.put(wildcard, wildcardInstance);
        }
        WildcardManager.showDots();
        TaskScheduler.scheduleTask(90, () -> {
            for (Wildcard wildcard : WildcardManager.activeWildcards.values()) {
                if (wildcard.active) continue;
                wildcard.activate();
            }
            WildcardManager.showRainbowCryptTitle("All wildcards are active!");
        });
        TaskScheduler.scheduleTask(92, NetworkHandlerServer::sendUpdatePackets);
    }

    public void deactivateAllWildcards() {
        for (Wildcard wildcard : WildcardManager.activeWildcards.values()) {
            if (wildcard.getType() == Wildcards.CALLBACK) continue;
            wildcard.deactivate();
            PlayerUtils.broadcastMessage(class_2561.method_30163((String)"\u00a77A Wildcard has faded..."));
        }
        WildcardManager.activeWildcards.clear();
        PlayerUtils.playSoundToPlayers(PlayerUtils.getAllPlayers(), class_3417.field_19344);
        NetworkHandlerServer.sendUpdatePackets();
    }

    public void activateRandomWildcard() {
        Wildcards wildcard = this.getRandomInactiveWildcard();
        if (wildcard == null) {
            return;
        }
        Wildcard wildcardInstance = wildcard.getInstance();
        if (wildcardInstance == null) {
            return;
        }
        WildcardManager.activeWildcards.put(wildcard, wildcardInstance);
        WildcardManager.activateWildcards();
        this.lastActivatedWildcard = wildcard;
    }

    public void deactivateRandomWildcard() {
        Wildcards wildcard = this.getRandomActiveWildcard();
        if (wildcard == null) {
            return;
        }
        Wildcard wildcardInstance = WildcardManager.activeWildcards.get((Object)wildcard);
        if (wildcardInstance == null) {
            return;
        }
        wildcardInstance.deactivate();
        WildcardManager.activeWildcards.remove((Object)wildcard);
        WildcardManager.fadedWildcard();
        NetworkHandlerServer.sendUpdatePackets();
    }

    public Wildcards getRandomInactiveWildcard() {
        List<Wildcards> inactiveWildcards = Wildcards.getInactiveWildcards();
        inactiveWildcards.remove((Object)Wildcards.CALLBACK);
        inactiveWildcards.removeIf(blacklistedWildcards::contains);
        if (inactiveWildcards.isEmpty()) {
            return null;
        }
        return inactiveWildcards.get(rnd.nextInt(inactiveWildcards.size()));
    }

    public Wildcards getRandomActiveWildcard() {
        List<Wildcards> activeWildcards = Wildcards.getActiveWildcards();
        activeWildcards.remove((Object)Wildcards.CALLBACK);
        activeWildcards.removeIf(blacklistedWildcards::contains);
        if (activeWildcards.isEmpty()) {
            return null;
        }
        if (this.lastActivatedWildcard != null) {
            activeWildcards.remove((Object)this.lastActivatedWildcard);
            if (activeWildcards.isEmpty()) {
                return this.lastActivatedWildcard;
            }
        }
        return activeWildcards.get(rnd.nextInt(activeWildcards.size()));
    }

    public void softActivateWildcard(Wildcards wildcard) {
        if (WildcardManager.isActiveWildcard(wildcard)) {
            return;
        }
        Wildcard wildcardInstance = wildcard.getInstance();
        if (wildcardInstance == null) {
            return;
        }
        WildcardManager.activeWildcards.put(wildcard, wildcardInstance);
        wildcardInstance.activate();
        TaskScheduler.scheduleTask(2, NetworkHandlerServer::sendUpdatePackets);
    }
}

