/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.compatibilities.CompatibilityManager;
import net.mat0u5.lifeseries.compatibilities.voicechat.VoicechatMain;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcard;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcards;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.Superpower;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.Superpowers;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.Mimicry;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.superpowers.superpower.Necromancy;
import net.mat0u5.lifeseries.utils.interfaces.IServerPlayer;
import net.mat0u5.lifeseries.utils.other.IdentifierHelper;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.world.DatapackIntegration;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import org.jetbrains.annotations.Nullable;

public class SuperpowersWildcard
extends Wildcard {
    public static boolean WILDCARD_SUPERPOWERS_DISABLE_INTRO_THEME = false;
    public static List<Superpowers> blacklistedPowers = List.of();
    private static final Map<UUID, Superpower> playerSuperpowers = new LinkedHashMap<UUID, Superpower>();
    public static final Map<UUID, Superpowers> preAssignedSuperpowers = new HashMap<UUID, Superpowers>();
    public static int ZOMBIES_HEALTH = 8;

    public static void setBlacklist(String blacklist) {
        String[] powers;
        blacklistedPowers = new ArrayList<Superpowers>();
        for (String powerName : powers = blacklist.replace("[", "").replace("]", "").split(",")) {
            Superpowers power = Superpowers.fromString(powerName.trim());
            if (power == null || power == Superpowers.NULL) continue;
            blacklistedPowers.add(power);
        }
    }

    @Override
    public Wildcards getType() {
        return Wildcards.SUPERPOWERS;
    }

    @Override
    public void activate() {
        SuperpowersWildcard.rollRandomSuperpowers();
        super.activate();
    }

    @Override
    public void deactivate() {
        SuperpowersWildcard.resetAllSuperpowers();
        super.deactivate();
    }

    public static void onTick() {
        playerSuperpowers.values().forEach(Superpower::tick);
    }

    public static void resetSuperpower(class_3222 player) {
        UUID uuid = player.method_5667();
        if (!playerSuperpowers.containsKey(uuid)) {
            return;
        }
        playerSuperpowers.get(uuid).turnOff();
        playerSuperpowers.remove(uuid);
        Necromancy.checkRessurectedPlayersReset();
        DatapackIntegration.deactivateSuperpower(player);
    }

    public static void resetAllSuperpowers() {
        playerSuperpowers.values().forEach(Superpower::turnOff);
        playerSuperpowers.clear();
        Necromancy.checkRessurectedPlayersReset();
        DatapackIntegration.initSuperpowers();
    }

    public static void rollRandomSuperpowers() {
        SuperpowersWildcard.rollRandomSuperpowers(Main.livesManager.getAlivePlayers());
    }

    public static void rollRandomSuperpowers(List<class_3222> allPlayers) {
        allPlayers.removeIf(IServerPlayer::ls$isDead);
        allPlayers.removeIf(IServerPlayer::ls$isWatcher);
        allPlayers.forEach(SuperpowersWildcard::resetSuperpower);
        ArrayList<class_3222> prioritizedList = new ArrayList<class_3222>();
        for (class_3222 player : allPlayers) {
            if (!preAssignedSuperpowers.containsKey(player.method_5667())) continue;
            prioritizedList.add(player);
        }
        for (class_3222 player : allPlayers) {
            if (prioritizedList.contains(player)) continue;
            prioritizedList.add(player);
        }
        for (class_3222 player : prioritizedList) {
            Superpowers power;
            Superpower instance;
            if (SuperpowersWildcard.hasPower(player) || (instance = (power = SuperpowersWildcard.getRandomPower(player)).getInstance(player)) == null) continue;
            playerSuperpowers.put(player.method_5667(), instance);
            DatapackIntegration.activateSuperpower(player, power);
        }
        if (!WILDCARD_SUPERPOWERS_DISABLE_INTRO_THEME) {
            PlayerUtils.playSoundToPlayers(allPlayers, class_3414.method_47908((class_2960)IdentifierHelper.vanilla("wildlife_superpowers")), 0.2f, 1.0f);
        }
    }

    private static Superpowers getRandomPower(class_3222 player) {
        int deadPlayersNum;
        int alivePlayersNum;
        int totalPlayersNum;
        if (preAssignedSuperpowers.containsKey(player.method_5667())) {
            Superpowers power = preAssignedSuperpowers.get(player.method_5667());
            preAssignedSuperpowers.remove(player.method_5667());
            return power;
        }
        ArrayList<Superpowers> implemented = new ArrayList<Superpowers>(Superpowers.getImplemented());
        blacklistedPowers.forEach(implemented::remove);
        if (CompatibilityManager.voicechatLoaded() && !VoicechatMain.isConnectedToSVC(player.method_5667())) {
            implemented.remove((Object)Superpowers.LISTENING);
        }
        ArrayList<Superpowers> nonAssigned = new ArrayList<Superpowers>(implemented);
        for (Superpower assignedPower : playerSuperpowers.values()) {
            Superpowers power = assignedPower.getSuperpower();
            nonAssigned.remove((Object)power);
        }
        Collections.shuffle(nonAssigned);
        boolean canHaveNecromancy = false;
        if (nonAssigned.contains((Object)Superpowers.NECROMANCY) && Necromancy.shouldBeIncluded() && (totalPlayersNum = (alivePlayersNum = Main.livesManager.getAlivePlayers().size()) + (deadPlayersNum = Main.livesManager.getDeadPlayers().size())) >= 6) {
            canHaveNecromancy = true;
            if (player.method_59922().method_43058() <= (double)deadPlayersNum / (double)alivePlayersNum) {
                return Superpowers.NECROMANCY;
            }
        }
        if (!canHaveNecromancy) {
            implemented.remove((Object)Superpowers.NECROMANCY);
            nonAssigned.remove((Object)Superpowers.NECROMANCY);
        }
        ArrayList<Superpowers> queue = new ArrayList<Superpowers>(nonAssigned);
        for (Superpower assignedPower : playerSuperpowers.values()) {
            Superpowers power = assignedPower.getSuperpower();
            if (!implemented.contains((Object)power)) continue;
            queue.remove((Object)power);
            queue.add(power);
        }
        return (Superpowers)((Object)queue.get(0));
    }

    public static void setSuperpower(class_3222 player, Superpowers superpower) {
        Superpower instance;
        if (playerSuperpowers.containsKey(player.method_5667())) {
            playerSuperpowers.get(player.method_5667()).turnOff();
        }
        if ((instance = superpower.getInstance(player)) != null) {
            playerSuperpowers.put(player.method_5667(), instance);
            DatapackIntegration.activateSuperpower(player, superpower);
        }
        if (!WILDCARD_SUPERPOWERS_DISABLE_INTRO_THEME) {
            PlayerUtils.playSoundToPlayer(player, class_3414.method_47908((class_2960)IdentifierHelper.vanilla("wildlife_superpowers")), 0.2f, 1.0f);
        }
        Necromancy.checkRessurectedPlayersReset();
    }

    public static void pressedSuperpowerKey(class_3222 player) {
        if (playerSuperpowers.containsKey(player.method_5667())) {
            if (player.ls$isAlive()) {
                playerSuperpowers.get(player.method_5667()).onKeyPressed();
            } else {
                PlayerUtils.displayMessageToPlayer(player, (class_2561)class_2561.method_43470((String)"Dead players can't use superpowers!"), 60);
            }
        }
    }

    public static boolean hasPower(class_3222 player) {
        return playerSuperpowers.containsKey(player.method_5667());
    }

    public static boolean hasActivePower(class_3222 player, Superpowers superpower) {
        if (!playerSuperpowers.containsKey(player.method_5667())) {
            return false;
        }
        Superpower power = playerSuperpowers.get(player.method_5667());
        if (power instanceof Mimicry) {
            Mimicry mimicry = (Mimicry)power;
            if (superpower != Superpowers.MIMICRY) {
                return mimicry.getMimickedPower().getSuperpower() == superpower;
            }
        }
        return power.getSuperpower() == superpower;
    }

    public static boolean hasActivatedPower(class_3222 player, Superpowers superpower) {
        if (!SuperpowersWildcard.hasActivePower(player, superpower)) {
            return false;
        }
        Superpower power = playerSuperpowers.get(player.method_5667());
        if (power instanceof Mimicry) {
            Mimicry mimicry = (Mimicry)power;
            if (superpower != Superpowers.MIMICRY) {
                return mimicry.getMimickedPower().active;
            }
        }
        return power.active;
    }

    public static Superpowers getSuperpower(class_3222 player) {
        if (playerSuperpowers.containsKey(player.method_5667())) {
            Superpower power = playerSuperpowers.get(player.method_5667());
            if (power instanceof Mimicry) {
                Mimicry mimicry = (Mimicry)power;
                return mimicry.getMimickedPower().getSuperpower();
            }
            return power.getSuperpower();
        }
        return Superpowers.NULL;
    }

    @Nullable
    public static Superpower getSuperpowerInstance(class_3222 player) {
        if (!playerSuperpowers.containsKey(player.method_5667())) {
            return null;
        }
        Superpower power = playerSuperpowers.get(player.method_5667());
        if (power instanceof Mimicry) {
            Mimicry mimicry = (Mimicry)power;
            return mimicry.getMimickedPower();
        }
        return power;
    }
}

