/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.trivia;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.resources.ResourceHandler;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.trivia.TriviaQuestion;

public class TriviaQuestionManager {
    private File file;
    private File folder;

    public TriviaQuestionManager(String folder, String file) {
        this.file = new File(folder + "/" + file);
        this.folder = new File(folder);
        if (!this.folder.exists() && !this.folder.mkdirs()) {
            Main.LOGGER.error("Failed to create folder {}", (Object)this.folder);
            return;
        }
        if (!this.file.exists()) {
            ResourceHandler handler = new ResourceHandler();
            if (folder.contains("nicelife")) {
                handler.copyBundledSingleFile("/files/trivia/nicelife-trivia.json", this.file.toPath());
            }
            if (file.startsWith("easy-")) {
                handler.copyBundledSingleFile("/files/trivia/easy-trivia.json", this.file.toPath());
            } else if (file.startsWith("normal-")) {
                handler.copyBundledSingleFile("/files/trivia/normal-trivia.json", this.file.toPath());
            } else if (file.startsWith("hard-")) {
                handler.copyBundledSingleFile("/files/trivia/hard-trivia.json", this.file.toPath());
            }
        }
    }

    private void setFileContent(String content) {
        try {
            FileWriter myWriter = new FileWriter(this.file, false);
            myWriter.write(content);
            myWriter.close();
        }
        catch (IOException e) {
            Main.LOGGER.error(e.getMessage());
        }
    }

    public List<TriviaQuestion> getTriviaQuestions() throws IOException {
        String content = new String(Files.readAllBytes(this.file.toPath()));
        Gson gson = new Gson();
        return (List)gson.fromJson(content, new TypeToken<List<TriviaQuestion>>(this){}.getType());
    }
}

