/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.trivia;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.entity.snail.Snail;
import net.mat0u5.lifeseries.entity.triviabot.TriviaBot;
import net.mat0u5.lifeseries.entity.triviabot.server.TriviaBotPathfinding;
import net.mat0u5.lifeseries.entity.triviabot.server.trivia.WildLifeTriviaHandler;
import net.mat0u5.lifeseries.network.NetworkHandlerServer;
import net.mat0u5.lifeseries.registries.MobRegistry;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcard;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.Wildcards;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.SizeShifting;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.trivia.TriviaQuestion;
import net.mat0u5.lifeseries.seasons.season.wildlife.wildcards.wildcard.trivia.TriviaQuestionManager;
import net.mat0u5.lifeseries.seasons.session.SessionTranscript;
import net.mat0u5.lifeseries.utils.enums.PacketNames;
import net.mat0u5.lifeseries.utils.other.Time;
import net.mat0u5.lifeseries.utils.other.Tuple;
import net.mat0u5.lifeseries.utils.player.AttributeUtils;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.mat0u5.lifeseries.utils.world.DatapackIntegration;
import net.mat0u5.lifeseries.utils.world.LevelUtils;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class TriviaWildcard
extends Wildcard {
    private static final Map<UUID, Queue<Integer>> playerSpawnQueue = new HashMap<UUID, Queue<Integer>>();
    private static final Map<UUID, Integer> spawnedBotsFor = new HashMap<UUID, Integer>();
    public static final Map<UUID, Snail> snails = new HashMap<UUID, Snail>();
    private static boolean globalScheduleInitialized = false;
    public static Map<UUID, TriviaBot> bots = new HashMap<UUID, TriviaBot>();
    public static Time activatedAt = Time.nullTime();
    public static int TRIVIA_BOTS_PER_PLAYER = 5;
    public static int MIN_BOT_DELAY = 8400;
    public static TriviaQuestionManager easyTrivia;
    public static TriviaQuestionManager normalTrivia;
    public static TriviaQuestionManager hardTrivia;
    private static final Random rnd;
    public static Time timer;
    public static Map<UUID, Tuple<Integer, TriviaQuestion>> preAssignedTrivia;
    private static List<String> usedEasyQuestions;
    private static List<String> usedNormalQuestions;
    private static List<String> usedHardQuestions;

    @Override
    public Wildcards getType() {
        return Wildcards.TRIVIA;
    }

    @Override
    public void tickSessionOn() {
        Time passedTime = Main.currentSession.getPassedTime().diff(activatedAt);
        if (passedTime.isMultipleOf(Time.seconds(1))) {
            this.trySpawnBots();
        }
        if (passedTime.isMultipleOf(Time.seconds(10))) {
            this.updateDeadBots();
        }
    }

    @Override
    public void tick() {
        timer.tick();
        if (timer.isMultipleOf(Time.seconds(10))) {
            for (class_3222 player : PlayerUtils.getAllPlayers()) {
                Snail snail;
                UUID playerUUID = player.method_5667();
                if (!snails.containsKey(playerUUID) || (snail = snails.get(playerUUID)) != null && snail.method_5805()) continue;
                snails.remove(playerUUID);
            }
        }
    }

    @Override
    public void activate() {
        usedEasyQuestions.clear();
        usedNormalQuestions.clear();
        usedHardQuestions.clear();
        TriviaWildcard.resetQueue();
        spawnedBotsFor.clear();
        activatedAt = Main.currentSession.getPassedTime();
        bots.clear();
        WildLifeTriviaHandler.cursedGigantificationPlayers.clear();
        WildLifeTriviaHandler.cursedHeartPlayers.clear();
        WildLifeTriviaHandler.cursedMoonJumpPlayers.clear();
        if (!Main.currentSession.statusStarted()) {
            PlayerUtils.broadcastMessageToAdmins(class_2561.method_30163((String)"\u00a77You must start a session for trivia bots to spawn!"));
        }
        PlayerUtils.broadcastMessageToAdmins(class_2561.method_30163((String)"\u00a77You can modify the trivia questions in the config files (./config/lifeseries/wildlife/*-trivia)"));
        super.activate();
    }

    @Override
    public void deactivate() {
        usedEasyQuestions.clear();
        usedNormalQuestions.clear();
        usedHardQuestions.clear();
        TriviaWildcard.resetQueue();
        spawnedBotsFor.clear();
        bots.clear();
        TriviaWildcard.killAllBots();
        TriviaWildcard.killAllTriviaSnails();
        for (class_3222 player : PlayerUtils.getAllPlayers()) {
            TriviaWildcard.resetPlayerOnBotSpawn(player);
        }
        WildLifeTriviaHandler.cursedGigantificationPlayers.clear();
        WildLifeTriviaHandler.cursedHeartPlayers.clear();
        WildLifeTriviaHandler.cursedMoonJumpPlayers.clear();
        super.deactivate();
    }

    public void trySpawnBots() {
        UUID uuid;
        int numPlayers;
        int desiredTotalSpawns;
        int currentTick = Main.currentSession.getPassedTime().getTicks();
        int sessionStart = activatedAt.getTicks();
        int sessionEnd = Main.currentSession.getSessionLength().getTicks() - 6000;
        int availableTime = sessionEnd - sessionStart;
        List<class_3222> players = Main.livesManager.getAlivePlayers();
        if (players.isEmpty()) {
            return;
        }
        if (TriviaWildcard.isBuffed()) {
            Collections.shuffle(players);
        }
        if ((desiredTotalSpawns = (numPlayers = players.size()) * TriviaWildcard.getBotsPerPlayer()) == 0) {
            return;
        }
        int interval = availableTime / desiredTotalSpawns;
        if (numPlayers * interval < MIN_BOT_DELAY) {
            interval = MIN_BOT_DELAY / numPlayers;
        }
        int maxSpawns = Math.min(desiredTotalSpawns, availableTime / interval);
        for (class_3222 player : players) {
            uuid = player.method_5667();
            if (playerSpawnQueue.containsKey(uuid)) continue;
            playerSpawnQueue.put(uuid, new LinkedList());
            globalScheduleInitialized = false;
        }
        if (!globalScheduleInitialized) {
            playerSpawnQueue.values().forEach(Collection::clear);
            for (int i = 0; i < maxSpawns; ++i) {
                int spawnTime = sessionStart + 100 + i * interval;
                class_3222 assignedPlayer = players.get(i % numPlayers);
                UUID uuid2 = assignedPlayer.method_5667();
                if (spawnTime <= currentTick) continue;
                playerSpawnQueue.get(uuid2).offer(spawnTime);
            }
            globalScheduleInitialized = true;
        }
        for (class_3222 player : players) {
            uuid = player.method_5667();
            Queue<Integer> queue = playerSpawnQueue.get(uuid);
            if (queue == null || queue.isEmpty() || currentTick < queue.peek()) continue;
            queue.poll();
            if (spawnedBotsFor.containsKey(player.method_5667())) {
                spawnedBotsFor.put(player.method_5667(), 1 + spawnedBotsFor.get(player.method_5667()));
            } else {
                spawnedBotsFor.put(player.method_5667(), 1);
            }
            if (spawnedBotsFor.get(player.method_5667()) > TriviaWildcard.getBotsPerPlayer()) continue;
            TriviaWildcard.spawnBotFor(player);
        }
    }

    public void updateDeadBots() {
        for (class_3222 player : PlayerUtils.getAllPlayers()) {
            TriviaBot bot;
            UUID playerUUID = player.method_5667();
            if (!bots.containsKey(playerUUID) || (bot = bots.get(playerUUID)) != null && bot.method_5805()) continue;
            bots.remove(playerUUID);
        }
    }

    public static void reload() {
        TriviaWildcard.resetQueue();
    }

    public static void resetQueue() {
        easyTrivia = new TriviaQuestionManager("./config/lifeseries/wildlife", "easy-trivia.json");
        normalTrivia = new TriviaQuestionManager("./config/lifeseries/wildlife", "normal-trivia.json");
        hardTrivia = new TriviaQuestionManager("./config/lifeseries/wildlife", "hard-trivia.json");
        globalScheduleInitialized = false;
        playerSpawnQueue.clear();
    }

    public static void handleAnswer(class_3222 player, int answer) {
        TriviaBot bot;
        if (bots.containsKey(player.method_5667()) && (bot = bots.get(player.method_5667())).method_5805()) {
            bot.triviaHandler.handleAnswer(answer);
        }
    }

    public static void spawnBotFor(class_3222 player) {
        TriviaWildcard.spawnBotFor(player, TriviaBotPathfinding.getBlockPosNearPlayer((class_1297)player, player.method_24515().method_10069(0, 50, 0), 10.0));
    }

    public static void spawnBotFor(class_3222 player, class_2338 pos) {
        TriviaWildcard.resetPlayerOnBotSpawn(player);
        TriviaBot bot = LevelUtils.spawnEntity(MobRegistry.TRIVIA_BOT, player.ls$getServerLevel(), pos);
        if (bot != null) {
            SessionTranscript.newTriviaBot(player);
            bot.serverData.setBoundPlayer(player);
            bots.put(player.method_5667(), bot);
            player.ls$playNotifySound(class_3417.field_14865, class_3419.field_15250, 0.5f, 1.0f);
            NetworkHandlerServer.sendNumberPacket(player, PacketNames.FAKE_THUNDER, 7.0);
            DatapackIntegration.EVENT_TRIVIA_BOT_SPAWN.trigger(List.of(new DatapackIntegration.Events.MacroEntry("Player", player.method_5820()), new DatapackIntegration.Events.MacroEntry("TriviaBot", bot.method_5845())));
        }
    }

    public static void resetPlayerOnBotSpawn(class_3222 player) {
        TriviaBot bot;
        if (bots.containsKey(player.method_5667()) && (bot = bots.get(player.method_5667())).method_5805()) {
            bot.serverData.despawn();
        }
        TriviaWildcard.killTriviaSnailFor(player);
        TriviaWildcard.resetPlayerPunishments(player);
        NetworkHandlerServer.sendStringPacket(player, PacketNames.RESET_TRIVIA, "true");
    }

    public static void resetPlayerPunishments(class_3222 player) {
        if (WildLifeTriviaHandler.cursedGigantificationPlayers.contains(player.method_5667())) {
            WildLifeTriviaHandler.cursedGigantificationPlayers.remove(player.method_5667());
            SizeShifting.setPlayerSize(player, 1.0);
        }
        if (WildLifeTriviaHandler.cursedHeartPlayers.contains(player.method_5667())) {
            WildLifeTriviaHandler.cursedHeartPlayers.remove(player.method_5667());
            AttributeUtils.resetMaxPlayerHealthIfNecessary(player);
        }
        if (WildLifeTriviaHandler.cursedMoonJumpPlayers.contains(player.method_5667())) {
            WildLifeTriviaHandler.cursedMoonJumpPlayers.remove(player.method_5667());
            AttributeUtils.resetPlayerJumpHeight(player);
        }
        WildLifeTriviaHandler.cursedSliding.remove(player.method_5667());
        WildLifeTriviaHandler.cursedRoboticVoicePlayers.remove(player.method_5667());
        NetworkHandlerServer.sendLongPacket(player, PacketNames.CURSE_SLIDING, 0L);
    }

    public static void killAllBots() {
        if (Main.server == null) {
            return;
        }
        ArrayList<class_1297> toKill = new ArrayList<class_1297>();
        for (class_3218 level : Main.server.method_3738()) {
            for (class_1297 entity : level.method_27909()) {
                if (!(entity instanceof TriviaBot)) continue;
                toKill.add(entity);
            }
        }
        toKill.forEach(class_1297::method_31472);
        for (class_3222 player : PlayerUtils.getAllPlayers()) {
            NetworkHandlerServer.sendStringPacket(player, PacketNames.RESET_TRIVIA, "true");
        }
    }

    public static void killAllTriviaSnails() {
        if (Main.server == null) {
            return;
        }
        ArrayList<class_1297> toKill = new ArrayList<class_1297>();
        for (class_3218 level : Main.server.method_3738()) {
            for (class_1297 entity : level.method_27909()) {
                Snail snail;
                if (!(entity instanceof Snail) || !(snail = (Snail)entity).isFromTrivia()) continue;
                toKill.add(entity);
            }
        }
        toKill.forEach(class_1297::method_31472);
    }

    public static void killTriviaSnailFor(class_3222 player) {
        if (Main.server == null) {
            return;
        }
        ArrayList<class_1297> toKill = new ArrayList<class_1297>();
        for (class_3218 level : Main.server.method_3738()) {
            for (class_1297 entity : level.method_27909()) {
                UUID boundPlayer;
                Snail snail;
                if (!(entity instanceof Snail) || !(snail = (Snail)entity).isFromTrivia() || (boundPlayer = snail.serverData.getBoundPlayerUUID()) != null && !boundPlayer.equals(player.method_5667())) continue;
                toKill.add(entity);
            }
        }
        toKill.forEach(class_1297::method_31472);
    }

    public static Tuple<Integer, TriviaQuestion> getTriviaQuestion(class_3222 player) {
        if (preAssignedTrivia.containsKey(player.method_5667())) {
            Tuple<Integer, TriviaQuestion> assigned = preAssignedTrivia.get(player.method_5667());
            preAssignedTrivia.remove(player.method_5667());
            return assigned;
        }
        int difficulty = 1 + player.method_59922().method_43048(3);
        try {
            if (difficulty == 1) {
                return new Tuple<Integer, TriviaQuestion>(difficulty, TriviaWildcard.getEasyQuestion());
            }
            if (difficulty == 2) {
                return new Tuple<Integer, TriviaQuestion>(difficulty, TriviaWildcard.getNormalQuestion());
            }
            return new Tuple<Integer, TriviaQuestion>(difficulty, TriviaWildcard.getHardQuestion());
        }
        catch (Exception e) {
            Main.LOGGER.error(e.toString());
            return new Tuple<Integer, TriviaQuestion>(difficulty, TriviaQuestion.getDefault());
        }
    }

    public static TriviaQuestion getEasyQuestion() throws IOException {
        if (easyTrivia == null) {
            easyTrivia = new TriviaQuestionManager("./config/lifeseries/wildlife", "easy-trivia.json");
        }
        List<Object> unusedQuestions = new ArrayList();
        for (TriviaQuestion trivia : easyTrivia.getTriviaQuestions()) {
            if (usedEasyQuestions.contains(trivia.getQuestion())) continue;
            unusedQuestions.add(trivia);
        }
        if (unusedQuestions.isEmpty()) {
            usedEasyQuestions.clear();
            unusedQuestions = easyTrivia.getTriviaQuestions();
        }
        if (unusedQuestions.isEmpty()) {
            return TriviaQuestion.getDefault();
        }
        TriviaQuestion result = (TriviaQuestion)unusedQuestions.get(rnd.nextInt(unusedQuestions.size()));
        usedEasyQuestions.add(result.getQuestion());
        return result;
    }

    public static TriviaQuestion getNormalQuestion() throws IOException {
        if (normalTrivia == null) {
            normalTrivia = new TriviaQuestionManager("./config/lifeseries/wildlife", "normal-trivia.json");
        }
        List<Object> unusedQuestions = new ArrayList();
        for (TriviaQuestion trivia : normalTrivia.getTriviaQuestions()) {
            if (usedNormalQuestions.contains(trivia.getQuestion())) continue;
            unusedQuestions.add(trivia);
        }
        if (unusedQuestions.isEmpty()) {
            usedNormalQuestions.clear();
            unusedQuestions = normalTrivia.getTriviaQuestions();
        }
        if (unusedQuestions.isEmpty()) {
            return TriviaQuestion.getDefault();
        }
        TriviaQuestion result = (TriviaQuestion)unusedQuestions.get(rnd.nextInt(unusedQuestions.size()));
        usedNormalQuestions.add(result.getQuestion());
        return result;
    }

    public static TriviaQuestion getHardQuestion() throws IOException {
        if (hardTrivia == null) {
            hardTrivia = new TriviaQuestionManager("./config/lifeseries/wildlife", "hard-trivia.json");
        }
        List<Object> unusedQuestions = new ArrayList();
        for (TriviaQuestion trivia : hardTrivia.getTriviaQuestions()) {
            if (usedHardQuestions.contains(trivia.getQuestion())) continue;
            unusedQuestions.add(trivia);
        }
        if (unusedQuestions.isEmpty()) {
            usedHardQuestions.clear();
            unusedQuestions = hardTrivia.getTriviaQuestions();
        }
        if (unusedQuestions.isEmpty()) {
            return TriviaQuestion.getDefault();
        }
        TriviaQuestion result = (TriviaQuestion)unusedQuestions.get(rnd.nextInt(unusedQuestions.size()));
        usedHardQuestions.add(result.getQuestion());
        return result;
    }

    public static int getBotsPerPlayer() {
        if (TriviaWildcard.isBuffed()) {
            return TRIVIA_BOTS_PER_PLAYER * 2;
        }
        return TRIVIA_BOTS_PER_PLAYER;
    }

    public static boolean isBuffed() {
        return Wildcard.isFinale();
    }

    static {
        rnd = new Random();
        timer = Time.zero();
        preAssignedTrivia = new HashMap<UUID, Tuple<Integer, TriviaQuestion>>();
        usedEasyQuestions = new ArrayList<String>();
        usedNormalQuestions = new ArrayList<String>();
        usedHardQuestions = new ArrayList<String>();
    }
}

