/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.seasons.session;

import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.seasons.session.SessionTranscript;
import net.mat0u5.lifeseries.utils.other.Time;

public abstract class SessionAction {
    public boolean hasTriggered = false;
    private Time triggerTime;
    public String sessionMessage;
    public boolean showTime = false;

    public SessionAction(Time triggerTime) {
        this.triggerTime = triggerTime;
    }

    public SessionAction(Time triggerTime, String message) {
        this.triggerTime = triggerTime;
        this.sessionMessage = message;
        this.showTime = true;
    }

    public boolean tick() {
        boolean shouldTrigger = this.shouldTrigger();
        if (this.hasTriggered && !shouldTrigger) {
            this.hasTriggered = false;
        }
        if (this.hasTriggered) {
            return true;
        }
        if (shouldTrigger) {
            this.hasTriggered = true;
            SessionTranscript.triggerSessionAction(this.sessionMessage);
            this.trigger();
            return true;
        }
        return false;
    }

    public boolean shouldTrigger() {
        int triggerAtTicks = this.triggerTime.getTicks();
        if (triggerAtTicks >= 0) {
            int passedTime = Main.currentSession.getPassedTime().getTicks();
            return passedTime >= triggerAtTicks;
        }
        int remainingTime = Main.currentSession.getRemainingTime().getTicks();
        return remainingTime <= Math.abs(triggerAtTicks);
    }

    public Time getTriggerTime() {
        return this.triggerTime;
    }

    public abstract void trigger();
}

