/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mat0u5.lifeseries.mixin.client.AbstractSoundInstanceAccessor;
import net.mat0u5.lifeseries.mixin.client.EntityBoundSoundInstanceAccessor;
import net.mat0u5.lifeseries.mixin.client.SoundEngineAccessor;
import net.mat0u5.lifeseries.mixin.client.SoundManagerAccessor;
import net.mat0u5.lifeseries.utils.ClientTaskScheduler;
import net.minecraft.class_1106;
import net.minecraft.class_1113;
import net.minecraft.class_1140;
import net.minecraft.class_1144;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class ClientSounds {
    public static final Map<UUID, class_1113> onlyPlayLatestEntities = new HashMap<UUID, class_1113>();
    public static final List<class_1113> onlyPlayLatest = new ArrayList<class_1113>();
    private static final List<String> onlyPlayLatestSounds = List.of("wildlife_trivia_intro", "wildlife_trivia_suspense", "wildlife_trivia_suspense_end", "wildlife_trivia_analyzing", "nicelife_santabot_intro", "nicelife_santabot_suspense", "nicelife_santabot_suspense_end", "nicelife_santabot_analyzing", "nicelife_santabot_incorrect1", "nicelife_santabot_incorrect2", "nicelife_santabot_incorrect3", "nicelife_santabot_incorrect4", "nicelife_santabot_incorrect5", "nicelife_santabot_incorrect6", "nicelife_santabot_vote", "nicelife_santabot_turn");
    private static final List<String> onlyOneOf = List.of("wildlife_trivia_intro", "wildlife_trivia_suspense", "wildlife_trivia_suspense_end");
    private static long ticks = 0L;

    public static void onSoundPlay(class_1113 sound) {
        class_1106 entityTrackingSound;
        if (!onlyPlayLatestSounds.contains(sound.method_4775().method_12832())) {
            return;
        }
        if (sound instanceof class_1106 && (entityTrackingSound = (class_1106)sound) instanceof EntityBoundSoundInstanceAccessor) {
            class_1113 stopSound;
            EntityBoundSoundInstanceAccessor entityTrackingSoundAccessor = (EntityBoundSoundInstanceAccessor)entityTrackingSound;
            class_1297 entity = entityTrackingSoundAccessor.getEntity();
            if (entity == null) {
                return;
            }
            UUID uuid = entity.method_5667();
            if (uuid == null) {
                return;
            }
            if (onlyPlayLatestEntities.containsKey(uuid) && (stopSound = onlyPlayLatestEntities.get(uuid)) != null) {
                class_310.method_1551().method_1483().method_4870(stopSound);
            }
            onlyPlayLatestEntities.put(uuid, sound);
            return;
        }
        for (class_1113 stopSound : onlyPlayLatest) {
            if (stopSound == null) continue;
            ClientTaskScheduler.schedulePriorityTask(5, () -> class_310.method_1551().method_1483().method_4870(stopSound));
        }
        onlyPlayLatest.clear();
        onlyPlayLatest.add(sound);
    }

    public static void updateSingleSoundVolumes() {
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player == null) {
            return;
        }
        if (++ticks % 15L != 0L) {
            return;
        }
        class_1144 soundManager = class_310.method_1551().method_1483();
        if (!(soundManager instanceof SoundManagerAccessor)) {
            return;
        }
        SoundManagerAccessor managerAccessor = (SoundManagerAccessor)soundManager;
        class_1140 soundSystem = managerAccessor.getSoundSystem();
        if (!(soundSystem instanceof SoundEngineAccessor)) {
            return;
        }
        SoundEngineAccessor accessor = (SoundEngineAccessor)soundSystem;
        HashMap soundMap = new HashMap();
        for (Collection soundCategory : accessor.getSounds().asMap().values()) {
            for (class_1113 sound : soundCategory) {
                String name = sound.method_4775().method_12832();
                if (!onlyOneOf.contains(name)) continue;
                class_243 soundPosition = new class_243(sound.method_4784(), sound.method_4779(), sound.method_4778());
                double distance = player.method_73189().method_1022(soundPosition);
                if (soundMap.containsKey(name)) {
                    ((Map)soundMap.get(name)).put(distance, sound);
                    continue;
                }
                TreeMap<Double, class_1113> distanceMap = new TreeMap<Double, class_1113>();
                distanceMap.put(distance, sound);
                soundMap.put(name, distanceMap);
            }
        }
        if (soundMap.isEmpty()) {
            return;
        }
        for (Map distanceMap : soundMap.values()) {
            if (distanceMap.isEmpty()) continue;
            int index = 0;
            for (class_1113 sound : distanceMap.values()) {
                if (!(sound instanceof AbstractSoundInstanceAccessor)) continue;
                AbstractSoundInstanceAccessor soundAccessor = (AbstractSoundInstanceAccessor)sound;
                if (index == 0) {
                    soundAccessor.setVolume(1.0f);
                } else {
                    soundAccessor.setVolume(0.0f);
                }
                ++index;
            }
        }
    }

    public static void stopTriviaSounds() {
        for (class_1113 stopSound : onlyPlayLatest) {
            if (stopSound == null) continue;
            class_310.method_1551().method_1483().method_4870(stopSound);
        }
        for (class_1113 stopSound : onlyPlayLatestEntities.values()) {
            if (stopSound == null) continue;
            class_310.method_1551().method_1483().method_4870(stopSound);
        }
        onlyPlayLatest.clear();
        onlyPlayLatestEntities.clear();
    }
}

