/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.utils.other;

import com.mojang.authlib.GameProfile;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.events.Events;
import net.mat0u5.lifeseries.utils.other.IdentifierHelper;
import net.mat0u5.lifeseries.utils.other.Time;
import net.mat0u5.lifeseries.utils.player.PlayerUtils;
import net.minecraft.class_12279;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_8915;

public class OtherUtils {
    private static final Random rnd = new Random();
    private static final Pattern TIME_PATTERN = Pattern.compile("(?:(\\d+)h)?(?:(\\d+)m)?(?:(\\d+)s)?");
    private static List<Long> reloads = new ArrayList<Long>();

    public static void log(class_2561 message) {
        for (class_3222 player : PlayerUtils.getAllPlayers()) {
            player.method_7353(message, false);
        }
        Main.LOGGER.info(message.getString());
    }

    public static void log(String string) {
        class_2561 message = class_2561.method_30163((String)string);
        for (class_3222 player : PlayerUtils.getAllPlayers()) {
            player.method_7353(message, false);
        }
        Main.LOGGER.info(string);
    }

    public static void logConsole(String string) {
        Main.LOGGER.info(string);
    }

    public static void logIfClient(String string) {
        if (Main.isClient()) {
            Main.LOGGER.info(string);
        }
    }

    public static Time parseTimeFromArgument(String time) {
        Matcher matcher = TIME_PATTERN.matcher(time = time.replaceAll(" ", "").replaceAll("\"", ""));
        if (!matcher.matches()) {
            return null;
        }
        try {
            int hours = OtherUtils.parseInt(matcher.group(1));
            int minutes = OtherUtils.parseInt(matcher.group(2));
            int seconds = OtherUtils.parseInt(matcher.group(3));
            int totalSeconds = Math.addExact(Math.addExact(Math.multiplyExact(hours, 3600), Math.multiplyExact(minutes, 60)), seconds);
            return Time.seconds(totalSeconds);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static int parseInt(String value) {
        return value == null ? 0 : Integer.parseInt(value);
    }

    public static void executeCommand(String command) {
        try {
            if (Main.server == null) {
                return;
            }
            class_2170 manager = Main.server.method_3734();
            class_2168 commandSource = Main.server.method_3739().method_9217();
            manager.method_44252(commandSource, command);
        }
        catch (Exception e) {
            Main.LOGGER.error("Error executing command: " + command, (Throwable)e);
        }
    }

    public static void throwError(String error) {
        PlayerUtils.broadcastMessageToAdmins(class_2561.method_30163((String)("\u00a7c" + error)));
        Main.LOGGER.error(error);
    }

    public static class_3414 getRandomSound(String name, int from, int to) {
        if (to > from) {
            int index = rnd.nextInt(from, to + 1);
            name = (String)name + index;
        }
        return class_3414.method_47908((class_2960)IdentifierHelper.vanilla((String)name));
    }

    public static String getTimeAndDate() {
        LocalDateTime time = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return time.format(formatter);
    }

    public static void reloadServerNoUpdate() {
        Events.skipNextTickReload = true;
        OtherUtils.reloadServer();
    }

    public static void reloadServer() {
        try {
            int inInterval = 0;
            if (reloads.size() >= 3) {
                int size = reloads.size();
                if (System.currentTimeMillis() - reloads.get(size - 1) < 5000L) {
                    ++inInterval;
                }
                if (System.currentTimeMillis() - reloads.get(size - 2) < 5000L) {
                    ++inInterval;
                }
                if (System.currentTimeMillis() - reloads.get(size - 3) < 5000L) {
                    ++inInterval;
                }
            }
            if (inInterval >= 3) {
                Main.LOGGER.error("Detected and prevented possible reload loop!");
                return;
            }
            reloads.add(System.currentTimeMillis());
            OtherUtils.executeCommand("reload");
        }
        catch (Exception e) {
            Main.LOGGER.error("Error reloading server", (Throwable)e);
        }
    }

    public static void sendCommandFeedback(class_2168 source, class_2561 text) {
        if (source == null || text == null) {
            return;
        }
        source.method_9226(() -> text, true);
    }

    public static void sendCommandFeedbackQuiet(class_2168 source, class_2561 text) {
        if (source == null || text == null) {
            return;
        }
        source.method_9226(() -> text, false);
    }

    public static UUID profileId(GameProfile profile) {
        return profile.id();
    }

    public static String profileName(GameProfile profile) {
        return profile.name();
    }

    public static boolean getBooleanGameRule(class_3218 level, class_12279<?> gamerule) {
        Object object = level.method_64395().method_76185(gamerule);
        if (object instanceof Boolean) {
            Boolean bool = (Boolean)object;
            return bool;
        }
        return false;
    }

    public static void setBooleanGameRule(class_3218 level, class_12279<Boolean> gamerule, Boolean value) {
        level.method_64395().method_76186(gamerule, (Object)value, Main.server);
    }

    public static void setFreezeGame(boolean frozen) {
        if (Main.server == null) {
            return;
        }
        class_8915 serverTickRateManager = Main.server.method_54833();
        if (serverTickRateManager.method_54754() == frozen) {
            return;
        }
        if (frozen) {
            if (serverTickRateManager.method_54670()) {
                serverTickRateManager.method_54678();
            }
            if (serverTickRateManager.method_54752()) {
                serverTickRateManager.method_54676();
            }
        }
        serverTickRateManager.method_54675(frozen);
        if (frozen) {
            PlayerUtils.broadcastMessageToAdmins(class_2561.method_30163((String)"\u00a77The game is frozen"));
        } else {
            PlayerUtils.broadcastMessageToAdmins(class_2561.method_30163((String)"\u00a77The game is no longer frozen."));
        }
    }

    public static boolean isNumber(String text) {
        try {
            int num = Integer.parseInt(text);
            return true;
        }
        catch (Exception num) {
            try {
                double num2 = Double.parseDouble(text);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    public static double clamp(double value, double min, double max) {
        if (!(min < max)) {
            if (Double.isNaN(min)) {
                throw new IllegalArgumentException("min is NaN");
            }
            if (Double.isNaN(max)) {
                throw new IllegalArgumentException("max is NaN");
            }
            if (Double.compare(min, max) > 0) {
                throw new IllegalArgumentException(min + " > " + max);
            }
        }
        return Math.min(max, Math.max(value, min));
    }

    public static float clamp(float value, float min, float max) {
        if (!(min < max)) {
            if (Double.isNaN(min)) {
                throw new IllegalArgumentException("min is NaN");
            }
            if (Double.isNaN(max)) {
                throw new IllegalArgumentException("max is NaN");
            }
            if (Double.compare(min, max) > 0) {
                throw new IllegalArgumentException(min + " > " + max);
            }
        }
        return Math.min(max, Math.max(value, min));
    }

    public static int clamp(int value, int min, int max) {
        if (min >= max) {
            if (Double.isNaN(min)) {
                throw new IllegalArgumentException("min is NaN");
            }
            if (Double.isNaN(max)) {
                throw new IllegalArgumentException("max is NaN");
            }
            if (Double.compare(min, max) > 0) {
                throw new IllegalArgumentException(min + " > " + max);
            }
        }
        return Math.min(max, Math.max(value, min));
    }
}

