/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.utils.other;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.mat0u5.lifeseries.Main;
import net.mat0u5.lifeseries.utils.other.Time;

public class TaskScheduler {
    private static final List<Task> tasks = new ArrayList<Task>();
    private static final List<Task> newTasks = new ArrayList<Task>();
    private static boolean clearTasks = false;

    public static void scheduleTask(int ticks, Runnable goal) {
        if (Main.modDisabled()) {
            return;
        }
        Task task = new Task(ticks, goal);
        newTasks.add(task);
    }

    public static void scheduleTask(Time time, Runnable goal) {
        TaskScheduler.scheduleTask(time.getTicks(), goal);
    }

    public static void schedulePriorityTask(Time time, Runnable goal) {
        Task task = new Task(time.getTicks(), goal);
        task.priority = true;
        newTasks.add(task);
    }

    public static void clearTasks() {
        clearTasks = true;
        newTasks.clear();
    }

    public static void registerTickHandler() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            try {
                if (clearTasks) {
                    clearTasks = false;
                    tasks.clear();
                    return;
                }
                Iterator<Task> iterator = tasks.iterator();
                while (iterator.hasNext()) {
                    Task task = iterator.next();
                    --task.tickCount;
                    if (task.tickCount > 0) continue;
                    try {
                        if (!Main.modDisabled() || task.priority) {
                            task.goal.run();
                        }
                    }
                    catch (Exception e) {
                        Main.LOGGER.error("Fatal error while running task " + String.valueOf(task));
                        e.printStackTrace();
                    }
                    iterator.remove();
                }
                tasks.addAll(newTasks);
                newTasks.clear();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static class Task {
        private int tickCount;
        private final Runnable goal;
        public boolean priority = false;

        public Task(int tickCount, Runnable goal) {
            this.tickCount = tickCount;
            this.goal = goal;
        }
    }
}

