/*
 * Decompiled with CFR 0.152.
 */
package net.mat0u5.lifeseries.utils.other;

import net.mat0u5.lifeseries.utils.other.TextUtils;

public class Time {
    public static long CONVERT_MILLIS = 1000L;
    public static long CONVERT_TICKS = 50000L;
    public static long CONVERT_SECONDS = 1000000L;
    public static long CONVERT_MINUTES = 60000000L;
    public static long CONVERT_HOURS = 3600000000L;
    private Long nanos;

    public Time(Long nanos) {
        this.nanos = nanos;
    }

    public Time(int nanos) {
        this.nanos = nanos;
    }

    public long getNanos() {
        return this.nanos;
    }

    public long getMillis() {
        return this.nanos / CONVERT_MILLIS;
    }

    public int getTicks() {
        return (int)(this.nanos / CONVERT_TICKS);
    }

    public int getSeconds() {
        return (int)(this.nanos / CONVERT_SECONDS);
    }

    public int getMinutes() {
        return (int)(this.nanos / CONVERT_MINUTES);
    }

    public int getHours() {
        return (int)(this.nanos / CONVERT_HOURS);
    }

    public Time tick() {
        return this.add(CONVERT_TICKS);
    }

    public Time add(Time time) {
        if (this.nanos == null) {
            this.nanos = 0L;
        }
        this.nanos = this.nanos + time.getNanos();
        return this;
    }

    public Time add(long time) {
        if (this.nanos == null) {
            this.nanos = 0L;
        }
        this.nanos = this.nanos + time;
        return this;
    }

    public Time multiply(long scale) {
        if (this.nanos == null) {
            this.nanos = 0L;
        }
        this.nanos = this.nanos * scale;
        return this;
    }

    public boolean isPresent() {
        return this.nanos != null;
    }

    public boolean isMultipleOf(Time interval) {
        return this.nanos % interval.getNanos() == 0L;
    }

    public Time diff(Time time2) {
        return new Time(this.getNanos() - time2.getNanos());
    }

    public boolean isLarger(Time time2) {
        return this.getNanos() >= time2.getNanos();
    }

    public boolean isSmaller(Time time2) {
        return this.getNanos() <= time2.getNanos();
    }

    public Time copy() {
        return new Time(this.nanos);
    }

    public String formatReadable() {
        int seconds = this.getSeconds();
        boolean isNegative = seconds < 0;
        seconds = Math.abs(seconds);
        int hours = seconds / 3600;
        int remainingSeconds = seconds % 3600;
        int minutes = remainingSeconds / 60;
        int secs = remainingSeconds % 60;
        if (hours > 0 && minutes == 0 && secs == 0) {
            return (isNegative ? "-" : "+") + hours + (hours == 1 ? " hour" : " hours");
        }
        if (hours == 0 && minutes > 0 && secs == 0) {
            return (isNegative ? "-" : "+") + minutes + (minutes == 1 ? " minute" : " minutes");
        }
        if (hours == 0 && minutes == 0 && secs > 0) {
            return (isNegative ? "-" : "+") + secs + (secs == 1 ? " second" : " seconds");
        }
        return String.format("%s%d:%02d:%02d", isNegative ? "-" : "+", hours, minutes, secs);
    }

    public String formatLong() {
        long totalSeconds = (long)Math.ceil((double)this.nanos.longValue() / 1000000.0);
        long hours = totalSeconds / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        return TextUtils.formatString("{}:{}:{}", hours, Time.formatTimeNumber(minutes), Time.formatTimeNumber(seconds));
    }

    public String format() {
        long totalSeconds = (long)Math.ceil((double)this.nanos.longValue() / 1000000.0);
        long hours = totalSeconds / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        if (hours == 0L) {
            return TextUtils.formatString("{}:{}", Time.formatTimeNumber(minutes), Time.formatTimeNumber(seconds));
        }
        return TextUtils.formatString("{}:{}:{}", hours, Time.formatTimeNumber(minutes), Time.formatTimeNumber(seconds));
    }

    private static String formatTimeNumber(long time) {
        Object value = String.valueOf(time);
        while (((String)value).length() < 2) {
            value = "0" + (String)value;
        }
        return value;
    }

    public static Time hours(int hours) {
        return new Time((long)hours * CONVERT_HOURS);
    }

    public static Time minutes(int minutes) {
        return new Time((long)minutes * CONVERT_MINUTES);
    }

    public static Time minutes(double minutes) {
        return new Time((long)minutes * CONVERT_MINUTES);
    }

    public static Time seconds(int seconds) {
        return new Time((long)seconds * CONVERT_SECONDS);
    }

    public static Time ticks(int ticks) {
        return new Time((long)ticks * CONVERT_TICKS);
    }

    public static Time millis(long millis) {
        return new Time(millis * CONVERT_MILLIS);
    }

    public static Time nanos(long nanos) {
        return new Time(nanos);
    }

    public static Time now() {
        return new Time(System.currentTimeMillis() * CONVERT_MILLIS);
    }

    public static Time nullTime() {
        return new Time(null);
    }

    public static Time zero() {
        return new Time(0L);
    }
}

