/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.world.biome;

import net.caffeinemc.mods.sodium.client.world.BiomeSeedProvider;
import net.caffeinemc.mods.sodium.client.world.LevelSlice;
import net.caffeinemc.mods.sodium.client.world.cloned.ChunkRenderContext;
import net.caffeinemc.mods.sodium.client.world.cloned.ClonedChunkSection;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_3532;
import net.minecraft.class_4540;
import net.minecraft.class_5742;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7522;
import net.minecraft.class_7924;

public class LevelBiomeSlice {
    private static final int SIZE = 12;
    private final class_6880<class_1959>[] biomes = new class_6880[1728];
    private final boolean[] uniform = new boolean[1728];
    private final BiasMap bias = new BiasMap();
    private long biomeZoomSeed;
    private int blockX;
    private int blockY;
    private int blockZ;

    public void update(class_638 level, ChunkRenderContext context) {
        this.blockX = context.getOrigin().method_19527() - 16;
        this.blockY = context.getOrigin().method_19528() - 16;
        this.blockZ = context.getOrigin().method_19529() - 16;
        this.biomeZoomSeed = BiomeSeedProvider.getBiomeZoomSeed(level);
        this.copyBiomeData((class_1937)level, context);
        this.calculateBias();
        this.calculateUniform();
    }

    private void copyBiomeData(class_1937 level, ChunkRenderContext context) {
        class_6880.class_6883 defaultValue = level.method_30349().method_30530(class_7924.field_41236).method_46747(class_1972.field_9451);
        for (int sectionX = 0; sectionX < 3; ++sectionX) {
            for (int sectionY = 0; sectionY < 3; ++sectionY) {
                for (int sectionZ = 0; sectionZ < 3; ++sectionZ) {
                    this.copySectionBiomeData(context, sectionX, sectionY, sectionZ, (class_6880<class_1959>)defaultValue);
                }
            }
        }
    }

    private void copySectionBiomeData(ChunkRenderContext context, int sectionX, int sectionY, int sectionZ, class_6880<class_1959> defaultBiome) {
        ClonedChunkSection section = context.getSections()[LevelSlice.getLocalSectionIndex(sectionX, sectionY, sectionZ)];
        class_7522<class_6880<class_1959>> biomeData = section.getBiomeData();
        for (int relCellX = 0; relCellX < 4; ++relCellX) {
            for (int relCellY = 0; relCellY < 4; ++relCellY) {
                for (int relCellZ = 0; relCellZ < 4; ++relCellZ) {
                    int cellX = sectionX * 4 + relCellX;
                    int cellY = sectionY * 4 + relCellY;
                    int cellZ = sectionZ * 4 + relCellZ;
                    int idx = LevelBiomeSlice.dataArrayIndex(cellX, cellY, cellZ);
                    this.biomes[idx] = biomeData == null ? defaultBiome : (class_6880)biomeData.method_12321(relCellX, relCellY, relCellZ);
                }
            }
        }
    }

    private void calculateUniform() {
        for (int cellX = 2; cellX < 10; ++cellX) {
            for (int cellY = 2; cellY < 10; ++cellY) {
                for (int cellZ = 2; cellZ < 10; ++cellZ) {
                    this.uniform[LevelBiomeSlice.dataArrayIndex((int)cellX, (int)cellY, (int)cellZ)] = this.hasUniformNeighbors(cellX, cellY, cellZ);
                }
            }
        }
    }

    private void calculateBias() {
        int originX = this.blockX >> 2;
        int originY = this.blockY >> 2;
        int originZ = this.blockZ >> 2;
        long seed = this.biomeZoomSeed;
        for (int relCellX = 1; relCellX < 11; ++relCellX) {
            int cellX = originX + relCellX;
            long seedX = class_4540.method_22372((long)seed, (long)cellX);
            for (int relCellY = 1; relCellY < 11; ++relCellY) {
                int cellY = originY + relCellY;
                long seedXY = class_4540.method_22372((long)seedX, (long)cellY);
                for (int relCellZ = 1; relCellZ < 11; ++relCellZ) {
                    int cellZ = originZ + relCellZ;
                    long seedXYZ = class_4540.method_22372((long)seedXY, (long)cellZ);
                    this.calculateBias(LevelBiomeSlice.dataArrayIndex(relCellX, relCellY, relCellZ), cellX, cellY, cellZ, seedXYZ);
                }
            }
        }
    }

    private void calculateBias(int cellIndex, int cellX, int cellY, int cellZ, long seed) {
        seed = class_4540.method_22372((long)seed, (long)cellX);
        seed = class_4540.method_22372((long)seed, (long)cellY);
        seed = class_4540.method_22372((long)seed, (long)cellZ);
        int gradX = LevelBiomeSlice.getBias(seed);
        seed = class_4540.method_22372((long)seed, (long)this.biomeZoomSeed);
        int gradY = LevelBiomeSlice.getBias(seed);
        seed = class_4540.method_22372((long)seed, (long)this.biomeZoomSeed);
        int gradZ = LevelBiomeSlice.getBias(seed);
        this.bias.set(cellIndex, gradX, gradY, gradZ);
    }

    private boolean hasUniformNeighbors(int cellX, int cellY, int cellZ) {
        class_1959 biome = (class_1959)this.biomes[LevelBiomeSlice.dataArrayIndex(cellX, cellY, cellZ)].comp_349();
        int cellMinX = cellX - 1;
        int cellMaxX = cellX + 1;
        int cellMinY = cellY - 1;
        int cellMaxY = cellY + 1;
        int cellMinZ = cellZ - 1;
        int cellMaxZ = cellZ + 1;
        for (int adjCellX = cellMinX; adjCellX <= cellMaxX; ++adjCellX) {
            for (int adjCellY = cellMinY; adjCellY <= cellMaxY; ++adjCellY) {
                for (int adjCellZ = cellMinZ; adjCellZ <= cellMaxZ; ++adjCellZ) {
                    if (this.biomes[LevelBiomeSlice.dataArrayIndex(adjCellX, adjCellY, adjCellZ)].comp_349() == biome) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public class_6880<class_1959> getBiome(int blockX, int blockY, int blockZ) {
        int relBlockX = blockX - this.blockX;
        int relBlockY = blockY - this.blockY;
        int relBlockZ = blockZ - this.blockZ;
        int centerIndex = LevelBiomeSlice.dataArrayIndex(class_5742.method_33100((int)(relBlockX - 2)), class_5742.method_33100((int)(relBlockY - 2)), class_5742.method_33100((int)(relBlockZ - 2)));
        if (this.uniform[centerIndex]) {
            return this.biomes[centerIndex];
        }
        return this.getBiomeUsingVoronoi(relBlockX, relBlockY, relBlockZ);
    }

    private class_6880<class_1959> getBiomeUsingVoronoi(int blockX, int blockY, int blockZ) {
        int x = blockX - 2;
        int y = blockY - 2;
        int z = blockZ - 2;
        int originIntX = class_5742.method_33100((int)x);
        int originIntY = class_5742.method_33100((int)y);
        int originIntZ = class_5742.method_33100((int)z);
        float originFracX = (float)class_5742.method_39920((int)x) * 0.25f;
        float originFracY = (float)class_5742.method_39920((int)y) * 0.25f;
        float originFracZ = (float)class_5742.method_39920((int)z) * 0.25f;
        float closestDistance = Float.POSITIVE_INFINITY;
        int closestArrayIndex = 0;
        for (int index = 0; index < 8; ++index) {
            float distanceZ;
            float distanceY;
            boolean dirX = (index & 4) != 0;
            boolean dirY = (index & 2) != 0;
            boolean dirZ = (index & 1) != 0;
            int cellIntX = originIntX + (dirX ? 1 : 0);
            int cellIntY = originIntY + (dirY ? 1 : 0);
            int cellIntZ = originIntZ + (dirZ ? 1 : 0);
            float cellFracX = originFracX - (dirX ? 1.0f : 0.0f);
            float cellFracY = originFracY - (dirY ? 1.0f : 0.0f);
            float cellFracZ = originFracZ - (dirZ ? 1.0f : 0.0f);
            int biasIndex = LevelBiomeSlice.dataArrayIndex(cellIntX, cellIntY, cellIntZ);
            float biasX = LevelBiomeSlice.biasToVector(this.bias.getX(biasIndex));
            float biasY = LevelBiomeSlice.biasToVector(this.bias.getY(biasIndex));
            float biasZ = LevelBiomeSlice.biasToVector(this.bias.getZ(biasIndex));
            float distanceX = class_3532.method_27285((float)(cellFracX + biasX));
            float distance = distanceX + (distanceY = class_3532.method_27285((float)(cellFracY + biasY))) + (distanceZ = class_3532.method_27285((float)(cellFracZ + biasZ)));
            if (!(closestDistance > distance)) continue;
            closestArrayIndex = biasIndex;
            closestDistance = distance;
        }
        return this.biomes[closestArrayIndex];
    }

    private static int dataArrayIndex(int cellX, int cellY, int cellZ) {
        return cellX * 12 * 12 + cellY * 12 + cellZ;
    }

    private static float biasToVector(int bias) {
        return (float)bias * 9.765625E-4f * 0.9f;
    }

    private static int getBias(long l) {
        return (int)((l >> 24 & 0x3FFL) - 512L);
    }

    public static class BiasMap {
        private final short[] data = new short[5184];

        public void set(int index, int x, int y, int z) {
            this.data[index * 3 + 0] = (short)x;
            this.data[index * 3 + 1] = (short)y;
            this.data[index * 3 + 2] = (short)z;
        }

        public int getX(int index) {
            return this.data[index * 3 + 0];
        }

        public int getY(int index) {
            return this.data[index * 3 + 1];
        }

        public int getZ(int index) {
            return this.data[index * 3 + 2];
        }
    }
}

