/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.minecraft;

import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos;
import com.seibel.distanthorizons.core.render.glObject.GLProxy;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftSharedWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IProfilerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import java.io.File;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.minecraft.ProfilerWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.world.ClientLevelWrapper;
import net.minecraft.class_10209;
import net.minecraft.class_128;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_4063;
import net.minecraft.class_638;
import net.minecraft.class_642;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class MinecraftClientWrapper
implements IMinecraftClientWrapper,
IMinecraftSharedWrapper {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private static final class_310 MINECRAFT = class_310.method_1551();
    public static final MinecraftClientWrapper INSTANCE = new MinecraftClientWrapper();
    private ProfilerWrapper profilerWrapper;

    @Override
    public boolean hasSinglePlayerServer() {
        return MINECRAFT.method_1496();
    }

    @Override
    public boolean clientConnectedToDedicatedServer() {
        return MINECRAFT.method_1558() != null && !this.hasSinglePlayerServer();
    }

    @Override
    public boolean connectedToReplay() {
        return MINECRAFT.method_1558() == null && !this.hasSinglePlayerServer();
    }

    @Override
    public String getCurrentServerName() {
        if (this.connectedToReplay()) {
            return "REPLAY";
        }
        class_642 server = MINECRAFT.method_1558();
        return server != null ? server.field_3752 : "NULL";
    }

    @Override
    public String getCurrentServerIp() {
        if (this.connectedToReplay()) {
            return "";
        }
        class_642 server = MINECRAFT.method_1558();
        return server != null ? server.field_3761 : "NA";
    }

    @Override
    public String getCurrentServerVersion() {
        class_642 server = MINECRAFT.method_1558();
        return server != null ? server.field_3760.getString() : "UNKOWN";
    }

    public class_746 getPlayer() {
        return MinecraftClientWrapper.MINECRAFT.field_1724;
    }

    @Override
    public boolean playerExists() {
        return MinecraftClientWrapper.MINECRAFT.field_1724 != null;
    }

    @Override
    public DhBlockPos getPlayerBlockPos() {
        class_746 player = this.getPlayer();
        if (player == null) {
            return new DhBlockPos(0, 0, 0);
        }
        class_2338 playerPos = player.method_24515();
        return new DhBlockPos(playerPos.method_10263(), playerPos.method_10264(), playerPos.method_10260());
    }

    @Override
    public DhChunkPos getPlayerChunkPos() {
        class_746 player = this.getPlayer();
        if (player == null) {
            return new DhChunkPos(0, 0);
        }
        class_1923 playerPos = player.method_31476();
        return new DhChunkPos(playerPos.field_9181, playerPos.field_9180);
    }

    @Override
    @Nullable
    public IClientLevelWrapper getWrappedClientLevel() {
        return this.getWrappedClientLevel(false);
    }

    @Override
    @Nullable
    public IClientLevelWrapper getWrappedClientLevel(boolean bypassLevelKeyManager) {
        class_638 level = MinecraftClientWrapper.MINECRAFT.field_1687;
        if (level == null) {
            return null;
        }
        return ClientLevelWrapper.getWrapper(level, bypassLevelKeyManager);
    }

    @Override
    public void sendChatMessage(String string) {
        class_746 player = this.getPlayer();
        if (player == null) {
            return;
        }
        GLProxy.queueRunningOnRenderThread(() -> player.method_7353((class_2561)class_2561.method_43471((String)string), false));
    }

    @Override
    public void sendOverlayMessage(String string) {
        class_746 player = this.getPlayer();
        if (player == null) {
            return;
        }
        player.method_7353((class_2561)class_2561.method_43471((String)string), true);
    }

    @Override
    public void disableVanillaClouds() {
        MinecraftClientWrapper.MINECRAFT.field_1690.method_42528().method_41748((Object)class_4063.field_18162);
    }

    @Override
    public void disableVanillaChunkFadeIn() {
        MinecraftClientWrapper.MINECRAFT.field_1690.method_76253().method_41748((Object)0.0);
    }

    @Override
    public IProfilerWrapper getProfiler() {
        class_3695 profiler = class_10209.method_64146();
        if (this.profilerWrapper == null) {
            this.profilerWrapper = new ProfilerWrapper(profiler);
        } else if (profiler != this.profilerWrapper.profiler) {
            this.profilerWrapper.profiler = profiler;
        }
        return this.profilerWrapper;
    }

    @Override
    public void crashMinecraft(String errorMessage, Throwable exception) {
        LOGGER.fatal("Distant Horizons had the following error: [" + errorMessage + "]. Crashing Minecraft...", exception);
        class_128 report = new class_128(errorMessage, exception);
        MINECRAFT.method_1494(report);
    }

    @Override
    public Object getOptionsObject() {
        return MinecraftClientWrapper.MINECRAFT.field_1690;
    }

    @Override
    public boolean isDedicatedServer() {
        return false;
    }

    @Override
    public File getInstallationDirectory() {
        return MinecraftClientWrapper.MINECRAFT.field_1697;
    }

    @Override
    public int getPlayerCount() {
        if (MINECRAFT.method_1576() == null) {
            return 1;
        }
        return MINECRAFT.method_1576().method_3788();
    }
}

